/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.foodhistory;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistoryEntry;
import de.siphalor.spiceoffabric.networking.SOFCommonNetworking;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.spiceoffabric.util.queue.ArrayFixedLengthIntFIFOQueue;
import de.siphalor.spiceoffabric.util.queue.FixedLengthIntFIFOQueueWithStats;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class FoodHistory {
    protected static final String DICTIONARY_NBT_KEY = "dictionary";
    protected static final String RECENT_HISTORY_NBT_KEY = "history";
    protected static final String CARROT_HISTORY_NBT_KEY = "carrotHistory";
    protected final BiMap<Integer, FoodHistoryEntry> dictionary = HashBiMap.create();
    protected int nextId = 0;
    protected final FixedLengthIntFIFOQueueWithStats recentlyEaten;
    protected final Set<FoodHistoryEntry> uniqueFoodsEaten;

    public static FoodHistory get(class_1657 player) {
        if (player == null) {
            return null;
        }
        class_1702 hungerManager = player.method_7344();
        if (!(hungerManager instanceof IHungerManager)) {
            return null;
        }
        return ((IHungerManager)hungerManager).spiceOfFabric_getFoodHistory();
    }

    public FoodHistory() {
        this.recentlyEaten = new FixedLengthIntFIFOQueueWithStats(new ArrayFixedLengthIntFIFOQueue(SOFConfig.food.historyLength));
        this.uniqueFoodsEaten = new HashSet<FoodHistoryEntry>();
    }

    public void reset() {
        this.resetHistory();
        this.resetUniqueFoodsEaten();
    }

    public void resetHistory() {
        this.dictionary.clear();
        this.nextId = 0;
        this.recentlyEaten.clear();
    }

    public Set<FoodHistoryEntry> getUniqueFoodsEaten() {
        return this.uniqueFoodsEaten;
    }

    public void resetUniqueFoodsEaten() {
        this.uniqueFoodsEaten.clear();
    }

    public void write(class_2540 buffer) {
        buffer.method_10804(this.dictionary.size());
        for (Map.Entry entry : this.dictionary.entrySet()) {
            buffer.method_10804(((Integer)entry.getKey()).intValue());
            ((FoodHistoryEntry)entry.getValue()).write(buffer);
        }
        buffer.method_10804(this.recentlyEaten.size());
        IntIterator intIterator = this.recentlyEaten.iterator();
        while (intIterator.hasNext()) {
            int integer = (Integer)intIterator.next();
            buffer.method_10804(integer);
        }
        if (SOFConfig.carrot.enable) {
            buffer.method_52964(true);
            buffer.method_10804(this.uniqueFoodsEaten.size());
            for (FoodHistoryEntry entry : this.uniqueFoodsEaten) {
                entry.write(buffer);
            }
        } else {
            buffer.method_52964(false);
        }
    }

    public void read(class_2540 buffer) {
        int i;
        this.dictionary.clear();
        this.recentlyEaten.clear();
        this.recentlyEaten.setLength(SOFConfig.food.historyLength);
        int l = buffer.method_10816();
        for (i = 0; i < l; ++i) {
            this.dictionary.put((Object)buffer.method_10816(), (Object)FoodHistoryEntry.from(buffer));
        }
        l = buffer.method_10816();
        for (i = 0; i < l; ++i) {
            this.recentlyEaten.forceEnqueue(buffer.method_10816());
        }
        this.uniqueFoodsEaten.clear();
        if (buffer.readBoolean()) {
            int length = buffer.method_10816();
            for (i = 0; i < length; ++i) {
                this.uniqueFoodsEaten.add(FoodHistoryEntry.from(buffer));
            }
        }
    }

    public class_2487 write(class_2487 compoundTag) {
        Map.Entry entry2;
        this.defragmentDictionary();
        class_2499 list = new class_2499();
        for (Map.Entry entry2 : this.dictionary.entrySet()) {
            list.method_10531(((Integer)entry2.getKey()).intValue(), (class_2520)((FoodHistoryEntry)entry2.getValue()).write(new class_2487()));
        }
        compoundTag.method_10566(DICTIONARY_NBT_KEY, (class_2520)list);
        class_2499 historyList = new class_2499();
        entry2 = this.recentlyEaten.iterator();
        while (entry2.hasNext()) {
            Integer id = (Integer)entry2.next();
            historyList.add((Object)class_2497.method_23247((int)id));
        }
        compoundTag.method_10566(RECENT_HISTORY_NBT_KEY, (class_2520)historyList);
        class_2499 carrotHistoryList = new class_2499();
        for (FoodHistoryEntry entry3 : this.uniqueFoodsEaten) {
            carrotHistoryList.add((Object)entry3.write(new class_2487()));
        }
        compoundTag.method_10566(CARROT_HISTORY_NBT_KEY, (class_2520)carrotHistoryList);
        return compoundTag;
    }

    public static FoodHistory read(class_2487 compoundTag) {
        FoodHistory foodHistory = new FoodHistory();
        if (compoundTag.method_10573(DICTIONARY_NBT_KEY, 9)) {
            class_2499 nbtDictionary = compoundTag.method_10554(DICTIONARY_NBT_KEY, 10);
            for (int i = 0; i < nbtDictionary.size(); ++i) {
                FoodHistoryEntry entry = new FoodHistoryEntry().read((class_2487)nbtDictionary.method_10534(i));
                if (entry == null) continue;
                foodHistory.dictionary.put((Object)i, (Object)entry);
            }
        }
        foodHistory.nextId = foodHistory.dictionary.size();
        if (compoundTag.method_10573(RECENT_HISTORY_NBT_KEY, 9)) {
            class_2499 nbtRecentHistory = compoundTag.method_10554(RECENT_HISTORY_NBT_KEY, 3);
            for (class_2520 tag : nbtRecentHistory) {
                foodHistory.recentlyEaten.forceEnqueue(((class_2497)tag).method_10701());
            }
        }
        if (compoundTag.method_10573(CARROT_HISTORY_NBT_KEY, 9)) {
            class_2499 nbtCarrotHistory = compoundTag.method_10554(CARROT_HISTORY_NBT_KEY, 10);
            for (class_2520 tag : nbtCarrotHistory) {
                class_2487 carrotEntry;
                FoodHistoryEntry entry;
                if (!(tag instanceof class_2487) || (entry = new FoodHistoryEntry().read(carrotEntry = (class_2487)tag)) == null) continue;
                foodHistory.uniqueFoodsEaten.add(entry);
            }
        }
        return foodHistory;
    }

    public void defragmentDictionary() {
        Int2IntArrayMap oldToNewMap = new Int2IntArrayMap();
        int i = 0;
        for (Integer id : this.dictionary.keySet()) {
            oldToNewMap.put(id.intValue(), i);
            ++i;
        }
        this.nextId = i;
        int historySize = this.recentlyEaten.size();
        for (int j = 0; j < historySize; ++j) {
            this.recentlyEaten.enqueue(oldToNewMap.get(this.recentlyEaten.dequeue()));
        }
        HashBiMap newDictionary = HashBiMap.create();
        for (Map.Entry entry : this.dictionary.entrySet()) {
            newDictionary.put((Object)oldToNewMap.get(((Integer)entry.getKey()).intValue()), (Object)((FoodHistoryEntry)entry.getValue()));
        }
        this.dictionary.clear();
        this.dictionary.putAll((Map)newDictionary);
    }

    public int getTimesRecentlyEaten(class_1799 stack) {
        Integer id = (Integer)this.dictionary.inverse().get((Object)FoodHistoryEntry.fromItemStack(stack));
        if (id == null) {
            return 0;
        }
        return this.recentlyEaten.getStats().getOrDefault(id.intValue(), 0);
    }

    public int getFoodCountSinceLastEaten(class_1799 stack) {
        Integer id = (Integer)this.dictionary.inverse().get((Object)FoodHistoryEntry.fromItemStack(stack));
        if (id == null) {
            return -1;
        }
        IntIterator iterator = this.recentlyEaten.iterator();
        int foundI = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            ++foundI;
            if (iterator.nextInt() != id.intValue()) continue;
            foundI = 0;
        }
        return foundI;
    }

    public void addFood(class_1799 stack, class_3222 player) {
        FoodHistoryEntry entry = FoodHistoryEntry.fromItemStack(stack);
        if (SpiceOfFabric.hasClientMod(player)) {
            SOFCommonNetworking.sendAddFoodPacket(player, entry);
        }
        this.addFood(entry);
    }

    public void addFood(FoodHistoryEntry entry) {
        int id;
        Integer boxedId = (Integer)this.dictionary.inverse().get((Object)entry);
        if (boxedId == null) {
            id = this.nextId++;
            this.dictionary.put((Object)id, (Object)entry);
        } else {
            id = boxedId;
        }
        if (this.recentlyEaten.getLength() != SOFConfig.food.historyLength) {
            this.recentlyEaten.setLength(SOFConfig.food.historyLength);
        }
        this.recentlyEaten.forceEnqueue(id);
        if (SOFConfig.carrot.enable) {
            this.uniqueFoodsEaten.add(entry);
        }
    }

    public int getRecentlyEatenCount() {
        return this.recentlyEaten.size();
    }

    public class_1799 getStackFromRecentlyEaten(int index) {
        if (index < 0 || index >= this.recentlyEaten.size()) {
            return null;
        }
        return ((FoodHistoryEntry)this.dictionary.get((Object)this.recentlyEaten.get(index))).getStack();
    }

    public boolean isInUniqueEaten(class_1799 stack) {
        FoodHistoryEntry entry = FoodHistoryEntry.fromItemStack(stack);
        return this.uniqueFoodsEaten.contains(entry);
    }

    public int getCarrotHealthOffset(class_1657 player) {
        class_1324 maxHealthAttr = player.method_5996(class_5134.field_23716);
        SOFConfig.setHealthFormulaExpressionValues(this.uniqueFoodsEaten.size(), (int)maxHealthAttr.method_6201());
        int newMaxHealth = class_3532.method_15357((double)SOFConfig.healthFormulaExpression.evaluate());
        if (SOFConfig.carrot.maxHealth > 0) {
            newMaxHealth = class_3532.method_15340((int)newMaxHealth, (int)1, (int)SOFConfig.carrot.maxHealth);
        }
        return newMaxHealth - (int)maxHealthAttr.method_6201();
    }

    public int getCarrotMaxHealth(class_1657 player) {
        class_1324 maxHealthAttr = player.method_5996(class_5134.field_23716);
        SOFConfig.setHealthFormulaExpressionValues(this.uniqueFoodsEaten.size(), (int)maxHealthAttr.method_6201());
        return class_3532.method_15357((double)SOFConfig.healthFormulaExpression.evaluate());
    }
}

