package de.siphalor.tweed;

import com.google.common.base.CaseFormat;
import de.siphalor.tweed.config.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class Tweed implements ModInitializer {
	public static final String MOD_ID = "tweed";
	public static final class_2960 CONFIG_SYNC_S2C_PACKET = new class_2960(MOD_ID, "sync_config");
	public static final class_2960 REQUEST_SYNC_C2S_PACKET = new class_2960(MOD_ID, "request_sync");
	public static final class_2960 TWEED_CLOTH_SYNC_C2S_PACKET = new class_2960(MOD_ID, "sync_from_cloth_client");

	public static final Logger LOGGER = LogManager.getLogger(MOD_ID);

	public static final char PATH_DELIMITER = '.';
	public static final String mainConfigDirectory = FabricLoader.getInstance().getConfigDirectory().getAbsolutePath() + File.separator;

	public static final List<MinecraftServer> MINECRAFT_SERVERS = new LinkedList<>();

	@Override
	public void onInitialize() {
		ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new SimpleSynchronousResourceReloadListener() {
			@Override
			public class_2960 getFabricId() {
				return new class_2960(Tweed.MOD_ID, "data_listener");
			}

			@Override
			public void method_14491(class_3300 resourceManager) {
				try {
					ConfigLoader.loadConfigs(resourceManager, ConfigEnvironment.SERVER, ConfigScope.SMALLEST);
				} catch (Throwable e) {
					Tweed.LOGGER.error("Tweed failed to load config files:");
					e.printStackTrace();
				}
			}
		});

		ServerSidePacketRegistry.INSTANCE.register(REQUEST_SYNC_C2S_PACKET, (packetContext, packetByteBuf) -> {
			String fileName = packetByteBuf.method_10800(32767);
            for(ConfigFile configFile : TweedRegistry.getConfigFiles()) {
            	if(configFile.getName().equals(fileName)) {
            		if(Objects.requireNonNull(packetContext.getPlayer().method_5682()).method_3835(packetContext.getPlayer().method_7334()) == 4) {
						configFile.syncToClient((class_3222) packetContext.getPlayer(), packetByteBuf.method_10818(ConfigEnvironment.class), packetByteBuf.method_10818(ConfigScope.class), packetByteBuf.method_10818(ConfigOrigin.class));
					} else {
            			packetByteBuf.method_10818(ConfigEnvironment.class);
            			ConfigScope scope = packetByteBuf.method_10818(ConfigScope.class);
            			packetByteBuf.method_10818(ConfigOrigin.class);
						configFile.syncToClient((class_3222) packetContext.getPlayer(), ConfigEnvironment.SYNCED, scope, ConfigOrigin.DATAPACK);
					}
            		break;
				}
			}
		});
		ServerSidePacketRegistry.INSTANCE.register(TWEED_CLOTH_SYNC_C2S_PACKET, ((packetContext, packetByteBuf) -> {
			String fileName = packetByteBuf.method_10800(32767);
			for(ConfigFile configFile : TweedRegistry.getConfigFiles()) {
				if(configFile.getName().equals(fileName)) {
					if(Objects.requireNonNull(packetContext.getPlayer().method_5682()).method_3835(packetContext.getPlayer().method_7334()) == 4) {
						ConfigEnvironment environment = packetByteBuf.method_10818(ConfigEnvironment.class);
						ConfigScope scope = packetByteBuf.method_10818(ConfigScope.class);
						configFile.read(packetByteBuf, environment, ConfigScope.SMALLEST, ConfigOrigin.MAIN);
						ConfigLoader.updateMainConfigFile(configFile, environment, scope);
					} else {
                        packetByteBuf.clear();
					}
					break;
				}
			}
		}));

		Tweed.runEntryPoints();
	}

	public static void runEntryPoints() {
		FabricLoader loaderAPI = FabricLoader.getInstance();

		{
			List<TweedInitializer> initializers = loaderAPI.getEntrypoints(Tweed.MOD_ID + ":init", TweedInitializer.class);
			initializers.forEach(TweedInitializer::register);
			initializers.forEach(TweedInitializer::init);
		}

		if (loaderAPI.getEnvironmentType() == EnvType.CLIENT) {
			List<TweedClientInitializer> initializers = loaderAPI.getEntrypoints(Tweed.MOD_ID + ":client_init", TweedClientInitializer.class);
			initializers.forEach(TweedClientInitializer::registerClient);
		}

		List<EntrypointContainer<Object>> entrypoints = loaderAPI.getEntrypointContainers(Tweed.MOD_ID + ":config", Object.class);

		for (EntrypointContainer<Object> entrypoint : entrypoints) {
			try {
				TweedRegistry.registerConfigPOJO(entrypoint.getEntrypoint(), entrypoint.getProvider().getMetadata().getId());
			} catch (RuntimeException e) {
				e.printStackTrace();
			}
		}
	}

}
