package de.siphalor.tweed.config;

import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.data.serializer.ConfigDataSerializer;
import de.siphalor.tweed.data.serializer.GsonSerializer;
import de.siphalor.tweed.data.serializer.HjsonSerializer;
import de.siphalor.tweed.data.serializer.JanksonSerializer;
import de.siphalor.tweed.tailor.Tailor;
import java.util.ArrayList;
import net.minecraft.class_2370;
import net.minecraft.class_2378;

/**
 * Used to register {@link ConfigFile}s.
 */
public class TweedRegistry {
	private static final ArrayList<ConfigFile> CONFIG_FILES = new ArrayList<>();
	public static final class_2378<ConfigDataSerializer<?>> SERIALIZERS = new class_2370<>();
	public static final class_2378<Tailor> TAILORS = new class_2370<>();

	public static ConfigFile registerConfigFile(String fileName) {
		return registerConfigFile(fileName, HjsonSerializer.INSTANCE);
	}

	/**
	 * Registers a new {@link ConfigFile}.
	 * @param fileName the file id which is used (no extension; no subdirectories for now)
	 * @param dataSerializer a serializer for this config file
	 * @return the new {@link ConfigFile}
	 */
	public static ConfigFile registerConfigFile(String fileName, ConfigDataSerializer<?> dataSerializer) {
        ConfigFile configFile = new ConfigFile(fileName, dataSerializer);
        CONFIG_FILES.add(configFile);
        return configFile;
	}

	public static ConfigFile registerConfigPOJO(Object pojo, String modId) throws RuntimeException {
		ConfigFile configFile = POJOConverter.toConfigFile(pojo, modId);
		CONFIG_FILES.add(configFile);
		return configFile;
	}

	/**
	 * Gets a collection of all registered {@link ConfigFile}s.
	 * @return a collection of {@link ConfigFile}s
	 * @see #registerConfigFile(String, ConfigDataSerializer)
	 */
	public static ArrayList<ConfigFile> getConfigFiles() {
		return CONFIG_FILES;
	}

	static {
		class_2378.method_10226(SERIALIZERS, "gson", GsonSerializer.INSTANCE);
		class_2378.method_10226(SERIALIZERS, "hjson", HjsonSerializer.INSTANCE);
		class_2378.method_10226(SERIALIZERS, "jankson", JanksonSerializer.INSTANCE);
	}
}
