package de.siphalor.tweed.config.value.serializer;

import de.siphalor.tweed.data.DataContainer;
import de.siphalor.tweed.data.DataValue;
import java.util.Locale;
import net.minecraft.class_2540;

public class EnumSerializer<E extends Enum<?>> extends ConfigValueSerializer<E> {
	E fallback;

	public EnumSerializer(E fallback) {
		this.fallback = fallback;
	}

	@SuppressWarnings("unchecked")
	@Override
	public E read(DataValue<?> data) {
		if (data.isString()) {
			String str = data.asString().toLowerCase(Locale.ENGLISH);
			for (E value : (E[]) fallback.getClass().getEnumConstants()) {
				if (value.name().toLowerCase(Locale.ENGLISH).equals(str)) {
					return value;
				}
			}
		}
		return fallback;
	}

	@Override
	public <Key> void write(DataContainer<?, Key> dataContainer, Key key, E value) {
		dataContainer.set(key, value.name());
	}

	@SuppressWarnings("unchecked")
	@Override
	public E read(class_2540 packetByteBuf) {
		String str = packetByteBuf.method_10800(32767);
		for (E value : (E[]) fallback.getClass().getEnumConstants()) {
			if (value.name().toLowerCase(Locale.ENGLISH).equals(str)) {
				return value;
			}
		}
		return fallback;
	}

	@Override
	public void write(class_2540 packetByteBuf, E value) {
		packetByteBuf.method_10814(value.name().toLowerCase(Locale.ENGLISH));
	}

	@Override
	public String asString(E value) {
		return value.name();
	}

	@Override
	public Class<E> getType() {
		return (Class<E>) fallback.getClass();
	}
}
