package de.siphalor.tweed.mixin.client;

import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.config.*;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_2540;
import net.minecraft.class_2678;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_634.class)
public class MixinClientPlayNetworkHandler {
	@Inject(method = "onGameJoin", at = @At("RETURN"), require = 0)
	public void onGameJoined(class_2678 packet, CallbackInfo callbackInfo) {
		for(ConfigFile configFile : TweedRegistry.getConfigFiles()) {
			Tweed.LOGGER.info("Requested config sync for " + configFile.getName());
			class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
			packetByteBuf.method_10814(configFile.getName());
			packetByteBuf.method_10817(ConfigEnvironment.SYNCED);
			packetByteBuf.method_10817(ConfigScope.WORLD);
			packetByteBuf.method_10817(ConfigOrigin.DATAPACK);
			ClientSidePacketRegistry.INSTANCE.sendToServer(Tweed.REQUEST_SYNC_C2S_PACKET, packetByteBuf);
		}
	}
}
