/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.client;

import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.TweedClientInitializer;
import de.siphalor.tweed.config.ConfigEnvironment;
import de.siphalor.tweed.config.ConfigFile;
import de.siphalor.tweed.config.ConfigLoader;
import de.siphalor.tweed.config.ConfigOrigin;
import de.siphalor.tweed.config.ConfigScope;
import de.siphalor.tweed.config.TweedRegistry;
import de.siphalor.tweed.tailor.ClothTailor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.server.ServerStartCallback;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

@Environment(value=EnvType.CLIENT)
public class TweedClient
implements ClientModInitializer,
TweedClientInitializer {
    private static Runnable syncRunnable;

    @Override
    public void registerClient() {
        if (FabricLoader.getInstance().isModLoaded("cloth-config2")) {
            class_2378.method_10230(TweedRegistry.TAILORS, (class_2960)new class_2960("tweed", "cloth"), (Object)ClothTailor.INSTANCE);
        }
    }

    public static void setSyncRunnable(Runnable syncRunnable) {
        TweedClient.syncRunnable = syncRunnable;
    }

    public void onInitializeClient() {
        ConfigLoader.initialReload(ConfigEnvironment.UNIVERSAL);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("tweed", "assets_listener");
            }

            public void method_14491(class_3300 resourceManager) {
                try {
                    ConfigLoader.loadConfigs(resourceManager, ConfigEnvironment.CLIENT, ConfigScope.SMALLEST);
                }
                catch (Throwable e) {
                    Tweed.LOGGER.error("Tweed failed to load config files");
                    e.printStackTrace();
                }
            }
        });
        ServerStartCallback.EVENT.register(minecraftServer -> ConfigLoader.loadConfigs((class_3300)minecraftServer.method_3809(), ConfigEnvironment.UNIVERSAL, ConfigScope.WORLD));
        ClientSidePacketRegistry.INSTANCE.register(Tweed.CONFIG_SYNC_S2C_PACKET, (packetContext, packetByteBuf) -> {
            ConfigOrigin origin = (ConfigOrigin)packetByteBuf.method_10818(ConfigOrigin.class);
            String fileName = packetByteBuf.method_19772();
            for (ConfigFile configFile : TweedRegistry.getConfigFiles()) {
                if (!configFile.getName().equals(fileName)) continue;
                configFile.read(packetByteBuf, ConfigEnvironment.SERVER, ConfigScope.WORLD, origin);
                if (syncRunnable == null) continue;
                syncRunnable.run();
                syncRunnable = null;
            }
        });
    }
}

