/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.config;

import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.config.ConfigEnvironment;
import de.siphalor.tweed.config.ConfigOrigin;
import de.siphalor.tweed.config.ConfigReadException;
import de.siphalor.tweed.config.ConfigScope;
import de.siphalor.tweed.config.entry.AbstractBasicEntry;
import de.siphalor.tweed.config.entry.ConfigEntry;
import de.siphalor.tweed.data.DataContainer;
import de.siphalor.tweed.data.DataObject;
import de.siphalor.tweed.data.DataValue;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ConfigCategory
extends AbstractBasicEntry<ConfigCategory> {
    protected Map<String, ConfigEntry<?>> entries = new LinkedHashMap();
    protected class_2960 backgroundTexture;
    private Runnable reloadListener;

    public <T extends ConfigEntry<?>> T register(String name, T configEntry) {
        this.entries.put(name, configEntry);
        if (configEntry.getEnvironment() == ConfigEnvironment.DEFAULT) {
            configEntry.setEnvironment(this.environment);
        }
        if (configEntry.getScope() == ConfigScope.DEFAULT) {
            configEntry.setScope(this.scope);
        }
        return configEntry;
    }

    public ConfigEntry<?> get(String name) {
        return this.entries.get(name);
    }

    @Override
    public void reset(ConfigEnvironment environment, ConfigScope scope) {
        this.entryStream(environment, scope).forEach(entry -> ((ConfigEntry)entry.getValue()).reset(environment, scope));
    }

    @Override
    public String getDescription() {
        return this.comment;
    }

    public ConfigCategory setBackgroundTexture(class_2960 backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public class_2960 getBackgroundTexture() {
        return this.backgroundTexture;
    }

    @Override
    public ConfigCategory setEnvironment(ConfigEnvironment environment) {
        super.setEnvironment(environment);
        this.entries.values().stream().filter(configEntry -> configEntry.getEnvironment() == ConfigEnvironment.DEFAULT).forEach(configEntry -> configEntry.setEnvironment(environment));
        return this;
    }

    @Override
    public ConfigEnvironment getEnvironment() {
        if (this.entries.isEmpty()) {
            return this.environment;
        }
        Iterator<ConfigEntry<?>> iterator = this.entries.values().iterator();
        ConfigEnvironment environment = iterator.next().getEnvironment();
        while (iterator.hasNext()) {
            ConfigEnvironment itEnvironment = iterator.next().getEnvironment();
            while (!environment.contains(itEnvironment)) {
                environment = environment.parent;
            }
        }
        return environment;
    }

    @Override
    public ConfigCategory setScope(ConfigScope scope) {
        super.setScope(scope);
        this.entries.values().stream().filter(configEntry -> configEntry.getScope() == ConfigScope.DEFAULT).forEach(configEntry -> configEntry.setScope(scope));
        return this;
    }

    @Override
    public ConfigScope getScope() {
        if (this.entries.isEmpty()) {
            return this.scope;
        }
        return this.entries.values().stream().map(ConfigEntry::getScope).min((o1, o2) -> o1 == o2 ? 0 : (o1.triggers((ConfigScope)((Object)o2)) ? -1 : 1)).get();
    }

    @Override
    public void read(DataValue<?> dataValue, ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) throws ConfigReadException {
        if (!dataValue.isObject()) {
            throw new ConfigReadException("The entry should be an object (category)");
        }
        DataObject<?> dataObject = dataValue.asObject();
        this.entryStream(environment, scope).filter(entry -> dataObject.has((String)entry.getKey())).forEach(entry -> {
            DataValue value = dataObject.get((String)entry.getKey());
            try {
                ((ConfigEntry)entry.getValue()).read(value, environment, scope, origin);
            }
            catch (ConfigReadException e) {
                Tweed.LOGGER.error("Error reading " + (String)entry.getKey() + ":");
                e.printStackTrace();
                return;
            }
            try {
                ((ConfigEntry)entry.getValue()).applyConstraints();
            }
            catch (ConfigReadException e) {
                Tweed.LOGGER.error("Error reading " + (String)entry.getKey() + " in post-constraints:");
                e.printStackTrace();
            }
        });
        this.onReload();
    }

    @Override
    public void read(class_2540 buf, ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) {
        while (buf.readBoolean()) {
            ConfigEntry<?> entry = this.entries.get(buf.method_10800(Short.MAX_VALUE));
            if (entry != null) {
                entry.read(buf, environment, scope, origin);
                continue;
            }
            throw new RuntimeException("Attempt to sync unknown entry! Aborting.");
        }
        this.onReload();
    }

    @Override
    public void write(class_2540 buf, ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) {
        this.entryStream(environment, scope).forEach(entry -> {
            buf.writeBoolean(true);
            buf.method_10814((String)entry.getKey());
            ((ConfigEntry)entry.getValue()).write(buf, environment, scope, origin);
        });
        buf.writeBoolean(false);
    }

    @Override
    public <Key> void write(DataContainer<?, Key> dataContainer, Key key, ConfigEnvironment environment, ConfigScope scope) {
        DataContainer category = key.equals("") ? dataContainer : (!dataContainer.has(key) ? dataContainer.addObject(key) : dataContainer.get(key).asObject());
        if (!this.comment.equals("")) {
            category.setComment(this.getComment());
        }
        this.entryStream(environment, scope).forEach(entry -> ((ConfigEntry)entry.getValue()).write(category, (String)entry.getKey(), environment, scope));
    }

    public Stream<Map.Entry<String, ConfigEntry<?>>> entryStream() {
        return this.entries.entrySet().stream();
    }

    public Stream<Map.Entry<String, ConfigEntry<?>>> entryStream(ConfigEnvironment environment, ConfigScope scope) {
        return this.entryStream().filter(entry -> ((ConfigEntry)entry.getValue()).getEnvironment().contains(environment) && scope.triggers(((ConfigEntry)entry.getValue()).getScope()));
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public ConfigCategory setReloadListener(Runnable reloadListener) {
        this.reloadListener = reloadListener;
        return this;
    }

    public void onReload() {
        if (this.reloadListener != null) {
            this.reloadListener.run();
        }
    }
}

