/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.config;

import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.config.ConfigCategory;
import de.siphalor.tweed.config.ConfigEnvironment;
import de.siphalor.tweed.config.ConfigOrigin;
import de.siphalor.tweed.config.ConfigReadException;
import de.siphalor.tweed.config.ConfigScope;
import de.siphalor.tweed.config.entry.ConfigEntry;
import de.siphalor.tweed.config.fixers.ConfigEntryFixer;
import de.siphalor.tweed.data.DataObject;
import de.siphalor.tweed.data.DataValue;
import de.siphalor.tweed.data.serializer.ConfigDataSerializer;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.server.PlayerStream;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3545;
import org.apache.commons.lang3.StringUtils;

public class ConfigFile {
    private String name;
    private BiConsumer<ConfigEnvironment, ConfigScope> reloadListener = null;
    private Queue<class_3545<String, ConfigEntryFixer>> configEntryFixers;
    private ConfigDataSerializer<?> dataSerializer;
    private Map<Class<? extends Annotation>, Annotation> tailorAnnotations;
    protected ConfigCategory rootCategory;

    protected ConfigFile(String name, ConfigDataSerializer<?> dataSerializer) {
        this(name, dataSerializer, new ConfigCategory());
    }

    protected ConfigFile(String name, ConfigDataSerializer<?> dataSerializer, ConfigCategory rootCategory) {
        this.name = name;
        this.rootCategory = rootCategory;
        this.dataSerializer = dataSerializer;
        this.configEntryFixers = new ConcurrentLinkedQueue<class_3545<String, ConfigEntryFixer>>();
    }

    public ConfigFile setReloadListener(BiConsumer<ConfigEnvironment, ConfigScope> listener) {
        this.reloadListener = listener;
        return this;
    }

    public ConfigDataSerializer<?> getDataSerializer() {
        return this.dataSerializer;
    }

    public void finishReload(ConfigEnvironment environment, ConfigScope scope) {
        Tweed.LOGGER.info("Reloaded configs for " + this.name + " (" + environment.name().toLowerCase(Locale.ENGLISH) + "/" + scope.name().toLowerCase(Locale.ENGLISH) + ")");
        if (this.reloadListener != null) {
            this.reloadListener.accept(environment, scope);
        }
    }

    public class_2960 getFileIdentifier() {
        return new class_2960("tweed", "config/" + this.getFileName());
    }

    public String getFileName() {
        return this.name + "." + this.dataSerializer.getFileExtension();
    }

    public String getName() {
        return this.name.replace('/', '.');
    }

    public ConfigCategory getRootCategory() {
        return this.rootCategory;
    }

    public void setRootCategory(ConfigCategory rootCategory) {
        this.rootCategory = rootCategory;
    }

    public <T extends ConfigEntry<?>> T register(String name, T entry) {
        String[] parts = StringUtils.split((String)name, (char)'.');
        if (parts.length == 1) {
            this.rootCategory.register(name, entry);
        } else {
            ConfigCategory category = this.rootCategory;
            for (int i = 0; i < parts.length - 1; ++i) {
                ConfigEntry<?> iEntry = category.entries.get(parts[i]);
                if (!(iEntry instanceof ConfigCategory)) {
                    return null;
                }
                category = (ConfigCategory)iEntry;
            }
            category.register(parts[parts.length - 1], entry);
        }
        return entry;
    }

    public void register(String path, ConfigEntryFixer configEntryFixer) {
        this.configEntryFixers.add((class_3545<String, ConfigEntryFixer>)new class_3545((Object)path, (Object)configEntryFixer));
    }

    public DataObject<?> write(DataObject<?> dataObject, ConfigEnvironment environment, ConfigScope scope) {
        this.fixConfig(dataObject);
        this.rootCategory.write(dataObject, "", environment, scope);
        return dataObject;
    }

    public void reset(ConfigEnvironment environment, ConfigScope scope) {
        this.rootCategory.reset(environment, scope);
    }

    public void fixConfig(DataObject<?> dataObject) {
        this.configEntryFixers.forEach(stringConfigEntryFixerPair -> {
            String[] parts = StringUtils.split((String)((String)stringConfigEntryFixerPair.method_15442()), (char)'.');
            DataObject location = dataObject;
            for (int i = 0; i < parts.length - 1; ++i) {
                DataValue dataValue = location.get(parts[i]);
                if (dataValue == null || !dataValue.isObject()) {
                    return;
                }
                location = dataValue.asObject();
            }
            ((ConfigEntryFixer)stringConfigEntryFixerPair.method_15441()).fix(location, parts[parts.length - 1], dataObject);
        });
    }

    public void load(class_3298 resource, ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) {
        DataObject<?> dataObject = this.dataSerializer.read(resource.method_14482());
        try {
            resource.close();
        }
        catch (IOException e) {
            Tweed.LOGGER.error("Failed to close config resource after reading it in resource pack: " + resource.method_14480());
            e.printStackTrace();
        }
        if (dataObject != null) {
            this.load(dataObject, environment, scope, origin);
        }
    }

    public void load(DataObject<?> dataObject, ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) {
        this.fixConfig(dataObject);
        try {
            this.rootCategory.read(dataObject, environment, scope, origin);
        }
        catch (ConfigReadException e) {
            Tweed.LOGGER.error("The config file " + this.name + "." + this.dataSerializer.getFileExtension() + " must contain an object!");
        }
    }

    public void syncToClients(ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) {
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_10817((Enum)origin);
        packetByteBuf.method_10814(this.name);
        this.write(packetByteBuf, environment, scope, origin);
        Tweed.MINECRAFT_SERVERS.stream().flatMap(PlayerStream::all).forEach(serverPlayerEntity -> ServerSidePacketRegistry.INSTANCE.sendToPlayer((class_1657)serverPlayerEntity, Tweed.CONFIG_SYNC_S2C_PACKET, packetByteBuf));
    }

    public void syncToClient(class_3222 playerEntity, ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) {
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_10817((Enum)origin);
        packetByteBuf.method_10814(this.name);
        this.write(packetByteBuf, environment, scope, origin);
        ServerSidePacketRegistry.INSTANCE.sendToPlayer((class_1657)playerEntity, Tweed.CONFIG_SYNC_S2C_PACKET, packetByteBuf);
    }

    public void syncToServer(ConfigEnvironment environment, ConfigScope scope) {
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_10814(this.name);
        packetByteBuf.method_10817((Enum)environment);
        packetByteBuf.method_10817((Enum)scope);
        this.write(packetByteBuf, environment, scope, ConfigOrigin.MAIN);
        ClientSidePacketRegistry.INSTANCE.sendToServer(Tweed.TWEED_CLOTH_SYNC_C2S_PACKET, packetByteBuf);
    }

    protected void write(class_2540 buffer, ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) {
        this.rootCategory.write(buffer, environment, scope, origin);
    }

    public void read(class_2540 buffer, ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) {
        this.rootCategory.read(buffer, environment, scope, origin);
        if (this.reloadListener != null) {
            this.reloadListener.accept(environment, scope);
        }
    }

    public ConfigFile setBackgroundTexture(class_2960 path) {
        this.rootCategory.setBackgroundTexture(path);
        return this;
    }

    public ConfigFile setComment(String comment) {
        this.rootCategory.setComment(comment);
        return this;
    }

    public ConfigFile setEnvironment(ConfigEnvironment environment) {
        this.rootCategory.setEnvironment(environment);
        return this;
    }

    public ConfigFile setScope(ConfigScope scope) {
        this.rootCategory.setScope(scope);
        return this;
    }

    public void addTailorData(Annotation annotation) {
        if (this.tailorAnnotations == null) {
            this.tailorAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        }
        this.tailorAnnotations.put(annotation.annotationType(), annotation);
    }

    public void addTailorAnnotations(Collection<Annotation> annotations) {
        if (this.tailorAnnotations == null) {
            this.tailorAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        }
        annotations.forEach(a -> this.tailorAnnotations.put(a.annotationType(), (Annotation)a));
    }

    public void addTailorAnnotations(Annotation ... annotations) {
        if (this.tailorAnnotations == null) {
            this.tailorAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        }
        for (Annotation a : annotations) {
            this.tailorAnnotations.put(a.annotationType(), a);
        }
    }

    public <T extends Annotation> T getTailorAnnotation(Class<T> clazz) {
        if (clazz == null || this.tailorAnnotations == null) {
            return null;
        }
        return (T)this.tailorAnnotations.get(clazz);
    }
}

