/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.config.value;

import de.siphalor.tweed.config.value.serializer.BooleanSerializer;
import de.siphalor.tweed.config.value.serializer.ConfigValueSerializer;
import de.siphalor.tweed.config.value.serializer.EnumSerializer;
import de.siphalor.tweed.config.value.serializer.FloatSerializer;
import de.siphalor.tweed.config.value.serializer.IntegerSerializer;
import de.siphalor.tweed.config.value.serializer.ListSerializer;
import de.siphalor.tweed.config.value.serializer.StringConvertibleSerializer;
import de.siphalor.tweed.config.value.serializer.StringSerializer;
import de.siphalor.tweed.util.StaticStringConvertible;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public abstract class ConfigValue<V> {
    private static final BooleanSerializer BOOLEAN_SERIALIZER = new BooleanSerializer();
    private static final FloatSerializer FLOAT_SERIALIZER = new FloatSerializer();
    private static final IntegerSerializer INTEGER_SERIALIZER = new IntegerSerializer();
    private static final StringSerializer STRING_SERIALIZER = new StringSerializer();

    public abstract V get();

    public abstract void set(V var1);

    public static BooleanSerializer booleanSerializer() {
        return BOOLEAN_SERIALIZER;
    }

    public static <E extends Enum<?>> EnumSerializer<E> enumSerializer(E fallback) {
        return new EnumSerializer<E>(fallback);
    }

    public static <T extends StaticStringConvertible<T>> StringConvertibleSerializer<T> stringConvertibleSerializer(T fallback) {
        return new StringConvertibleSerializer<T>(fallback);
    }

    public static FloatSerializer floatSerializer() {
        return FLOAT_SERIALIZER;
    }

    public static IntegerSerializer integerSerializer() {
        return INTEGER_SERIALIZER;
    }

    public static <E> ListSerializer<E, ArrayList<E>> listSerializer(ConfigValueSerializer<E> elementSerializer) {
        return new ListSerializer<E, ArrayList>(elementSerializer, ArrayList::new);
    }

    public static <E, L extends List<E>> ListSerializer<E, L> listSerializer(ConfigValueSerializer<E> elementSerializer, Supplier<L> listSupplier) {
        return new ListSerializer<E, L>(elementSerializer, listSupplier);
    }

    public static StringSerializer stringSerializer() {
        return STRING_SERIALIZER;
    }

    public static ConfigValueSerializer<?> serializer(Object value) {
        return ConfigValue.serializer(value, value.getClass());
    }

    public static ConfigValueSerializer<?> serializer(Object value, Class<?> clazz) {
        ConfigValueSerializer<?> serializer = ConfigValue.serializerByClass(clazz);
        if (serializer == null) {
            return ConfigValue.specialSerializer(value);
        }
        return serializer;
    }

    public static ConfigValueSerializer<?> specialSerializer(Object defaultValue) {
        if (defaultValue instanceof Enum) {
            return ConfigValue.enumSerializer((Enum)defaultValue);
        }
        if (defaultValue instanceof StaticStringConvertible) {
            return ConfigValue.stringConvertibleSerializer((StaticStringConvertible)defaultValue);
        }
        return null;
    }

    public static ConfigValueSerializer<?> serializerByClass(Class<?> clazz) {
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return ConfigValue.booleanSerializer();
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return ConfigValue.floatSerializer();
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return ConfigValue.integerSerializer();
        }
        if (clazz == String.class) {
            return ConfigValue.stringSerializer();
        }
        return null;
    }
}

