/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.tailor;

import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.client.CustomNoticeScreen;
import de.siphalor.tweed.client.TweedClient;
import de.siphalor.tweed.config.ConfigEnvironment;
import de.siphalor.tweed.config.ConfigFile;
import de.siphalor.tweed.config.ConfigLoader;
import de.siphalor.tweed.config.ConfigOrigin;
import de.siphalor.tweed.config.ConfigScope;
import de.siphalor.tweed.config.constraints.ConstraintException;
import de.siphalor.tweed.config.entry.ConfigEntry;
import de.siphalor.tweed.config.entry.ValueConfigEntry;
import de.siphalor.tweed.tailor.ClothData;
import de.siphalor.tweed.tailor.DropdownMaterial;
import de.siphalor.tweed.tailor.Tailor;
import io.github.prospector.modmenu.api.ConfigScreenFactory;
import io.netty.buffer.Unpooled;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_1074;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ClothTailor
extends Tailor {
    public static final ClothTailor INSTANCE = new ClothTailor();
    protected static final String SCREEN_NAME_PREFIX = "tweed.cloth.";
    protected boolean waitingForFile;
    private static final Map<Class<?>, EntryConverter<?>> ENTRY_CONVERTERS = new HashMap();
    private Map<String, ConfigScreenFactory<?>> screenFactories = new HashMap();

    @Override
    public void process(ConfigFile configFile) {
        String modId = configFile.getName();
        ClothData clothData = configFile.getTailorAnnotation(ClothData.class);
        if (clothData != null && !clothData.modid().isEmpty()) {
            modId = clothData.modid();
        }
        this.screenFactories.put(modId, parent -> this.convert(configFile, parent));
    }

    public Map<String, ConfigScreenFactory<?>> getScreenFactories() {
        return this.screenFactories;
    }

    public class_437 convert(ConfigFile configFile, class_437 parentScreen) {
        boolean inGame;
        boolean bl = inGame = class_310.method_1551().field_1687 != null;
        if (inGame && configFile.getRootCategory().getEnvironment() != ConfigEnvironment.CLIENT) {
            return new CustomNoticeScreen(() -> {
                this.waitingForFile = true;
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.method_10814(configFile.getName());
                buf.method_10817((Enum)ConfigEnvironment.UNIVERSAL);
                buf.method_10817((Enum)ConfigScope.SMALLEST);
                buf.method_10817((Enum)ConfigOrigin.MAIN);
                ClientSidePacketRegistry.INSTANCE.sendToServer(Tweed.REQUEST_SYNC_C2S_PACKET, buf);
                TweedClient.setSyncRunnable(() -> {
                    if (this.waitingForFile) {
                        this.waitingForFile = false;
                        class_310.method_1551().method_1507(this.buildConfigScreen(configFile, parentScreen));
                    }
                });
            }, () -> {
                this.waitingForFile = false;
                class_310.method_1551().method_1507(parentScreen);
            }, (class_2561)new class_2588("tweed.gui.screen.syncFromServer", new Object[0]), (class_2561)new class_2588("tweed.gui.screen.syncFromServer.note", new Object[0]));
        }
        return this.buildConfigScreen(configFile, parentScreen);
    }

    public class_437 buildConfigScreen(ConfigFile configFile, class_437 parentScreen) {
        String path = SCREEN_NAME_PREFIX + configFile.getName();
        ConfigBuilder configBuilder = ConfigBuilder.create();
        configBuilder.setParentScreen(parentScreen);
        if (configFile.getRootCategory().getBackgroundTexture() != null) {
            configBuilder.setDefaultBackgroundTexture(configFile.getRootCategory().getBackgroundTexture());
        }
        configBuilder.setSavingRunnable(() -> this.save(configFile));
        configBuilder.setTitle(class_1074.method_4662((String)path, (Object[])new Object[0]));
        if (configFile.getRootCategory().entryStream().allMatch(entry -> entry.getValue() instanceof de.siphalor.tweed.config.ConfigCategory)) {
            configFile.getRootCategory().entryStream().forEach(entry -> this.createCategory(configBuilder, (de.siphalor.tweed.config.ConfigCategory)entry.getValue(), path + "." + (String)entry.getKey()));
        } else {
            this.createCategory(configBuilder, configFile.getRootCategory(), path + ".main");
        }
        return configBuilder.build();
    }

    private void convertCategory(ConfigEntryBuilder entryBuilder, Consumer<AbstractConfigListEntry<?>> registry, de.siphalor.tweed.config.ConfigCategory configCategory, String path) {
        configCategory.entryStream().forEachOrdered(entry -> {
            String subPath = path + "." + (String)entry.getKey();
            if (entry.getValue() instanceof de.siphalor.tweed.config.ConfigCategory) {
                SubCategoryBuilder categoryBuilder = entryBuilder.startSubCategory(class_1074.method_4662((String)subPath, (Object[])new Object[0]));
                categoryBuilder.add((AbstractConfigListEntry)entryBuilder.startTextDescription(((ConfigEntry)entry.getValue()).getDescription()).setColor(Color.GRAY.getRGB()).build());
                this.convertCategory(entryBuilder, arg_0 -> ((SubCategoryBuilder)categoryBuilder).add(arg_0), (de.siphalor.tweed.config.ConfigCategory)entry.getValue(), subPath);
                registry.accept((AbstractConfigListEntry<?>)categoryBuilder.build());
            } else if (entry.getValue() instanceof ValueConfigEntry) {
                Class clazz;
                EntryConverter<?> entryConverter = ENTRY_CONVERTERS.get(clazz);
                block0: for (clazz = ((ValueConfigEntry)entry.getValue()).getType(); clazz != Object.class && entryConverter == null; clazz = clazz.getSuperclass()) {
                    for (Class<?> anInterface : clazz.getInterfaces()) {
                        entryConverter = ENTRY_CONVERTERS.get(anInterface);
                        if (entryConverter != null) break block0;
                    }
                    entryConverter = ENTRY_CONVERTERS.get(clazz);
                }
                if (entryConverter != null) {
                    registry.accept(entryConverter.convert((ValueConfigEntry)entry.getValue(), entryBuilder, subPath));
                } else {
                    Tweed.LOGGER.warn("Couldn't convert config entry of type " + ((ValueConfigEntry)entry.getValue()).getType().getSimpleName() + " to cloth entry!");
                }
            }
        });
    }

    private void createCategory(ConfigBuilder configBuilder, de.siphalor.tweed.config.ConfigCategory configCategory, String name) {
        ConfigCategory clothCategory = configBuilder.getOrCreateCategory(class_1074.method_4662((String)name, (Object[])new Object[0]));
        if (configCategory.getBackgroundTexture() != null) {
            clothCategory.setCategoryBackground(configCategory.getBackgroundTexture());
        }
        clothCategory.addEntry((AbstractConfigListEntry)configBuilder.entryBuilder().startTextDescription(configCategory.getComment()).setColor(Color.GRAY.getRGB()).build());
        this.convertCategory(configBuilder.entryBuilder(), arg_0 -> ((ConfigCategory)clothCategory).addEntry(arg_0), configCategory, name);
    }

    private void save(ConfigFile configFile) {
        if (class_310.method_1551().field_1687 != null) {
            configFile.syncToServer(ConfigEnvironment.UNIVERSAL, ConfigScope.SMALLEST);
            ConfigLoader.updateMainConfigFile(configFile, ConfigEnvironment.UNIVERSAL, ConfigScope.HIGHEST);
            ConfigLoader.loadConfigs(class_310.method_1551().method_1478(), ConfigEnvironment.UNIVERSAL, ConfigScope.SMALLEST);
        } else {
            ConfigLoader.updateMainConfigFile(configFile, ConfigEnvironment.UNIVERSAL, ConfigScope.HIGHEST);
            ConfigLoader.loadConfigs(class_310.method_1551().method_1478(), ConfigEnvironment.UNIVERSAL, ConfigScope.WORLD);
        }
    }

    public static <V> void registerEntryConverter(Class<V> valueType, EntryConverter<V> converter) {
        ENTRY_CONVERTERS.put(valueType, converter);
    }

    public static <V> Optional<String> errorSupplier(V value, ValueConfigEntry<V> configEntry) {
        try {
            configEntry.applyConstraints(value);
        }
        catch (ConstraintException e) {
            return Optional.of(e.getMessage());
        }
        return Optional.empty();
    }

    static {
        ClothTailor.registerEntryConverter(Boolean.class, (configEntry, entryBuilder, langKey) -> entryBuilder.startBooleanToggle(class_1074.method_4662((String)langKey, (Object[])new Object[0]), ((Boolean)configEntry.getMainConfigValue()).booleanValue()).setDefaultValue(configEntry::getDefaultValue).setSaveConsumer(configEntry::setMainConfigValue).setTooltipSupplier(configEntry::getClothyDescription).setErrorSupplier(value -> ClothTailor.errorSupplier(value, configEntry)).build());
        ClothTailor.registerEntryConverter(DropdownMaterial.class, (configEntry, entryBuilder, langKey) -> entryBuilder.startDropdownMenu(class_1074.method_4662((String)langKey, (Object[])new Object[0]), (Object)((DropdownMaterial)configEntry.getMainConfigValue()), input -> {
            for (DropdownMaterial value : ((DropdownMaterial)configEntry.getDefaultValue()).values()) {
                if (!class_1074.method_4662((String)value.getTranslationKey(), (Object[])new Object[0]).equals(input)) continue;
                return value;
            }
            return null;
        }, dropdownMaterial -> class_1074.method_4662((String)dropdownMaterial.getTranslationKey(), (Object[])new Object[0]), (DropdownBoxEntry.SelectionCellCreator)new DropdownBoxEntry.DefaultSelectionCellCreator(dropdownMaterial -> class_1074.method_4662((String)dropdownMaterial.getTranslationKey(), (Object[])new Object[0]))).setDefaultValue(configEntry::getDefaultValue).setSaveConsumer(o -> configEntry.setMainConfigValue((DropdownMaterial)o)).setTooltipSupplier(configEntry::getClothyDescription).setErrorSupplier(value -> ClothTailor.errorSupplier((DropdownMaterial)value, configEntry)).setSelections(((DropdownMaterial)configEntry.getDefaultValue()).values()).build());
        ClothTailor.registerEntryConverter(Enum.class, (configEntry, entryBuilder, langKey) -> entryBuilder.startEnumSelector(class_1074.method_4662((String)langKey, (Object[])new Object[0]), configEntry.getType(), (Enum)configEntry.getMainConfigValue()).setDefaultValue(configEntry::getDefaultValue).setSaveConsumer(o -> configEntry.setMainConfigValue((Enum)o)).setTooltipSupplier(configEntry::getClothyDescription).setErrorSupplier(value -> ClothTailor.errorSupplier((Enum)value, configEntry)).build());
        ClothTailor.registerEntryConverter(Float.class, (configEntry, entryBuilder, langKey) -> entryBuilder.startFloatField(class_1074.method_4662((String)langKey, (Object[])new Object[0]), ((Float)configEntry.getMainConfigValue()).floatValue()).setDefaultValue(configEntry::getDefaultValue).setSaveConsumer(configEntry::setMainConfigValue).setTooltipSupplier(configEntry::getClothyDescription).setErrorSupplier(value -> ClothTailor.errorSupplier(value, configEntry)).build());
        ClothTailor.registerEntryConverter(Integer.class, (configEntry, entryBuilder, langKey) -> entryBuilder.startIntField(class_1074.method_4662((String)langKey, (Object[])new Object[0]), ((Integer)configEntry.getMainConfigValue()).intValue()).setDefaultValue(configEntry::getDefaultValue).setSaveConsumer(configEntry::setMainConfigValue).setTooltipSupplier(configEntry::getClothyDescription).setErrorSupplier(value -> ClothTailor.errorSupplier(value, configEntry)).build());
        ClothTailor.registerEntryConverter(String.class, (configEntry, entryBuilder, langKey) -> entryBuilder.startStrField(class_1074.method_4662((String)langKey, (Object[])new Object[0]), (String)configEntry.getMainConfigValue()).setDefaultValue(configEntry::getDefaultValue).setSaveConsumer(configEntry::setMainConfigValue).setTooltipSupplier(configEntry::getClothyDescription).setErrorSupplier(value -> ClothTailor.errorSupplier(value, configEntry)).build());
    }

    @FunctionalInterface
    public static interface EntryConverter<V> {
        public AbstractConfigListEntry<?> convert(ValueConfigEntry<V> var1, ConfigEntryBuilder var2, String var3);
    }
}

