package de.siphalor.tweed.config.value.serializer;

import de.siphalor.tweed.data.DataContainer;
import de.siphalor.tweed.data.DataValue;
import net.minecraft.class_2540;

public class BooleanSerializer extends ConfigValueSerializer<Boolean> {
	@Override
	public Boolean read(DataValue<?> data) {
		if (data.isBoolean())
			return data.asBoolean();
		return false;
	}

	@Override
	public <Key> void write(DataContainer<?, Key> dataContainer, Key key, Boolean value) {
		dataContainer.set(key, value);
	}

	@Override
	public Boolean read(class_2540 packetByteBuf) {
		return packetByteBuf.readBoolean();
	}

	@Override
	public void write(class_2540 packetByteBuf, Boolean value) {
		packetByteBuf.writeBoolean(value);
	}

	@Override
	public String asString(Boolean value) {
		return value.toString();
	}

	@Override
	public Class<Boolean> getType() {
		return Boolean.class;
	}
}
