package de.siphalor.tweed.config.value.serializer;

import de.siphalor.tweed.config.ConfigReadException;
import de.siphalor.tweed.data.DataContainer;
import de.siphalor.tweed.data.DataValue;
import net.minecraft.class_2540;

public class CharacterSerializer extends ConfigValueSerializer<Character> {
	@Override
	public Character read(DataValue<?> data) throws ConfigReadException {
		return data.asCharacter();
	}

	@Override
	public <Key> void write(DataContainer<?, Key> dataContainer, Key key, Character value) {
		dataContainer.set(key, value);
	}

	@Override
	public Character read(class_2540 packetByteBuf) {
		return packetByteBuf.readChar();
	}

	@Override
	public void write(class_2540 packetByteBuf, Character value) {
		packetByteBuf.writeChar(value);
	}

	@Override
	public String asString(Character value) {
		return String.valueOf(value);
	}

	@Override
	public Class<Character> getType() {
		return Character.class;
	}
}
