/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.client.cloth;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class ClothDropdownSelectEntry<V>
extends TooltipListEntry<V> {
    private static final int MAX_VISIBLE_LINES = 5;
    private V value;
    private final V originalValue;
    private final Supplier<V> defaultValue;
    private final Consumer<V> saveConsumer;
    private final Function<V, class_2561> valueConverter;
    private final V[] options;
    private final class_4185 mainButton;
    private final class_4185 resetButton;
    private boolean optionsVisible = false;
    private int scrollOffset = 0;

    public ClothDropdownSelectEntry(String fieldName, V originalValue, String resetButtonText, Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart, Supplier<V> defaultValue, Consumer<V> saveConsumer, List<V> options, Function<V, class_2561> valueConverter) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.originalValue = originalValue;
        this.defaultValue = defaultValue;
        this.saveConsumer = saveConsumer;
        this.options = options.toArray();
        this.valueConverter = valueConverter;
        this.mainButton = new class_4185(0, 0, 150, 20, resetButtonText, button -> {
            this.optionsVisible = !this.optionsVisible;
            this.scrollOffset = 0;
        });
        this.resetButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_1727(resetButtonText) + 6, 20, resetButtonText, button -> this.setValue(this.getDefaultValue().orElse(null)));
        this.setValue(originalValue);
    }

    public void setValue(V value) {
        this.value = value;
        if (value == null) {
            this.mainButton.setMessage(class_1074.method_4662((String)"tweed.cloth.dropdown.empty", (Object[])new Object[0]));
        } else {
            this.mainButton.setMessage(this.valueConverter.apply(value).method_10851());
        }
        if (this.getScreen() != null && !Objects.equals(this.originalValue, value)) {
            this.getScreen().setEdited(true, this.isRequiresRestart());
        }
    }

    public V getValue() {
        return this.value;
    }

    public Optional<V> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public List<? extends class_364> children() {
        return ImmutableList.of((Object)this.mainButton, (Object)this.resetButton);
    }

    public boolean isEdited() {
        return this.getConfigError().isPresent() || !Objects.equals(this.value, this.originalValue);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (mouseY >= (double)(this.mainButton.y + 20) && mouseY < (double)(this.mainButton.y + 20 + this.getOptionsVisibleLength() * 14) && mouseX >= (double)this.mainButton.x && mouseX < (double)(this.mainButton.x + this.mainButton.getWidth())) {
            this.scrollOffset = class_3532.method_15340((int)(this.scrollOffset - (int)amount), (int)0, (int)Math.max(0, this.options.length - 5 - 1));
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseY >= (double)this.mainButton.y && mouseY < (double)(this.mainButton.y + this.getItemHeight())) {
            int pos;
            if (this.optionsVisible && mouseX >= (double)this.mainButton.x && mouseX < (double)(this.mainButton.x + this.mainButton.getWidth()) && (pos = (int)((mouseY - (double)this.getOptionsTop()) / 14.0)) >= 0 && pos < 5) {
                this.setValue(this.options[pos += this.scrollOffset]);
                this.optionsVisible = false;
                return true;
            }
        } else {
            this.optionsVisible = false;
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public int getOptionsVisibleLength() {
        return Math.min(5, this.options.length);
    }

    public int getItemHeight() {
        return super.getItemHeight() + (this.optionsVisible ? this.getOptionsVisibleLength() * 14 + 5 : 0);
    }

    private int getOptionsTop() {
        return this.mainButton.y + 20 + 3;
    }

    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        class_1041 window = class_310.method_1551().field_1704;
        this.mainButton.active = this.isEditable();
        this.resetButton.active = this.isEditable() && this.getDefaultValue().map(def -> !def.equals(this.value)).orElse(false) != false;
        this.mainButton.y = y;
        this.resetButton.y = y;
        String displayedFieldName = this.getFieldName();
        if (class_310.method_1551().field_1772.method_1726()) {
            class_310.method_1551().field_1772.method_1720(displayedFieldName, (float)(window.method_4486() - x - class_310.method_1551().field_1772.method_1727(displayedFieldName)), (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.x = x;
            this.mainButton.x = x + this.resetButton.getWidth() + 1;
        } else {
            class_310.method_1551().field_1772.method_1720(displayedFieldName, (float)x, (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.x = x + entryWidth - this.resetButton.getWidth();
            this.mainButton.x = x + entryWidth - 150 + 1;
        }
        this.mainButton.setWidth(150 - this.resetButton.getWidth() - 4);
        this.mainButton.render(mouseX, mouseY, delta);
        this.resetButton.render(mouseX, mouseY, delta);
        if (this.optionsVisible) {
            int length = this.getOptionsVisibleLength();
            int top = this.mainButton.y + 20;
            int right = this.mainButton.x + this.mainButton.getWidth();
            int height = length * 14;
            int mousePos = -1;
            if (mouseX >= this.mainButton.x && mouseX < right) {
                mousePos = (mouseY - top - 3) / 14 + this.scrollOffset;
            }
            ClothDropdownSelectEntry.fill((int)this.mainButton.x, (int)top, (int)(this.mainButton.x + this.mainButton.getWidth()), (int)(top + height), (int)-16777216);
            if (this.options.length > length) {
                int l = this.options.length - 1;
                ClothDropdownSelectEntry.fill((int)(right - 3), (int)(top + this.scrollOffset * height / l), (int)right, (int)(top + (5 + this.scrollOffset) * height / l), (int)-4473925);
            }
            for (int i = this.scrollOffset; i < this.scrollOffset + length; ++i) {
                class_310.method_1551().field_1772.method_1729(this.valueConverter.apply(this.options[i]).method_10851(), (float)this.mainButton.x + 3.0f, (float)(top + (i - this.scrollOffset) * 14 + 3), mousePos == i ? -1 : -4473925);
            }
        }
    }
}

