/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.config;

import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.config.ConfigEnvironment;
import de.siphalor.tweed.config.ConfigFile;
import de.siphalor.tweed.config.ConfigOrigin;
import de.siphalor.tweed.config.ConfigScope;
import de.siphalor.tweed.config.TweedRegistry;
import de.siphalor.tweed.data.DataObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public final class ConfigLoader {
    public static void initialReload(ConfigEnvironment configEnvironment) {
        TweedRegistry.getConfigFiles().forEach(configFile -> {
            configFile.load(ConfigLoader.readMainConfigFile(configFile), configEnvironment, ConfigScope.HIGHEST, ConfigOrigin.MAIN);
            ConfigLoader.updateMainConfigFile(configFile, configEnvironment, ConfigScope.HIGHEST);
            configFile.finishReload(configEnvironment, ConfigScope.HIGHEST);
        });
    }

    public static void loadConfigs(class_3300 resourceManager, ConfigEnvironment environment, ConfigScope scope) {
        ArrayList<ConfigFile> configFiles = TweedRegistry.getConfigFiles();
        for (ConfigFile configFile : configFiles) {
            configFile.reset(environment, scope);
            configFile.load(ConfigLoader.readMainConfigFile(configFile), environment, scope, ConfigOrigin.MAIN);
            ConfigLoader.updateMainConfigFile(configFile, environment, scope);
            try {
                List resources = resourceManager.method_14489(configFile.getFileIdentifier());
                for (class_3298 resource : resources) {
                    configFile.load(resource, environment, scope, ConfigOrigin.DATAPACK);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            configFile.finishReload(environment, scope);
            if (!environment.triggers(ConfigEnvironment.SERVER)) continue;
            configFile.syncToClients(ConfigEnvironment.SYNCED, scope, ConfigOrigin.DATAPACK);
        }
    }

    public static void updateMainConfigFile(ConfigFile configFile, ConfigEnvironment environment, ConfigScope scope) {
        DataObject dataObject = ConfigLoader.readMainConfigFile(configFile);
        configFile.write(dataObject, environment, scope);
        File mainConfigFile = ConfigLoader.getMainConfigFile(configFile);
        mainConfigFile.toPath().getParent().toFile().mkdirs();
        try {
            FileOutputStream outputStream = new FileOutputStream(mainConfigFile);
            configFile.getDataSerializer().write(outputStream, dataObject);
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Tweed.LOGGER.error("Failed to update config file " + configFile.getFileName());
        }
    }

    public static DataObject readMainConfigFile(ConfigFile configFile) {
        File mainConfig = ConfigLoader.getMainConfigFile(configFile);
        if (mainConfig.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(mainConfig);
                DataObject<?> dataObject = configFile.getDataSerializer().read(inputStream);
                inputStream.close();
                if (dataObject == null) {
                    Tweed.LOGGER.error("Failed to read config file " + configFile.getFileName());
                    return configFile.getDataSerializer().newObject();
                }
                return dataObject;
            }
            catch (Exception ignored) {
                Tweed.LOGGER.error("Failed to read config file " + configFile.getFileName());
            }
        }
        return configFile.getDataSerializer().newObject();
    }

    public static void writeMainConfigFile(ConfigFile configFile, ConfigEnvironment environment, ConfigScope scope) {
        File mainConfigFile = ConfigLoader.getMainConfigFile(configFile);
        mainConfigFile.toPath().getParent().toFile().mkdirs();
        try {
            FileOutputStream outputStream = new FileOutputStream(mainConfigFile);
            configFile.getDataSerializer().write(outputStream, configFile.write(configFile.getDataSerializer().newObject(), environment, scope));
            outputStream.close();
        }
        catch (Exception e) {
            Tweed.LOGGER.error("Failed to load config file " + configFile.getFileName());
            e.printStackTrace();
        }
    }

    public static File getMainConfigFile(ConfigFile configFile) {
        return new File(Tweed.mainConfigDirectory, configFile.getFileName());
    }
}

