/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.config.entry;

import de.siphalor.tweed.config.ConfigEnvironment;
import de.siphalor.tweed.config.ConfigOrigin;
import de.siphalor.tweed.config.ConfigReadException;
import de.siphalor.tweed.config.ConfigScope;
import de.siphalor.tweed.config.constraints.Constraint;
import de.siphalor.tweed.config.constraints.ConstraintException;
import de.siphalor.tweed.config.entry.AbstractBasicEntry;
import de.siphalor.tweed.config.value.ConfigValue;
import de.siphalor.tweed.config.value.SimpleConfigValue;
import de.siphalor.tweed.config.value.serializer.ConfigValueSerializer;
import de.siphalor.tweed.data.DataContainer;
import de.siphalor.tweed.data.DataValue;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2540;

public class ValueConfigEntry<V>
extends AbstractBasicEntry<ValueConfigEntry<V>> {
    private ConfigValueSerializer<V> valueSerializer;
    ConfigValue<V> currentValue;
    protected V mainConfigValue;
    protected V defaultValue;
    protected Queue<Constraint<V>> constraints;
    protected Consumer<V> reloadListener;

    public ValueConfigEntry(V defaultValue) {
        this(new SimpleConfigValue<V>(defaultValue), (ConfigValueSerializer<V>)ConfigValue.serializer(defaultValue, defaultValue.getClass()));
    }

    public ValueConfigEntry(V defaultValue, ConfigValueSerializer<V> configValueSerializer) {
        this(new SimpleConfigValue<V>(defaultValue), configValueSerializer);
    }

    public ValueConfigEntry(ConfigValue<V> configValue, ConfigValueSerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
        this.currentValue = configValue;
        this.defaultValue = this.currentValue.get();
        this.mainConfigValue = this.defaultValue;
        this.comment = "";
        this.environment = ConfigEnvironment.UNIVERSAL;
        this.constraints = new ConcurrentLinkedQueue<Constraint<V>>();
    }

    public V getValue() {
        return this.currentValue.get();
    }

    public void setValue(V value) {
        this.currentValue.set(value);
    }

    public void setDefaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public void setMainConfigValue(V mainConfigValue) {
        this.mainConfigValue = mainConfigValue;
    }

    public final V getMainConfigValue() {
        return this.mainConfigValue;
    }

    @Deprecated
    public void setBothValues(V value) {
        this.currentValue.set(value);
        this.mainConfigValue = value;
    }

    public Class<V> getType() {
        return this.valueSerializer.getType();
    }

    @Override
    public void reset(ConfigEnvironment environment, ConfigScope scope) {
        this.currentValue.set(this.defaultValue);
        this.mainConfigValue = this.defaultValue;
    }

    public final ValueConfigEntry<V> addConstraint(Constraint<V> constraint) {
        this.constraints.add(constraint);
        return this;
    }

    public Queue<Constraint<V>> getConstraints() {
        return this.constraints;
    }

    @Override
    public final void applyConstraints() throws ConstraintException {
        this.applyConstraints(this.getValue());
    }

    public final void applyConstraints(V value) throws ConstraintException {
        for (Constraint constraint : this.constraints) {
            try {
                constraint.apply(value, this);
            }
            catch (ConstraintException e) {
                if (!e.fatal) continue;
                throw e;
            }
        }
    }

    @Override
    public String getDescription() {
        StringBuilder description = new StringBuilder();
        if (this.comment.length() > 0) {
            description.append(this.getComment()).append(System.lineSeparator());
        }
        description.append("default: ").append(this.valueSerializer != null ? this.valueSerializer.asString(this.defaultValue) : this.defaultValue.toString());
        String constraintDesc = this.constraints.stream().flatMap(constraint -> {
            String desc = constraint.getDescription();
            if (desc.isEmpty()) {
                return Stream.empty();
            }
            return Arrays.stream(desc.split("\n"));
        }).collect(Collectors.joining(System.lineSeparator() + "\t"));
        if (!constraintDesc.isEmpty()) {
            description.append('\n').append(constraintDesc);
        }
        return description.toString();
    }

    @Override
    public void read(DataValue<?> dataValue, ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) throws ConfigReadException {
        this.currentValue.set(this.valueSerializer.read(dataValue));
        if (origin == ConfigOrigin.MAIN) {
            this.mainConfigValue = this.currentValue.get();
        }
        this.onReload();
    }

    @Override
    public void read(class_2540 buf, ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) {
        if (environment.triggers(this.getEnvironment())) {
            if (scope.triggers(this.getScope())) {
                if (origin == ConfigOrigin.MAIN) {
                    this.mainConfigValue = this.valueSerializer.read(buf);
                } else {
                    this.currentValue.set(this.valueSerializer.read(buf));
                }
                this.onReload();
            } else if (origin == ConfigOrigin.MAIN) {
                this.mainConfigValue = this.valueSerializer.read(buf);
            }
        } else {
            this.valueSerializer.read(buf);
        }
    }

    @Override
    public <Key> void write(DataContainer<?, Key> dataContainer, Key key, ConfigEnvironment environment, ConfigScope scope) {
        this.valueSerializer.write(dataContainer, key, this.mainConfigValue);
        if (dataContainer.has(key)) {
            dataContainer.get(key).setComment(this.getDescription());
        }
    }

    @Override
    public void write(class_2540 buf, ConfigEnvironment environment, ConfigScope scope, ConfigOrigin origin) {
        if (origin == ConfigOrigin.MAIN) {
            this.valueSerializer.write(buf, this.mainConfigValue);
        } else {
            this.valueSerializer.write(buf, this.currentValue.get());
        }
    }

    public ValueConfigEntry<V> setReloadListener(Consumer<V> listener) {
        this.reloadListener = listener;
        return this;
    }

    public void onReload() {
        if (this.reloadListener != null) {
            this.reloadListener.accept(this.currentValue.get());
        }
    }
}

