/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.tailor;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.client.CustomNoticeScreen;
import de.siphalor.tweed.client.TweedClient;
import de.siphalor.tweed.client.cloth.ClothDropdownSelectEntry;
import de.siphalor.tweed.config.ConfigEnvironment;
import de.siphalor.tweed.config.ConfigFile;
import de.siphalor.tweed.config.ConfigLoader;
import de.siphalor.tweed.config.ConfigOrigin;
import de.siphalor.tweed.config.ConfigScope;
import de.siphalor.tweed.config.constraints.ConstraintException;
import de.siphalor.tweed.config.entry.ConfigEntry;
import de.siphalor.tweed.config.entry.ValueConfigEntry;
import de.siphalor.tweed.tailor.ClothData;
import de.siphalor.tweed.tailor.DropdownMaterial;
import de.siphalor.tweed.tailor.Tailor;
import io.netty.buffer.Unpooled;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.EnumSelectorBuilder;
import me.shedaniel.clothconfig2.impl.builders.FloatFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1074;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ClothTailor
extends Tailor {
    public static final ClothTailor INSTANCE = new ClothTailor();
    protected static final String SCREEN_NAME_PREFIX = "tweed.cloth.";
    protected boolean waitingForFile;
    private static final Map<Class<?>, EntryConverter<?>> ENTRY_CONVERTERS = new HashMap();
    private final Map<String, ConfigScreenFactory<?>> screenFactories = new HashMap();

    @Override
    public void process(ConfigFile configFile) {
        String modId = configFile.getName();
        ClothData clothData = configFile.getTailorAnnotation(ClothData.class);
        if (clothData != null && !clothData.modid().isEmpty()) {
            modId = clothData.modid();
        }
        this.screenFactories.put(modId, parent -> this.convert(configFile, parent));
    }

    public Map<String, ConfigScreenFactory<?>> getScreenFactories() {
        return this.screenFactories;
    }

    public class_437 convert(ConfigFile configFile, class_437 parentScreen) {
        boolean inGame;
        boolean bl = inGame = class_310.method_1551().field_1687 != null;
        if (inGame && configFile.getRootCategory().getEnvironment() != ConfigEnvironment.CLIENT) {
            return new CustomNoticeScreen(() -> {
                this.waitingForFile = true;
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.method_10814(configFile.getName());
                buf.method_10817((Enum)ConfigEnvironment.UNIVERSAL);
                buf.method_10817((Enum)ConfigScope.SMALLEST);
                buf.method_10817((Enum)ConfigOrigin.MAIN);
                ClientPlayNetworking.send((class_2960)Tweed.REQUEST_SYNC_C2S_PACKET, (class_2540)buf);
                TweedClient.setSyncRunnable(() -> {
                    if (this.waitingForFile) {
                        this.waitingForFile = false;
                        class_310.method_1551().method_1507(this.buildConfigScreen(configFile, parentScreen));
                    }
                });
            }, () -> {
                this.waitingForFile = false;
                class_310.method_1551().method_1507(parentScreen);
            }, (class_2561)new class_2588("tweed.gui.screen.syncFromServer", new Object[0]), (class_2561)new class_2588("tweed.gui.screen.syncFromServer.note", new Object[0]));
        }
        return this.buildConfigScreen(configFile, parentScreen);
    }

    public class_437 buildConfigScreen(ConfigFile configFile, class_437 parentScreen) {
        String path = SCREEN_NAME_PREFIX + configFile.getName();
        ConfigBuilder configBuilder = ConfigBuilder.create();
        configBuilder.setParentScreen(parentScreen);
        if (configFile.getRootCategory().getBackgroundTexture() != null) {
            configBuilder.setDefaultBackgroundTexture(configFile.getRootCategory().getBackgroundTexture());
        }
        configBuilder.setSavingRunnable(() -> this.save(configFile));
        configBuilder.setTitle(class_1074.method_4662((String)path, (Object[])new Object[0]));
        if (configFile.getRootCategory().entryStream().allMatch(entry -> entry.getValue() instanceof de.siphalor.tweed.config.ConfigCategory)) {
            configFile.getRootCategory().entryStream().forEach(entry -> this.createCategory(configBuilder, (de.siphalor.tweed.config.ConfigCategory)entry.getValue(), path + "." + (String)entry.getKey()));
        } else {
            this.createCategory(configBuilder, configFile.getRootCategory(), path + ".main");
        }
        return configBuilder.build();
    }

    private void convertCategory(ConfigEntryBuilder entryBuilder, Consumer<AbstractConfigListEntry<?>> registry, de.siphalor.tweed.config.ConfigCategory configCategory, String path) {
        configCategory.entryStream().forEachOrdered(entry -> {
            String subPath = path + "." + (String)entry.getKey();
            if (entry.getValue() instanceof de.siphalor.tweed.config.ConfigCategory) {
                SubCategoryBuilder categoryBuilder = entryBuilder.startSubCategory(class_1074.method_4662((String)subPath, (Object[])new Object[0]));
                categoryBuilder.add((AbstractConfigListEntry)entryBuilder.startTextDescription(ClothTailor.categoryDescription(subPath, (ConfigEntry)entry.getValue())).setColor(Color.GRAY.getRGB()).build());
                this.convertCategory(entryBuilder, arg_0 -> ((SubCategoryBuilder)categoryBuilder).add(arg_0), (de.siphalor.tweed.config.ConfigCategory)entry.getValue(), subPath);
                registry.accept((AbstractConfigListEntry<?>)categoryBuilder.build());
            } else if (entry.getValue() instanceof ValueConfigEntry) {
                Class clazz;
                EntryConverter<?> entryConverter = ENTRY_CONVERTERS.get(clazz);
                block0: for (clazz = ((ValueConfigEntry)entry.getValue()).getType(); clazz != Object.class && entryConverter == null; clazz = clazz.getSuperclass()) {
                    for (Class<?> anInterface : clazz.getInterfaces()) {
                        entryConverter = ENTRY_CONVERTERS.get(anInterface);
                        if (entryConverter != null) break block0;
                    }
                    entryConverter = ENTRY_CONVERTERS.get(clazz);
                }
                if (entryConverter != null) {
                    registry.accept(entryConverter.convert((ValueConfigEntry)entry.getValue(), entryBuilder, subPath));
                } else {
                    Tweed.LOGGER.warn("Couldn't convert config entry of type " + ((ValueConfigEntry)entry.getValue()).getType().getSimpleName() + " to cloth entry!");
                }
            }
        });
    }

    private void createCategory(ConfigBuilder configBuilder, de.siphalor.tweed.config.ConfigCategory configCategory, String name) {
        ConfigCategory clothCategory = configBuilder.getOrCreateCategory(class_1074.method_4662((String)name, (Object[])new Object[0]));
        if (configCategory.getBackgroundTexture() != null) {
            clothCategory.setCategoryBackground(configCategory.getBackgroundTexture());
        }
        clothCategory.addEntry((AbstractConfigListEntry)configBuilder.entryBuilder().startTextDescription(ClothTailor.categoryDescription(name, configCategory)).setColor(Color.GRAY.getRGB()).build());
        this.convertCategory(configBuilder.entryBuilder(), arg_0 -> ((ConfigCategory)clothCategory).addEntry(arg_0), configCategory, name);
    }

    private void save(ConfigFile configFile) {
        if (TweedClient.isOnRemoteServer()) {
            configFile.syncToServer(ConfigEnvironment.UNIVERSAL, ConfigScope.SMALLEST);
            ConfigLoader.updateMainConfigFile(configFile, ConfigEnvironment.UNIVERSAL, ConfigScope.HIGHEST);
            ConfigLoader.loadConfigs(class_310.method_1551().method_1478(), ConfigEnvironment.UNIVERSAL, ConfigScope.SMALLEST);
        } else {
            ConfigLoader.updateMainConfigFile(configFile, ConfigEnvironment.UNIVERSAL, ConfigScope.HIGHEST);
            ConfigLoader.loadConfigs(class_310.method_1551().method_1478(), ConfigEnvironment.UNIVERSAL, ConfigScope.WORLD);
        }
    }

    public static <V> void registerEntryConverter(Class<V> valueType, EntryConverter<V> converter) {
        ENTRY_CONVERTERS.put(valueType, converter);
    }

    public static <V> Optional<String> errorSupplier(V value, ValueConfigEntry<V> configEntry) {
        try {
            configEntry.applyConstraints(value);
        }
        catch (ConstraintException e) {
            return Optional.of(e.getMessage());
        }
        return Optional.empty();
    }

    public static boolean requiresRestart(ValueConfigEntry<?> configEntry) {
        if (class_310.method_1551().field_1687 == null) {
            return configEntry.getScope().triggers(ConfigScope.GAME);
        }
        return configEntry.getScope().triggers(ConfigScope.WORLD);
    }

    public static Optional<String[]> description(String langKey, ValueConfigEntry<?> configEntry) {
        if (class_1074.method_4663((String)(langKey + ".description"))) {
            return Optional.of(new String[]{class_1074.method_4662((String)(langKey + ".description"), (Object[])new Object[0])});
        }
        return configEntry.getClothyDescription();
    }

    public static String categoryDescription(String langKey, ConfigEntry<?> entry) {
        if (class_1074.method_4663((String)(langKey + ".description"))) {
            return class_1074.method_4662((String)(langKey + ".description"), (Object[])new Object[0]);
        }
        return entry.getDescription().replace("\t", "    ");
    }

    static {
        ClothTailor.registerEntryConverter(Boolean.class, (configEntry, entryBuilder, langKey) -> {
            BooleanToggleBuilder builder = entryBuilder.startBooleanToggle(class_1074.method_4662((String)langKey, (Object[])new Object[0]), ((Boolean)configEntry.getMainConfigValue()).booleanValue());
            builder.setDefaultValue(configEntry::getDefaultValue);
            builder.setSaveConsumer(configEntry::setMainConfigValue);
            builder.setTooltip(ClothTailor.description(langKey, configEntry));
            builder.setErrorSupplier(value -> ClothTailor.errorSupplier(value, configEntry));
            if (ClothTailor.requiresRestart(configEntry)) {
                builder.requireRestart(true);
            }
            return builder.build();
        });
        ClothTailor.registerEntryConverter(DropdownMaterial.class, (configEntry, entryBuilder, langKey) -> new ClothDropdownSelectEntry<DropdownMaterial>(class_1074.method_4662((String)langKey, (Object[])new Object[0]), (DropdownMaterial)configEntry.getMainConfigValue(), class_1074.method_4662((String)"text.cloth-config.reset_value", (Object[])new Object[0]), () -> ClothTailor.description(langKey, configEntry), ClothTailor.requiresRestart(configEntry), configEntry::getDefaultValue, configEntry::setMainConfigValue, new ArrayList(((DropdownMaterial)configEntry.getDefaultValue()).values()), dropdownMaterial -> new class_2588(dropdownMaterial.getTranslationKey(), new Object[0])));
        ClothTailor.registerEntryConverter(Enum.class, (configEntry, entryBuilder, langKey) -> {
            EnumSelectorBuilder builder = entryBuilder.startEnumSelector(class_1074.method_4662((String)langKey, (Object[])new Object[0]), configEntry.getType(), (Enum)configEntry.getMainConfigValue());
            builder.setDefaultValue(configEntry::getDefaultValue);
            builder.setSaveConsumer(configEntry::setMainConfigValue);
            builder.setTooltip(ClothTailor.description(langKey, configEntry));
            builder.setErrorSupplier(value -> ClothTailor.errorSupplier(value, configEntry));
            if (ClothTailor.requiresRestart(configEntry)) {
                builder.requireRestart(true);
            }
            return builder.build();
        });
        ClothTailor.registerEntryConverter(Float.class, (configEntry, entryBuilder, langKey) -> {
            FloatFieldBuilder builder = entryBuilder.startFloatField(class_1074.method_4662((String)langKey, (Object[])new Object[0]), ((Float)configEntry.getMainConfigValue()).floatValue());
            builder.setDefaultValue(configEntry::getDefaultValue);
            builder.setSaveConsumer(configEntry::setMainConfigValue);
            builder.setTooltip(ClothTailor.description(langKey, configEntry));
            builder.setErrorSupplier(value -> ClothTailor.errorSupplier(value, configEntry));
            if (ClothTailor.requiresRestart(configEntry)) {
                builder.requireRestart(true);
            }
            return builder.build();
        });
        ClothTailor.registerEntryConverter(Integer.class, (configEntry, entryBuilder, langKey) -> {
            IntFieldBuilder builder = entryBuilder.startIntField(class_1074.method_4662((String)langKey, (Object[])new Object[0]), ((Integer)configEntry.getMainConfigValue()).intValue());
            builder.setDefaultValue(configEntry::getDefaultValue);
            builder.setSaveConsumer(configEntry::setMainConfigValue);
            builder.setTooltip(ClothTailor.description(langKey, configEntry));
            builder.setErrorSupplier(value -> ClothTailor.errorSupplier(value, configEntry));
            if (ClothTailor.requiresRestart(configEntry)) {
                builder.requireRestart(true);
            }
            return builder.build();
        });
        ClothTailor.registerEntryConverter(String.class, (configEntry, entryBuilder, langKey) -> {
            StringFieldBuilder builder = entryBuilder.startStrField(class_1074.method_4662((String)langKey, (Object[])new Object[0]), (String)configEntry.getMainConfigValue());
            builder.setDefaultValue(configEntry::getDefaultValue);
            builder.setSaveConsumer(configEntry::setMainConfigValue);
            builder.setTooltip(ClothTailor.description(langKey, configEntry));
            builder.setErrorSupplier(value -> ClothTailor.errorSupplier(value, configEntry));
            if (ClothTailor.requiresRestart(configEntry)) {
                builder.requireRestart(true);
            }
            return builder.build();
        });
    }

    @FunctionalInterface
    public static interface EntryConverter<V> {
        public AbstractConfigListEntry<?> convert(ValueConfigEntry<V> var1, ConfigEntryBuilder var2, String var3);
    }
}

