package de.siphalor.tweed5.defaultextensions.pather.api;

import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntryVisitor;

public class PathTrackingConfigEntryVisitor implements ConfigEntryVisitor {
	private final ConfigEntryVisitor delegate;
	private final PathTracking pathTracking;

	@Override
	public void visitEntry(ConfigEntry<?> entry) {
		delegate.visitEntry(entry);
	}

	@Override
	public boolean enterStructuredEntry(ConfigEntry<?> entry) {
		return delegate.enterStructuredEntry(entry);
	}

	@Override
	public boolean enterStructuredSubEntry(String key) {
		boolean enter = delegate.enterStructuredSubEntry(key);
		if (enter) {
			pathTracking.pushPathPart(key);
		}
		return enter;
	}

	@Override
	public void leaveStructuredSubEntry(String key) {
		delegate.leaveStructuredSubEntry(key);
		pathTracking.popPathPart();
	}

	@Override
	public void leaveStructuredEntry(ConfigEntry<?> entry) {
		delegate.leaveStructuredEntry(entry);
	}

	public PathTrackingConfigEntryVisitor(final ConfigEntryVisitor delegate, final PathTracking pathTracking) {
		this.delegate = delegate;
		this.pathTracking = pathTracking;
	}
}
