package de.siphalor.tweed5.typeutils.api.annotations;

import de.siphalor.tweed5.typeutils.impl.annotations.AnnotationRepeatTypeResolver;
import lombok.*;
import org.jspecify.annotations.Nullable;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public abstract class AnnotationRepeatType {
	public static AnnotationRepeatType getType(Class<? extends Annotation> annotationClass) {
		return AnnotationRepeatTypeResolver.getType(annotationClass);
	}

	private final Class<? extends Annotation> annotationClass;

	@Nullable
	public abstract Class<? extends Annotation> alternativeAnnotationClass();


	public static class NonRepeatable extends AnnotationRepeatType {
		public NonRepeatable(Class<? extends Annotation> annotationClass) {
			super(annotationClass);
		}

		@Override
		@Nullable
		public Class<? extends Annotation> alternativeAnnotationClass() {
			return null;
		}
	}


	public static class Repeatable extends AnnotationRepeatType {
		private final Class<? extends Annotation> containerAnnotationClass;

		public Repeatable(Class<? extends Annotation> annotationClass, Class<? extends Annotation> containerAnnotationClass) {
			super(annotationClass);
			this.containerAnnotationClass = containerAnnotationClass;
		}

		public AnnotationRepeatType.RepeatableContainer containerRepeatType() {
			return new RepeatableContainer(containerAnnotationClass, annotationClass());
		}

		@Override
		@Nullable
		public Class<? extends Annotation> alternativeAnnotationClass() {
			return containerAnnotationClass;
		}

		public Class<? extends Annotation> containerAnnotationClass() {
			return this.containerAnnotationClass;
		}

		@Override
		public boolean equals(final Object o) {
			if (o == this) return true;
			if (!(o instanceof AnnotationRepeatType.Repeatable)) return false;
			final AnnotationRepeatType.Repeatable other = (AnnotationRepeatType.Repeatable) o;
			if (!other.canEqual((Object) this)) return false;
			if (!super.equals(o)) return false;
			final Object this$containerAnnotationClass = this.containerAnnotationClass();
			final Object other$containerAnnotationClass = other.containerAnnotationClass();
			if (this$containerAnnotationClass == null ? other$containerAnnotationClass != null : !this$containerAnnotationClass.equals(other$containerAnnotationClass)) return false;
			return true;
		}

		protected boolean canEqual(final Object other) {
			return other instanceof AnnotationRepeatType.Repeatable;
		}

		@Override
		public int hashCode() {
			final int PRIME = 59;
			int result = super.hashCode();
			final Object $containerAnnotationClass = this.containerAnnotationClass();
			result = result * PRIME + ($containerAnnotationClass == null ? 43 : $containerAnnotationClass.hashCode());
			return result;
		}

		@Override
		public String toString() {
			return "AnnotationRepeatType.Repeatable(super=" + super.toString() + ", containerAnnotationClass=" + this.containerAnnotationClass() + ")";
		}
	}


	public static class RepeatableContainer extends AnnotationRepeatType {
		private final Class<? extends Annotation> elementAnnotationClass;
		@Nullable
		private MethodHandle valueHandle;

		public RepeatableContainer(Class<? extends Annotation> annotationClass, Class<? extends Annotation> elementAnnotationClass) {
			super(annotationClass);
			this.elementAnnotationClass = elementAnnotationClass;
		}

		public AnnotationRepeatType.Repeatable elementRepeatType() {
			return new Repeatable(elementAnnotationClass, annotationClass());
		}

		@Override
		@Nullable
		public Class<? extends Annotation> alternativeAnnotationClass() {
			return elementAnnotationClass;
		}

		public <C extends Annotation, E extends Annotation> E[] elements(C containerAnnotation) {
			if (valueHandle == null) {
				try {
					valueHandle = MethodHandles.lookup().findVirtual(annotationClass(), "value", MethodType.methodType(Class.forName("[L" + elementAnnotationClass.getName() + ";")));
				} catch (Exception e) {
					throw new IllegalStateException("Failed to resolve value method of container annotation: " + containerAnnotation + " (" + containerAnnotation.getClass().getName() + ")", e);
				}
			}
			try {
				//noinspection unchecked
				return (E[]) valueHandle.invoke(containerAnnotation);
			} catch (Throwable e) {
				throw new RuntimeException("Unexpected exception when calling value method of container annotation: " + containerAnnotation + "( " + containerAnnotation.getClass().getName() + ")", e);
			}
		}

		@Override
		public boolean equals(final Object o) {
			if (o == this) return true;
			if (!(o instanceof AnnotationRepeatType.RepeatableContainer)) return false;
			final AnnotationRepeatType.RepeatableContainer other = (AnnotationRepeatType.RepeatableContainer) o;
			if (!other.canEqual((Object) this)) return false;
			if (!super.equals(o)) return false;
			final Object this$elementAnnotationClass = this.elementAnnotationClass();
			final Object other$elementAnnotationClass = other.elementAnnotationClass();
			if (this$elementAnnotationClass == null ? other$elementAnnotationClass != null : !this$elementAnnotationClass.equals(other$elementAnnotationClass)) return false;
			return true;
		}

		protected boolean canEqual(final Object other) {
			return other instanceof AnnotationRepeatType.RepeatableContainer;
		}

		@Override
		public int hashCode() {
			final int PRIME = 59;
			int result = super.hashCode();
			final Object $elementAnnotationClass = this.elementAnnotationClass();
			result = result * PRIME + ($elementAnnotationClass == null ? 43 : $elementAnnotationClass.hashCode());
			return result;
		}

		@Override
		public String toString() {
			return "AnnotationRepeatType.RepeatableContainer(super=" + super.toString() + ", elementAnnotationClass=" + this.elementAnnotationClass() + ")";
		}

		public Class<? extends Annotation> elementAnnotationClass() {
			return this.elementAnnotationClass;
		}
	}

	private AnnotationRepeatType(final Class<? extends Annotation> annotationClass) {
		this.annotationClass = annotationClass;
	}

	public Class<? extends Annotation> annotationClass() {
		return this.annotationClass;
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof AnnotationRepeatType)) return false;
		final AnnotationRepeatType other = (AnnotationRepeatType) o;
		if (!other.canEqual((Object) this)) return false;
		final Object this$annotationClass = this.annotationClass();
		final Object other$annotationClass = other.annotationClass();
		if (this$annotationClass == null ? other$annotationClass != null : !this$annotationClass.equals(other$annotationClass)) return false;
		return true;
	}

	protected boolean canEqual(final Object other) {
		return other instanceof AnnotationRepeatType;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final Object $annotationClass = this.annotationClass();
		result = result * PRIME + ($annotationClass == null ? 43 : $annotationClass.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "AnnotationRepeatType(annotationClass=" + this.annotationClass() + ")";
	}
}
