package de.siphalor.tweed5.weaver.pojo.api.weaving;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import org.jspecify.annotations.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;

public final class ProtoWeavingContext {
	@Nullable
	private final WeavingContext parent;
	private final ConfigContainer<?> configContainer;
	private final String[] path;
	private final AnnotatedElement annotations;

	public static ProtoWeavingContext subContextFor(WeavingContext weavingContext, String subPathName, AnnotatedElement annotations) {
		String[] path = Arrays.copyOf(weavingContext.path(), weavingContext.path().length + 1, String[].class);
		path[path.length - 1] = subPathName;
		return new ProtoWeavingContext(weavingContext, weavingContext.configContainer(), path, annotations);
	}

	public static ProtoWeavingContext create(ConfigContainer<?> configContainer, AnnotatedElement annotations) {
		return new ProtoWeavingContext(null, configContainer, new String[0], annotations);
	}

	@Nullable
	public WeavingContext parent() {
		return this.parent;
	}

	public ConfigContainer<?> configContainer() {
		return this.configContainer;
	}

	public String[] path() {
		return this.path;
	}

	public AnnotatedElement annotations() {
		return this.annotations;
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof ProtoWeavingContext)) return false;
		final ProtoWeavingContext other = (ProtoWeavingContext) o;
		final Object this$parent = this.parent();
		final Object other$parent = other.parent();
		if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) return false;
		final Object this$configContainer = this.configContainer();
		final Object other$configContainer = other.configContainer();
		if (this$configContainer == null ? other$configContainer != null : !this$configContainer.equals(other$configContainer)) return false;
		if (!java.util.Arrays.deepEquals(this.path(), other.path())) return false;
		final Object this$annotations = this.annotations();
		final Object other$annotations = other.annotations();
		if (this$annotations == null ? other$annotations != null : !this$annotations.equals(other$annotations)) return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final Object $parent = this.parent();
		result = result * PRIME + ($parent == null ? 43 : $parent.hashCode());
		final Object $configContainer = this.configContainer();
		result = result * PRIME + ($configContainer == null ? 43 : $configContainer.hashCode());
		result = result * PRIME + java.util.Arrays.deepHashCode(this.path());
		final Object $annotations = this.annotations();
		result = result * PRIME + ($annotations == null ? 43 : $annotations.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "ProtoWeavingContext(parent=" + this.parent() + ", configContainer=" + this.configContainer() + ", path=" + java.util.Arrays.deepToString(this.path()) + ", annotations=" + this.annotations() + ")";
	}

	private ProtoWeavingContext(@Nullable final WeavingContext parent, final ConfigContainer<?> configContainer, final String[] path, final AnnotatedElement annotations) {
		this.parent = parent;
		this.configContainer = configContainer;
		this.path = path;
		this.annotations = annotations;
	}
}
