/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.annotationinheritance.impl;

import de.siphalor.tweed5.annotationinheritance.impl.ByteArrayClassLoader;
import de.siphalor.tweed5.shadowed.org.objectweb.asm.ClassWriter;
import de.siphalor.tweed5.shadowed.org.objectweb.asm.Label;
import de.siphalor.tweed5.shadowed.org.objectweb.asm.MethodVisitor;
import de.siphalor.tweed5.shadowed.org.objectweb.asm.Type;
import de.siphalor.tweed5.typeutils.api.annotations.AnnotationRepeatType;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import lombok.Generated;

public class RepeatableAnnotationContainerHelper {
    private static final int CLASS_VERSION = 52;
    private static final String GENERATED_PACKAGE = RepeatableAnnotationContainerHelper.class.getPackage().getName() + ".generated";
    private static final Map<Class<? extends Annotation>, Function<Annotation[], Annotation>> CACHE = new HashMap<Class<? extends Annotation>, Function<Annotation[], Annotation>>();
    private static final ReadWriteLock CACHE_LOCK = new ReentrantReadWriteLock();

    private static String generateUniqueIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replace("-", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Annotation, C extends Annotation> C createContainer(R[] elements) {
        Function<Annotation[], Annotation> constructor;
        if (elements.length == 0) {
            throw new IllegalArgumentException("elements must not be empty");
        }
        Class<? extends Annotation> repeatableClass = elements[0].annotationType();
        AnnotationRepeatType repeatType = AnnotationRepeatType.getType(repeatableClass);
        if (!(repeatType instanceof AnnotationRepeatType.Repeatable)) {
            throw new IllegalArgumentException(repeatableClass.getName() + " is not a repeatable");
        }
        Class<? extends Annotation> containerClass = ((AnnotationRepeatType.Repeatable)repeatType).containerAnnotationClass();
        CACHE_LOCK.readLock().lock();
        try {
            constructor = CACHE.get(containerClass);
            if (constructor != null) {
                Annotation annotation = constructor.apply((Annotation[])elements);
                return (C)annotation;
            }
        }
        finally {
            CACHE_LOCK.readLock().unlock();
        }
        constructor = RepeatableAnnotationContainerHelper.createContainerClassConstructor(containerClass, repeatableClass);
        CACHE_LOCK.writeLock().lock();
        try {
            CACHE.put(containerClass, constructor);
        }
        finally {
            CACHE_LOCK.writeLock().unlock();
        }
        return (C)constructor.apply((Annotation[])elements);
    }

    private static <R extends Annotation, C extends Annotation> Function<R[], C> createContainerClassConstructor(Class<C> containerClass, Class<R> repeatableClass) {
        try {
            if (!containerClass.isAnnotation()) {
                throw new IllegalArgumentException(containerClass.getName() + " is not a container annotation");
            }
            String generatedClassName = GENERATED_PACKAGE + ".RepeatableContainer$" + RepeatableAnnotationContainerHelper.generateUniqueIdentifier();
            byte[] bytes = RepeatableAnnotationContainerHelper.createContainerClassBytes(generatedClassName, containerClass, repeatableClass);
            Class<?> generatedClass = new ByteArrayClassLoader(RepeatableAnnotationContainerHelper.class.getClassLoader()).createClass(generatedClassName, bytes);
            MethodHandle constructorHandle = MethodHandles.lookup().findConstructor(generatedClass, MethodType.methodType(Void.TYPE, RepeatableAnnotationContainerHelper.arrayType(repeatableClass)));
            return repeatedValues -> {
                try {
                    return constructorHandle.invoke(repeatedValues);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Failed to instantiate generated container annotation", e);
                }
            };
        }
        catch (Exception e) {
            throw new IllegalStateException("Class generation failed", e);
        }
    }

    static <R extends Annotation, C extends Annotation> byte[] createContainerClassBytes(String generatedClassName, Class<C> containerClass, Class<R> repeatableClass) {
        ClassWriter classWriter = new ClassWriter(2);
        String generatedClassNameInternal = generatedClassName.replace('.', '/');
        classWriter.visit(52, 4097, generatedClassNameInternal, null, "java/lang/Object", new String[]{containerClass.getName().replace('.', '/')});
        Class<R[]> repeatableArrayClass = RepeatableAnnotationContainerHelper.arrayType(repeatableClass);
        classWriter.visitField(2, "values", RepeatableAnnotationContainerHelper.descriptor(repeatableArrayClass), null, null);
        RepeatableAnnotationContainerHelper.appendConstructor(classWriter, repeatableArrayClass, generatedClassNameInternal);
        RepeatableAnnotationContainerHelper.appendValueMethod(classWriter, repeatableArrayClass, generatedClassNameInternal);
        RepeatableAnnotationContainerHelper.appendEqualsMethod(classWriter, repeatableArrayClass, containerClass, generatedClassNameInternal);
        RepeatableAnnotationContainerHelper.appendHashCodeMethod(classWriter, repeatableArrayClass, generatedClassNameInternal);
        RepeatableAnnotationContainerHelper.appendToStringMethod(classWriter, repeatableArrayClass, containerClass, generatedClassNameInternal);
        RepeatableAnnotationContainerHelper.appendAnnotationTypeMethod(classWriter, containerClass);
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static void appendConstructor(ClassWriter classWriter, Class<?> repeatableArrayClass, String generatedClassNameInternal) {
        MethodVisitor methodWriter = classWriter.visitMethod(1, "<init>", "(" + RepeatableAnnotationContainerHelper.descriptor(repeatableArrayClass) + ")V", null, null);
        methodWriter.visitParameter("values", 0);
        methodWriter.visitCode();
        methodWriter.visitVarInsn(25, 0);
        methodWriter.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        methodWriter.visitVarInsn(25, 0);
        methodWriter.visitVarInsn(25, 1);
        methodWriter.visitFieldInsn(181, generatedClassNameInternal, "values", RepeatableAnnotationContainerHelper.descriptor(repeatableArrayClass));
        methodWriter.visitInsn(177);
        methodWriter.visitMaxs(2, 2);
        methodWriter.visitEnd();
    }

    private static void appendValueMethod(ClassWriter classWriter, Class<?> repeatableArrayClass, String generatedClassNameInternal) {
        MethodVisitor methodWriter = classWriter.visitMethod(1, "value", "()" + RepeatableAnnotationContainerHelper.descriptor(repeatableArrayClass), null, null);
        methodWriter.visitCode();
        methodWriter.visitVarInsn(25, 0);
        methodWriter.visitFieldInsn(180, generatedClassNameInternal, "values", RepeatableAnnotationContainerHelper.descriptor(repeatableArrayClass));
        methodWriter.visitInsn(176);
        methodWriter.visitMaxs(1, 1);
        methodWriter.visitEnd();
    }

    private static void appendEqualsMethod(ClassWriter classWriter, Class<?> repeatableArrayClass, Class<?> containerAnnotationClass, String generatedClassNameInternal) {
        MethodVisitor methodWriter = classWriter.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        methodWriter.visitParameter("other", 0);
        Label falseLabel = new Label();
        methodWriter.visitCode();
        methodWriter.visitVarInsn(25, 1);
        String containerAnnotationClassBinaryName = Type.getInternalName(containerAnnotationClass);
        methodWriter.visitTypeInsn(193, containerAnnotationClassBinaryName);
        methodWriter.visitJumpInsn(153, falseLabel);
        methodWriter.visitVarInsn(25, 0);
        methodWriter.visitFieldInsn(180, generatedClassNameInternal, "values", RepeatableAnnotationContainerHelper.descriptor(repeatableArrayClass));
        methodWriter.visitVarInsn(25, 1);
        methodWriter.visitMethodInsn(185, containerAnnotationClassBinaryName, "value", "()" + RepeatableAnnotationContainerHelper.descriptor(repeatableArrayClass), true);
        methodWriter.visitMethodInsn(184, "java/util/Arrays", "equals", "([Ljava/lang/Object;[Ljava/lang/Object;)Z", false);
        methodWriter.visitInsn(172);
        methodWriter.visitLabel(falseLabel);
        methodWriter.visitLdcInsn(false);
        methodWriter.visitInsn(172);
        methodWriter.visitMaxs(0, 0);
        methodWriter.visitEnd();
    }

    private static void appendHashCodeMethod(ClassWriter classWriter, Class<?> repeatableArrayClass, String generatedClassNameInternal) {
        MethodVisitor methodWriter = classWriter.visitMethod(1, "hashCode", "()I", null, null);
        int keyHashCode = "value".hashCode() * 127;
        methodWriter.visitCode();
        methodWriter.visitVarInsn(25, 0);
        methodWriter.visitFieldInsn(180, generatedClassNameInternal, "values", RepeatableAnnotationContainerHelper.descriptor(repeatableArrayClass));
        methodWriter.visitMethodInsn(184, "java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I", false);
        methodWriter.visitLdcInsn(keyHashCode);
        methodWriter.visitInsn(130);
        methodWriter.visitInsn(172);
        methodWriter.visitMaxs(2, 2);
        methodWriter.visitEnd();
    }

    private static void appendToStringMethod(ClassWriter classWriter, Class<?> repeatableArrayClass, Class<?> containerAnnotationClass, String generatedClassNameInternal) {
        MethodVisitor methodWriter = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        String prefix = "@" + containerAnnotationClass.getName() + "(value=";
        String suffix = ")";
        String stringBuilderBinaryName = StringBuilder.class.getName().replace('.', '/');
        methodWriter.visitCode();
        methodWriter.visitVarInsn(25, 0);
        methodWriter.visitFieldInsn(180, generatedClassNameInternal, "values", RepeatableAnnotationContainerHelper.descriptor(repeatableArrayClass));
        methodWriter.visitMethodInsn(184, "java/util/Arrays", "toString", "([Ljava/lang/Object;)Ljava/lang/String;", false);
        methodWriter.visitInsn(89);
        methodWriter.visitMethodInsn(182, "java/lang/String", "length", "()I", false);
        methodWriter.visitLdcInsn(prefix.length() + suffix.length());
        methodWriter.visitInsn(96);
        methodWriter.visitTypeInsn(187, stringBuilderBinaryName);
        methodWriter.visitInsn(90);
        methodWriter.visitInsn(95);
        methodWriter.visitMethodInsn(183, stringBuilderBinaryName, "<init>", "(I)V", false);
        methodWriter.visitLdcInsn(prefix);
        methodWriter.visitMethodInsn(182, stringBuilderBinaryName, "append", "(Ljava/lang/CharSequence;)L" + stringBuilderBinaryName + ";", false);
        methodWriter.visitInsn(95);
        methodWriter.visitMethodInsn(182, stringBuilderBinaryName, "append", "(Ljava/lang/String;)L" + stringBuilderBinaryName + ";", false);
        methodWriter.visitLdcInsn(suffix);
        methodWriter.visitMethodInsn(182, stringBuilderBinaryName, "append", "(Ljava/lang/CharSequence;)L" + stringBuilderBinaryName + ";", false);
        methodWriter.visitMethodInsn(182, stringBuilderBinaryName, "toString", "()Ljava/lang/String;", false);
        methodWriter.visitInsn(176);
        methodWriter.visitMaxs(0, 0);
        methodWriter.visitEnd();
    }

    private static void appendAnnotationTypeMethod(ClassWriter classWriter, Class<?> containerAnnotationClass) {
        MethodVisitor methodWriter = classWriter.visitMethod(1, "annotationType", "()Ljava/lang/Class;", null, null);
        methodWriter.visitCode();
        methodWriter.visitLdcInsn(Type.getType(containerAnnotationClass));
        methodWriter.visitInsn(176);
        methodWriter.visitMaxs(1, 1);
        methodWriter.visitEnd();
    }

    private static String descriptor(Class<?> clazz) {
        return Type.getType(clazz).getDescriptor();
    }

    private static <T> Class<T[]> arrayType(Class<T> clazz) {
        try {
            return Class.forName("[L" + clazz.getName() + ";");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to get array class for " + clazz.getName(), e);
        }
    }

    @Generated
    private RepeatableAnnotationContainerHelper() {
    }
}

