/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.data.extension.impl;

import de.siphalor.tweed5.core.api.entry.CollectionConfigEntry;
import de.siphalor.tweed5.core.api.entry.CompoundConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.data.extension.api.TweedEntryReadException;
import de.siphalor.tweed5.data.extension.api.TweedEntryReader;
import de.siphalor.tweed5.data.extension.api.TweedEntryWriteException;
import de.siphalor.tweed5.data.extension.api.TweedEntryWriter;
import de.siphalor.tweed5.data.extension.api.TweedReadContext;
import de.siphalor.tweed5.data.extension.api.TweedWriteContext;
import de.siphalor.tweed5.data.extension.api.readwrite.TweedEntryReaderWriter;
import de.siphalor.tweed5.dataapi.api.TweedDataReadException;
import de.siphalor.tweed5.dataapi.api.TweedDataReader;
import de.siphalor.tweed5.dataapi.api.TweedDataToken;
import de.siphalor.tweed5.dataapi.api.TweedDataVisitor;
import de.siphalor.tweed5.dataapi.api.TweedDataWriteException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class TweedEntryReaderWriterImpls {
    public static final TweedEntryReaderWriter<Boolean, ConfigEntry<Boolean>> BOOLEAN_READER_WRITER = new PrimitiveReaderWriter<Boolean>(TweedDataToken::readAsBoolean, TweedDataVisitor::visitBoolean);
    public static final TweedEntryReaderWriter<Byte, ConfigEntry<Byte>> BYTE_READER_WRITER = new PrimitiveReaderWriter<Byte>(TweedDataToken::readAsByte, TweedDataVisitor::visitByte);
    public static final TweedEntryReaderWriter<Short, ConfigEntry<Short>> SHORT_READER_WRITER = new PrimitiveReaderWriter<Short>(TweedDataToken::readAsShort, TweedDataVisitor::visitShort);
    public static final TweedEntryReaderWriter<Integer, ConfigEntry<Integer>> INT_READER_WRITER = new PrimitiveReaderWriter<Integer>(TweedDataToken::readAsInt, TweedDataVisitor::visitInt);
    public static final TweedEntryReaderWriter<Long, ConfigEntry<Long>> LONG_READER_WRITER = new PrimitiveReaderWriter<Long>(TweedDataToken::readAsLong, TweedDataVisitor::visitLong);
    public static final TweedEntryReaderWriter<Float, ConfigEntry<Float>> FLOAT_READER_WRITER = new PrimitiveReaderWriter<Float>(TweedDataToken::readAsFloat, TweedDataVisitor::visitFloat);
    public static final TweedEntryReaderWriter<Double, ConfigEntry<Double>> DOUBLE_READER_WRITER = new PrimitiveReaderWriter<Double>(TweedDataToken::readAsDouble, TweedDataVisitor::visitDouble);
    public static final TweedEntryReaderWriter<String, ConfigEntry<String>> STRING_READER_WRITER = new PrimitiveReaderWriter<String>(TweedDataToken::readAsString, TweedDataVisitor::visitString);
    public static final TweedEntryReaderWriter<Enum<?>, ConfigEntry<Enum<?>>> ENUM_READER_WRITER = new EnumReaderWriter();
    public static final TweedEntryReaderWriter<Collection<Object>, CollectionConfigEntry<Object, Collection<Object>>> COLLECTION_READER_WRITER = new CollectionReaderWriter<Object, Collection<Object>>();
    public static final TweedEntryReaderWriter<Object, CompoundConfigEntry<Object>> COMPOUND_READER_WRITER = new CompoundReaderWriter<Object>();
    public static final TweedEntryReaderWriter<Object, ConfigEntry<Object>> NOOP_READER_WRITER = new NoopReaderWriter();

    @Contract(value="null, _ -> fail")
    private static <T> void requireNonNullWriteValue(@Nullable T value, TweedWriteContext context) throws TweedEntryWriteException {
        if (value == null) {
            throw new TweedEntryWriteException("Unable to write null value", context);
        }
    }

    private static void assertIsToken(TweedDataToken token, Predicate<TweedDataToken> isToken, String description, TweedReadContext context) throws TweedEntryReadException {
        if (!isToken.test(token)) {
            throw new TweedEntryReadException("Unexpected token " + token + ": " + description, context);
        }
    }

    @Generated
    private TweedEntryReaderWriterImpls() {
    }

    private static class PrimitiveReaderWriter<T>
    implements TweedEntryReaderWriter<T, ConfigEntry<T>> {
        private final PrimitiveReadFunction<T> readerFunction;
        private final PrimitiveWriteFunction<T> writerFunction;

        @Override
        public T read(TweedDataReader reader, ConfigEntry<T> entry, TweedReadContext context) throws TweedEntryReadException {
            try {
                return this.readerFunction.read(reader.readToken());
            }
            catch (TweedDataReadException e) {
                throw new TweedEntryReadException(e, context);
            }
        }

        @Override
        public void write(TweedDataVisitor writer, @Nullable T value, ConfigEntry<T> entry, TweedWriteContext context) throws TweedEntryWriteException, TweedDataWriteException {
            TweedEntryReaderWriterImpls.requireNonNullWriteValue(value, context);
            this.writerFunction.write(writer, value);
        }

        @Generated
        public PrimitiveReaderWriter(PrimitiveReadFunction<T> readerFunction, PrimitiveWriteFunction<T> writerFunction) {
            this.readerFunction = readerFunction;
            this.writerFunction = writerFunction;
        }
    }

    private static interface PrimitiveReadFunction<T> {
        public T read(TweedDataToken var1) throws TweedDataReadException;
    }

    private static interface PrimitiveWriteFunction<T> {
        public void write(TweedDataVisitor var1, T var2) throws TweedDataWriteException;
    }

    public static class EnumReaderWriter<T extends Enum<?>>
    implements TweedEntryReaderWriter<T, ConfigEntry<T>> {
        @Override
        public T read(TweedDataReader reader, ConfigEntry<T> entry, TweedReadContext context) throws TweedEntryReadException {
            try {
                TweedDataToken token = reader.readToken();
                TweedEntryReaderWriterImpls.assertIsToken(token, TweedDataToken::canReadAsString, "Expected string", context);
                return Enum.valueOf(entry.valueClass(), token.readAsString());
            }
            catch (TweedDataReadException | IllegalArgumentException e) {
                throw new TweedEntryReadException("Failed reading enum value for " + entry.valueClass().getName(), e, context);
            }
        }

        @Override
        public void write(TweedDataVisitor writer, @Nullable T value, ConfigEntry<T> entry, TweedWriteContext context) throws TweedEntryWriteException, TweedDataWriteException {
            TweedEntryReaderWriterImpls.requireNonNullWriteValue(value, context);
            writer.visitString(((Enum)value).name());
        }

        @Generated
        public EnumReaderWriter() {
        }
    }

    public static class CollectionReaderWriter<T, C extends Collection<T>>
    implements TweedEntryReaderWriter<C, CollectionConfigEntry<T, C>> {
        @Override
        public C read(TweedDataReader reader, CollectionConfigEntry<T, C> entry, TweedReadContext context) throws TweedEntryReadException {
            TweedDataToken token;
            try {
                TweedEntryReaderWriterImpls.assertIsToken(reader.readToken(), TweedDataToken::isListStart, "Expected list start", context);
                token = reader.peekToken();
            }
            catch (TweedDataReadException e) {
                throw new TweedEntryReadException("Failed reading collection start", e, context);
            }
            if (token.isListEnd()) {
                return entry.instantiateCollection(0);
            }
            ConfigEntry<T> elementEntry = entry.elementEntry();
            TweedEntryReader elementReader = context.readWriteExtension().getReaderChain(elementEntry);
            ArrayList<@Nullable T> list = new ArrayList(20);
            try {
                block6: {
                    while (true) {
                        if ((token = reader.peekToken()).isListEnd()) break block6;
                        if (!token.isListValue()) break;
                        list.add(elementReader.read(reader, elementEntry, context));
                    }
                    throw new TweedEntryReadException("Unexpected token " + token + ": expected next list value or list end", context);
                }
                reader.readToken();
            }
            catch (TweedDataReadException e) {
                throw new TweedEntryReadException("Failed reading element " + list.size() + " of collection", e, context);
            }
            C result = entry.instantiateCollection(list.size());
            result.addAll(list);
            return result;
        }

        @Override
        public void write(TweedDataVisitor writer, C value, CollectionConfigEntry<T, C> entry, TweedWriteContext context) throws TweedEntryWriteException, TweedDataWriteException {
            TweedEntryReaderWriterImpls.requireNonNullWriteValue(value, context);
            if (value.isEmpty()) {
                writer.visitEmptyList();
                return;
            }
            ConfigEntry<T> elementEntry = entry.elementEntry();
            TweedEntryWriter elementWriter = context.readWriteExtension().getWriterChain(elementEntry);
            writer.visitListStart();
            for (Object element : value) {
                elementWriter.write(writer, element, elementEntry, context);
            }
            writer.visitListEnd();
        }
    }

    public static class CompoundReaderWriter<T>
    implements TweedEntryReaderWriter<T, CompoundConfigEntry<T>> {
        @Override
        public T read(TweedDataReader reader, CompoundConfigEntry<T> entry, TweedReadContext context) throws TweedEntryReadException {
            try {
                TweedEntryReaderWriterImpls.assertIsToken(reader.readToken(), TweedDataToken::isMapStart, "Expected map start", context);
            }
            catch (TweedDataReadException e) {
                throw new TweedEntryReadException("Failed reading compound start", e, context);
            }
            Map<String, ConfigEntry<?>> compoundEntries = entry.subEntries();
            T compoundValue = entry.instantiateCompoundValue();
            try {
                TweedDataToken token;
                while (!(token = reader.readToken()).isMapEnd()) {
                    if (token.isMapEntryKey()) {
                        String key = token.readAsString();
                        ConfigEntry<?> subEntry = compoundEntries.get(key);
                        if (subEntry == null) {
                            NOOP_READER_WRITER.read(reader, null, context);
                            continue;
                        }
                        TweedEntryReader subEntryReaderChain = context.readWriteExtension().getReaderChain(subEntry);
                        Object subEntryValue = subEntryReaderChain.read(reader, subEntry, context);
                        entry.set(compoundValue, key, subEntryValue);
                        continue;
                    }
                    throw new TweedEntryReadException("Unexpected token " + token + ": Expected map key or map end", context);
                }
            }
            catch (TweedDataReadException e) {
                throw new TweedEntryReadException("Failed reading compound entry", e, context);
            }
            return compoundValue;
        }

        @Override
        public void write(TweedDataVisitor writer, @Nullable T value, CompoundConfigEntry<T> entry, TweedWriteContext context) throws TweedEntryWriteException, TweedDataWriteException {
            TweedEntryReaderWriterImpls.requireNonNullWriteValue(value, context);
            writer.visitMapStart();
            Map<String, ConfigEntry<?>> compoundEntries = entry.subEntries();
            for (Map.Entry<String, ConfigEntry<?>> e : compoundEntries.entrySet()) {
                String key = e.getKey();
                ConfigEntry<?> subEntry = e.getValue();
                TweedEntryWriter subEntryWriterChain = context.readWriteExtension().getWriterChain(subEntry);
                writer.visitMapEntryKey(key);
                subEntryWriterChain.write(writer, entry.get(value, key), subEntry, context);
            }
            writer.visitMapEnd();
        }
    }

    public static class NoopReaderWriter
    implements TweedEntryReaderWriter<Object, ConfigEntry<Object>> {
        @Override
        public @Nullable Object read(TweedDataReader reader, ConfigEntry<Object> entry, TweedReadContext context) throws TweedEntryReadException {
            try {
                TweedDataToken token = reader.readToken();
                if (!token.isListStart() && !token.isMapStart()) {
                    return null;
                }
                ArrayDeque<Context> stack = new ArrayDeque<Context>(20);
                if (token.isListStart()) {
                    stack.push(Context.LIST);
                } else if (token.isMapStart()) {
                    stack.push(Context.MAP);
                }
                do {
                    if ((token = reader.readToken()).isListStart()) {
                        stack.push(Context.LIST);
                        continue;
                    }
                    if (token.isMapStart()) {
                        stack.push(Context.MAP);
                        continue;
                    }
                    if (!token.isListEnd() && !token.isMapEnd()) continue;
                    stack.pop();
                } while (!stack.isEmpty());
                return null;
            }
            catch (TweedDataReadException e) {
                throw new TweedEntryReadException("Failed skipping through value", e, context);
            }
        }

        @Override
        public void write(TweedDataVisitor writer, @Nullable Object value, ConfigEntry<Object> entry, TweedWriteContext context) throws TweedDataWriteException {
            writer.visitNull();
        }

        private static enum Context {
            LIST,
            MAP;

        }
    }

    public static class NullableWriter<T, C extends ConfigEntry<T>>
    implements TweedEntryWriter<T, C> {
        private final TweedEntryWriter<T, C> delegate;

        @Override
        public void write(TweedDataVisitor writer, T value, C entry, TweedWriteContext context) throws TweedEntryWriteException, TweedDataWriteException {
            if (value == null) {
                writer.visitNull();
            } else {
                this.delegate.write(writer, value, entry, context);
            }
        }

        @Generated
        public NullableWriter(TweedEntryWriter<T, C> delegate) {
            this.delegate = delegate;
        }
    }

    public static class NullableReader<T, C extends ConfigEntry<T>>
    implements TweedEntryReader<T, C> {
        private final TweedEntryReader<T, C> delegate;

        @Override
        public T read(TweedDataReader reader, C entry, TweedReadContext context) throws TweedEntryReadException {
            try {
                if (reader.peekToken().isNull()) {
                    reader.readToken();
                    return null;
                }
            }
            catch (TweedDataReadException e) {
                throw new TweedEntryReadException(e, context);
            }
            return this.delegate.read(reader, entry, context);
        }

        @Generated
        public NullableReader(TweedEntryReader<T, C> delegate) {
            this.delegate = delegate;
        }
    }
}

