/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.comment.impl;

import com.google.auto.service.AutoService;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.container.ConfigContainerSetupPhase;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.extension.TweedExtension;
import de.siphalor.tweed5.core.api.extension.TweedExtensionSetupContext;
import de.siphalor.tweed5.core.api.middleware.DefaultMiddlewareContainer;
import de.siphalor.tweed5.data.extension.api.extension.ReadWriteExtensionSetupContext;
import de.siphalor.tweed5.data.extension.api.extension.ReadWriteRelatedExtension;
import de.siphalor.tweed5.defaultextensions.comment.api.CommentExtension;
import de.siphalor.tweed5.defaultextensions.comment.api.CommentModifyingExtension;
import de.siphalor.tweed5.defaultextensions.comment.api.CommentProducer;
import de.siphalor.tweed5.defaultextensions.comment.impl.TweedEntryWriterCommentMiddleware;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

@AutoService(value={CommentExtension.class})
public class CommentExtensionImpl
implements ReadWriteRelatedExtension,
CommentExtension {
    private final ConfigContainer<?> configContainer;
    private final PatchworkPartAccess<CustomEntryData> customEntryDataAccess;
    private final DefaultMiddlewareContainer<CommentProducer> middlewareContainer;
    private @Nullable PatchworkPartAccess<Boolean> writerInstalledReadWriteContextAccess;

    public CommentExtensionImpl(ConfigContainer<?> configContainer, TweedExtensionSetupContext context) {
        this.configContainer = configContainer;
        this.customEntryDataAccess = context.registerEntryExtensionData(CustomEntryData.class);
        this.middlewareContainer = new DefaultMiddlewareContainer();
    }

    @Override
    public String getId() {
        return "comment";
    }

    @Override
    public void extensionsFinalized() {
        for (TweedExtension extension : this.configContainer.extensions()) {
            if (!(extension instanceof CommentModifyingExtension)) continue;
            this.middlewareContainer.register(((CommentModifyingExtension)((Object)extension)).commentMiddleware());
        }
        this.middlewareContainer.seal();
    }

    @Override
    public void setupReadWriteExtension(ReadWriteExtensionSetupContext context) {
        this.writerInstalledReadWriteContextAccess = context.registerReadWriteContextExtensionData(Boolean.class);
        context.registerWriterMiddleware(new TweedEntryWriterCommentMiddleware(this));
    }

    @Override
    public void setBaseComment(ConfigEntry<?> configEntry, String baseComment) {
        if (configEntry.container() != this.configContainer) {
            throw new IllegalArgumentException("config entry doesn't belong to config container of this extension");
        }
        if (this.configContainer.setupPhase().compareTo(ConfigContainerSetupPhase.INITIALIZED) >= 0) {
            throw new IllegalStateException("config container must not be initialized");
        }
        this.getOrCreateCustomEntryData(configEntry).baseComment(baseComment);
    }

    @Override
    public void initialize() {
        this.recomputeFullComments();
    }

    @Override
    public void recomputeFullComments() {
        this.configContainer.rootEntry().visitInOrder(entry -> {
            CustomEntryData entryData = this.getOrCreateCustomEntryData(entry);
            entryData.commentProducer(this.middlewareContainer.process(_entry -> entryData.baseComment()));
        });
    }

    private CustomEntryData getOrCreateCustomEntryData(ConfigEntry<?> entry) {
        CustomEntryData customEntryData = entry.extensionsData().get(this.customEntryDataAccess);
        if (customEntryData == null) {
            customEntryData = new CustomEntryData();
            entry.extensionsData().set(this.customEntryDataAccess, customEntryData);
        }
        return customEntryData;
    }

    @Override
    public @Nullable String getFullComment(ConfigEntry<?> configEntry) {
        CustomEntryData customEntryData = configEntry.extensionsData().get(this.customEntryDataAccess);
        if (customEntryData == null) {
            return null;
        }
        String comment = customEntryData.commentProducer().createComment(configEntry);
        return comment.isEmpty() ? null : comment;
    }

    @Generated
    public PatchworkPartAccess<CustomEntryData> customEntryDataAccess() {
        return this.customEntryDataAccess;
    }

    @Generated
    public @Nullable PatchworkPartAccess<Boolean> writerInstalledReadWriteContextAccess() {
        return this.writerInstalledReadWriteContextAccess;
    }

    private static class CustomEntryData {
        private String baseComment = "";
        private CommentProducer commentProducer;

        @Generated
        public CustomEntryData() {
        }

        @Generated
        public String baseComment() {
            return this.baseComment;
        }

        @Generated
        public CommentProducer commentProducer() {
            return this.commentProducer;
        }

        @Generated
        public CustomEntryData baseComment(String baseComment) {
            this.baseComment = baseComment;
            return this;
        }

        @Generated
        public CustomEntryData commentProducer(CommentProducer commentProducer) {
            this.commentProducer = commentProducer;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomEntryData)) {
                return false;
            }
            CustomEntryData other = (CustomEntryData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$baseComment = this.baseComment();
            String other$baseComment = other.baseComment();
            if (this$baseComment == null ? other$baseComment != null : !this$baseComment.equals(other$baseComment)) {
                return false;
            }
            CommentProducer this$commentProducer = this.commentProducer();
            CommentProducer other$commentProducer = other.commentProducer();
            return !(this$commentProducer == null ? other$commentProducer != null : !this$commentProducer.equals(other$commentProducer));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomEntryData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $baseComment = this.baseComment();
            result = result * 59 + ($baseComment == null ? 43 : $baseComment.hashCode());
            CommentProducer $commentProducer = this.commentProducer();
            result = result * 59 + ($commentProducer == null ? 43 : $commentProducer.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CommentExtensionImpl.CustomEntryData(baseComment=" + this.baseComment() + ", commentProducer=" + this.commentProducer() + ")";
        }
    }
}

