/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.comment.impl;

import de.siphalor.tweed5.core.api.middleware.Middleware;
import de.siphalor.tweed5.data.extension.api.TweedEntryWriter;
import de.siphalor.tweed5.dataapi.api.DelegatingTweedDataWriter;
import de.siphalor.tweed5.dataapi.api.TweedDataVisitor;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataCommentDecoration;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataDecoration;
import de.siphalor.tweed5.defaultextensions.comment.impl.CommentExtensionImpl;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import java.util.ArrayDeque;
import java.util.Deque;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

class TweedEntryWriterCommentMiddleware
implements Middleware<TweedEntryWriter<?, ?>> {
    private final CommentExtensionImpl commentExtension;

    @Override
    public String id() {
        return "comment-writer";
    }

    @Override
    public TweedEntryWriter<?, ?> process(TweedEntryWriter<?, ?> inner) {
        PatchworkPartAccess<Boolean> writerInstalledAccess = this.commentExtension.writerInstalledReadWriteContextAccess();
        assert (writerInstalledAccess != null);
        TweedEntryWriter<?, ?> innerCasted = inner;
        return (writer, value, entry, context) -> {
            String comment;
            if (!Boolean.TRUE.equals(context.extensionsData().get(writerInstalledAccess))) {
                context.extensionsData().set(writerInstalledAccess, Boolean.TRUE);
                writer = new MapEntryKeyDeferringWriter(writer);
            }
            if ((comment = this.commentExtension.getFullComment(entry)) != null) {
                writer.visitDecoration(new PiercingCommentDecoration(() -> comment));
            }
            innerCasted.write(writer, value, entry, context);
        };
    }

    @Generated
    public TweedEntryWriterCommentMiddleware(CommentExtensionImpl commentExtension) {
        this.commentExtension = commentExtension;
    }

    private static class MapEntryKeyDeferringWriter
    extends DelegatingTweedDataWriter {
        private final Deque<TweedDataDecoration> decorationQueue = new ArrayDeque<TweedDataDecoration>();
        private @Nullable String mapEntryKey;

        protected MapEntryKeyDeferringWriter(TweedDataVisitor delegate) {
            super(delegate);
        }

        @Override
        public void visitMapEntryKey(String key) {
            if (this.mapEntryKey != null) {
                throw new IllegalStateException("Map entry key already visited");
            }
            this.mapEntryKey = key;
        }

        @Override
        public void visitDecoration(TweedDataDecoration decoration) {
            if (decoration instanceof PiercingCommentDecoration) {
                super.visitDecoration(((PiercingCommentDecoration)decoration).commentDecoration());
                return;
            }
            if (this.mapEntryKey != null) {
                this.decorationQueue.addLast(decoration);
            } else {
                super.visitDecoration(decoration);
            }
        }

        @Override
        protected void beforeValueWrite() {
            if (this.mapEntryKey != null) {
                TweedDataDecoration decoration;
                super.visitMapEntryKey(this.mapEntryKey);
                this.mapEntryKey = null;
                while ((decoration = this.decorationQueue.pollFirst()) != null) {
                    super.visitDecoration(decoration);
                }
            }
            super.beforeValueWrite();
        }
    }

    private static final class PiercingCommentDecoration
    implements TweedDataDecoration {
        private final TweedDataCommentDecoration commentDecoration;

        @Generated
        public PiercingCommentDecoration(TweedDataCommentDecoration commentDecoration) {
            this.commentDecoration = commentDecoration;
        }

        @Generated
        public TweedDataCommentDecoration commentDecoration() {
            return this.commentDecoration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PiercingCommentDecoration)) {
                return false;
            }
            PiercingCommentDecoration other = (PiercingCommentDecoration)o;
            TweedDataCommentDecoration this$commentDecoration = this.commentDecoration();
            TweedDataCommentDecoration other$commentDecoration = other.commentDecoration();
            return !(this$commentDecoration == null ? other$commentDecoration != null : !this$commentDecoration.equals(other$commentDecoration));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TweedDataCommentDecoration $commentDecoration = this.commentDecoration();
            result = result * 59 + ($commentDecoration == null ? 43 : $commentDecoration.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TweedEntryWriterCommentMiddleware.PiercingCommentDecoration(commentDecoration=" + this.commentDecoration() + ")";
        }
    }
}

