/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.pather.api;

import de.siphalor.tweed5.dataapi.api.TweedDataUnsupportedValueException;
import de.siphalor.tweed5.dataapi.api.TweedDataVisitor;
import de.siphalor.tweed5.dataapi.api.decoration.TweedDataDecoration;
import de.siphalor.tweed5.defaultextensions.pather.api.PathTracking;
import java.util.ArrayDeque;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class PathTrackingDataVisitor
implements TweedDataVisitor {
    private final TweedDataVisitor delegate;
    private final PathTracking pathTracking;
    private final ArrayDeque<Context> contextStack = new ArrayDeque(50);
    private final ArrayDeque<Integer> listIndexStack = new ArrayDeque(50);

    @Override
    public void visitNull() {
        this.delegate.visitNull();
        this.valueVisited();
    }

    @Override
    public void visitBoolean(boolean value) {
        this.delegate.visitBoolean(value);
        this.valueVisited();
    }

    @Override
    public void visitByte(byte value) {
        this.delegate.visitByte(value);
        this.valueVisited();
    }

    @Override
    public void visitShort(short value) {
        this.delegate.visitShort(value);
        this.valueVisited();
    }

    @Override
    public void visitInt(int value) {
        this.delegate.visitInt(value);
        this.valueVisited();
    }

    @Override
    public void visitLong(long value) {
        this.delegate.visitLong(value);
        this.valueVisited();
    }

    @Override
    public void visitFloat(float value) {
        this.delegate.visitFloat(value);
        this.valueVisited();
    }

    @Override
    public void visitDouble(double value) {
        this.delegate.visitDouble(value);
        this.valueVisited();
    }

    @Override
    public void visitString(String value) {
        this.delegate.visitString(value);
        this.valueVisited();
    }

    @Override
    public void visitValue(@Nullable Object value) throws TweedDataUnsupportedValueException {
        TweedDataVisitor.super.visitValue(value);
        this.valueVisited();
    }

    private void valueVisited() {
        Context context = this.contextStack.peek();
        if (context == Context.MAP_ENTRY) {
            this.contextStack.pop();
            this.pathTracking.popPathPart();
        } else if (context == Context.LIST) {
            this.pathTracking.popPathPart();
            int index = this.listIndexStack.pop();
            this.listIndexStack.push(index + 1);
            this.pathTracking.pushPathPart(Integer.toString(index));
        }
    }

    @Override
    public void visitListStart() {
        this.delegate.visitListStart();
        this.contextStack.push(Context.LIST);
        this.listIndexStack.push(0);
        this.pathTracking.pushPathPart("0");
    }

    @Override
    public void visitListEnd() {
        this.delegate.visitListEnd();
        this.contextStack.pop();
        this.listIndexStack.pop();
        this.pathTracking.popPathPart();
        this.valueVisited();
    }

    @Override
    public void visitMapStart() {
        this.delegate.visitMapStart();
    }

    @Override
    public void visitMapEntryKey(String key) {
        this.delegate.visitMapEntryKey(key);
        this.pathTracking.pushPathPart(key);
        this.contextStack.push(Context.MAP_ENTRY);
    }

    @Override
    public void visitMapEnd() {
        this.delegate.visitMapEnd();
        this.valueVisited();
    }

    @Override
    public void visitDecoration(TweedDataDecoration decoration) {
        this.delegate.visitDecoration(decoration);
    }

    @Generated
    public PathTrackingDataVisitor(TweedDataVisitor delegate, PathTracking pathTracking) {
        this.delegate = delegate;
        this.pathTracking = pathTracking;
    }

    private static enum Context {
        LIST,
        MAP_ENTRY;

    }
}

