/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.validation.impl;

import com.google.auto.service.AutoService;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntryValueVisitor;
import de.siphalor.tweed5.core.api.extension.TweedExtension;
import de.siphalor.tweed5.core.api.extension.TweedExtensionSetupContext;
import de.siphalor.tweed5.core.api.middleware.DefaultMiddlewareContainer;
import de.siphalor.tweed5.core.api.middleware.Middleware;
import de.siphalor.tweed5.core.api.middleware.MiddlewareContainer;
import de.siphalor.tweed5.data.extension.api.TweedEntryReadException;
import de.siphalor.tweed5.data.extension.api.TweedEntryReader;
import de.siphalor.tweed5.data.extension.api.extension.ReadWriteExtensionSetupContext;
import de.siphalor.tweed5.data.extension.api.extension.ReadWriteRelatedExtension;
import de.siphalor.tweed5.defaultextensions.comment.api.CommentModifyingExtension;
import de.siphalor.tweed5.defaultextensions.comment.api.CommentProducer;
import de.siphalor.tweed5.defaultextensions.pather.api.PathTracking;
import de.siphalor.tweed5.defaultextensions.pather.api.PathTrackingConfigEntryValueVisitor;
import de.siphalor.tweed5.defaultextensions.pather.api.PatherExtension;
import de.siphalor.tweed5.defaultextensions.pather.api.ValuePathTracking;
import de.siphalor.tweed5.defaultextensions.validation.api.ConfigEntryValidator;
import de.siphalor.tweed5.defaultextensions.validation.api.ValidationExtension;
import de.siphalor.tweed5.defaultextensions.validation.api.ValidationProvidingExtension;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssue;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssueLevel;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssues;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationResult;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

@AutoService(value={ValidationExtension.class})
public class ValidationExtensionImpl
implements ReadWriteRelatedExtension,
ValidationExtension,
CommentModifyingExtension {
    private static final ValidationResult<?> PRIMITIVE_IS_NULL_RESULT = ValidationResult.withIssues(null, Collections.singletonList(new ValidationIssue("Primitive value must not be null", ValidationIssueLevel.ERROR)));
    private static final ConfigEntryValidator PRIMITIVE_VALIDATOR = new ConfigEntryValidator(){

        @Override
        public <T> ValidationResult<T> validate(ConfigEntry<T> configEntry, @Nullable T value) {
            if (value == null) {
                return PRIMITIVE_IS_NULL_RESULT;
            }
            return ValidationResult.ok(value);
        }

        @Override
        public <T> String description(ConfigEntry<T> configEntry) {
            return "Value must not be null.";
        }
    };
    private static final ConfigEntryValidator NOOP_VALIDATOR = new ConfigEntryValidator(){

        @Override
        public <T> ValidationResult<@Nullable T> validate(ConfigEntry<T> configEntry, @Nullable T value) {
            return ValidationResult.ok(value);
        }

        @Override
        public <T> String description(ConfigEntry<T> configEntry) {
            return "";
        }
    };
    private final ConfigContainer<?> configContainer;
    private final PatchworkPartAccess<CustomEntryData> customEntryDataAccess;
    private final MiddlewareContainer<ConfigEntryValidator> entryValidatorMiddlewareContainer = new DefaultMiddlewareContainer<ConfigEntryValidator>();
    private @Nullable PatchworkPartAccess<ValidationIssues> readContextValidationIssuesAccess;
    private @Nullable PatherExtension patherExtension;

    public ValidationExtensionImpl(ConfigContainer<?> configContainer, TweedExtensionSetupContext context) {
        this.configContainer = configContainer;
        this.customEntryDataAccess = context.registerEntryExtensionData(CustomEntryData.class);
        context.registerExtension(PatherExtension.class);
    }

    @Override
    public void extensionsFinalized() {
        for (TweedExtension extension : this.configContainer.extensions()) {
            if (!(extension instanceof ValidationProvidingExtension)) continue;
            this.entryValidatorMiddlewareContainer.register(((ValidationProvidingExtension)((Object)extension)).validationMiddleware());
        }
        this.entryValidatorMiddlewareContainer.seal();
        this.patherExtension = this.configContainer.extension(PatherExtension.class).orElseThrow(() -> new IllegalStateException("Missing requested PatherExtension"));
    }

    @Override
    public Middleware<CommentProducer> commentMiddleware() {
        return new Middleware<CommentProducer>(){

            @Override
            public String id() {
                return "validation";
            }

            @Override
            public CommentProducer process(CommentProducer inner) {
                return entry -> {
                    String baseComment = inner.createComment(entry);
                    CustomEntryData entryData = (CustomEntryData)entry.extensionsData().get(ValidationExtensionImpl.this.customEntryDataAccess);
                    if (entryData == null || entryData.completeValidator() == null) {
                        return baseComment;
                    }
                    String validationDescription = entryData.completeValidator().description(entry).trim();
                    if (validationDescription.isEmpty()) {
                        return baseComment;
                    }
                    if (baseComment.isEmpty()) {
                        return validationDescription;
                    }
                    return baseComment + "\n\n" + validationDescription;
                };
            }
        };
    }

    @Override
    public void setupReadWriteExtension(ReadWriteExtensionSetupContext context) {
        this.readContextValidationIssuesAccess = context.registerReadWriteContextExtensionData(ValidationIssues.class);
        context.registerReaderMiddleware(new EntryValidationReaderMiddleware());
    }

    @Override
    public <T> void addValidatorMiddleware(ConfigEntry<T> entry, Middleware<ConfigEntryValidator> validator) {
        CustomEntryData entryData = this.getOrCreateCustomEntryData(entry);
        entryData.addValidator(validator);
    }

    @Override
    public void initEntry(ConfigEntry<?> configEntry) {
        ConfigEntryValidator baseValidator = configEntry.valueClass().isPrimitive() ? PRIMITIVE_VALIDATOR : NOOP_VALIDATOR;
        CustomEntryData entryData = this.getOrCreateCustomEntryData(configEntry);
        if (entryData.validators().isEmpty()) {
            entryData.completeValidator(this.entryValidatorMiddlewareContainer.process(baseValidator));
        } else {
            DefaultMiddlewareContainer entrySpecificValidatorContainer = new DefaultMiddlewareContainer();
            entrySpecificValidatorContainer.registerAll(this.entryValidatorMiddlewareContainer.middlewares());
            entrySpecificValidatorContainer.registerAll(entryData.validators());
            entrySpecificValidatorContainer.seal();
            entryData.completeValidator(entrySpecificValidatorContainer.process(baseValidator));
        }
    }

    private CustomEntryData getOrCreateCustomEntryData(ConfigEntry<?> entry) {
        CustomEntryData entryData = entry.extensionsData().get(this.customEntryDataAccess);
        if (entryData == null) {
            entryData = new CustomEntryData();
            entry.extensionsData().set(this.customEntryDataAccess, entryData);
        }
        return entryData;
    }

    @Override
    public ValidationIssues captureValidationIssues(Patchwork readContextExtensionsData) {
        return this.getOrCreateValidationIssues(readContextExtensionsData);
    }

    @Override
    public <T> ValidationIssues validate(ConfigEntry<T> entry, @Nullable T value) {
        ValuePathTracking pathTracking = ValuePathTracking.create();
        ValidatingConfigEntryVisitor validatingVisitor = new ValidatingConfigEntryVisitor(pathTracking);
        entry.visitInOrder(new PathTrackingConfigEntryValueVisitor(validatingVisitor, pathTracking), value);
        return validatingVisitor.validationIssues();
    }

    private ValidationIssues getOrCreateValidationIssues(Patchwork readContextExtensionsData) {
        assert (this.readContextValidationIssuesAccess != null);
        ValidationIssues validationIssues = readContextExtensionsData.get(this.readContextValidationIssuesAccess);
        if (validationIssues == null) {
            validationIssues = new ValidationIssuesImpl();
            readContextExtensionsData.set(this.readContextValidationIssuesAccess, validationIssues);
        }
        return validationIssues;
    }

    private static class CustomEntryData {
        private @Nullable List<Middleware<ConfigEntryValidator>> validators;
        private @Nullable ConfigEntryValidator completeValidator;

        public List<Middleware<ConfigEntryValidator>> validators() {
            return this.validators == null ? Collections.emptyList() : this.validators;
        }

        public void addValidator(Middleware<ConfigEntryValidator> validator) {
            if (this.validators == null) {
                this.validators = new ArrayList<Middleware<ConfigEntryValidator>>();
            }
            this.validators.add(validator);
        }

        @Generated
        public CustomEntryData() {
        }

        @Generated
        public @Nullable ConfigEntryValidator completeValidator() {
            return this.completeValidator;
        }

        @Generated
        public CustomEntryData completeValidator(@Nullable ConfigEntryValidator completeValidator) {
            this.completeValidator = completeValidator;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomEntryData)) {
                return false;
            }
            CustomEntryData other = (CustomEntryData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Middleware<ConfigEntryValidator>> this$validators = this.validators();
            List<Middleware<ConfigEntryValidator>> other$validators = other.validators();
            if (this$validators == null ? other$validators != null : !((Object)this$validators).equals(other$validators)) {
                return false;
            }
            ConfigEntryValidator this$completeValidator = this.completeValidator();
            ConfigEntryValidator other$completeValidator = other.completeValidator();
            return !(this$completeValidator == null ? other$completeValidator != null : !this$completeValidator.equals(other$completeValidator));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomEntryData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Middleware<ConfigEntryValidator>> $validators = this.validators();
            result = result * 59 + ($validators == null ? 43 : ((Object)$validators).hashCode());
            ConfigEntryValidator $completeValidator = this.completeValidator();
            result = result * 59 + ($completeValidator == null ? 43 : $completeValidator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ValidationExtensionImpl.CustomEntryData(validators=" + this.validators() + ", completeValidator=" + this.completeValidator() + ")";
        }
    }

    private class EntryValidationReaderMiddleware
    implements Middleware<TweedEntryReader<?, ?>> {
        private EntryValidationReaderMiddleware() {
        }

        @Override
        public String id() {
            return "validation";
        }

        @Override
        public Set<String> mustComeAfter() {
            return Collections.singleton("pather");
        }

        @Override
        public TweedEntryReader<?, ?> process(TweedEntryReader<?, ?> inner) {
            assert (ValidationExtensionImpl.this.readContextValidationIssuesAccess != null && ValidationExtensionImpl.this.patherExtension != null);
            TweedEntryReader<?, ?> castedInner = inner;
            return (reader, entry, context) -> {
                ValidationIssues validationIssues = ValidationExtensionImpl.this.getOrCreateValidationIssues(context.extensionsData());
                Object value = castedInner.read(reader, entry, context);
                ConfigEntryValidator entryValidator = ((CustomEntryData)entry.extensionsData().get(ValidationExtensionImpl.this.customEntryDataAccess)).completeValidator();
                assert (entryValidator != null);
                ValidationResult validationResult = entryValidator.validate(entry, value);
                if (!validationResult.issues().isEmpty()) {
                    String path = ValidationExtensionImpl.this.patherExtension.getPath(context);
                    validationIssues.issuesByPath().put(path, new ValidationIssues.EntryIssues(entry, validationResult.issues()));
                }
                if (validationResult.hasError()) {
                    throw new TweedEntryReadException("Failed to validate entry: " + validationResult.issues(), context);
                }
                return validationResult.value();
            };
        }
    }

    private class ValidatingConfigEntryVisitor
    implements ConfigEntryValueVisitor {
        private final PathTracking pathTracking;
        private final ValidationIssues validationIssues = new ValidationIssuesImpl();

        @Override
        public <T> void visitEntry(ConfigEntry<T> entry, T value) {
            CustomEntryData entryData = (CustomEntryData)entry.extensionsData().get(ValidationExtensionImpl.this.customEntryDataAccess);
            assert (entryData != null);
            ConfigEntryValidator entryValidator = entryData.completeValidator();
            assert (entryValidator != null);
            ValidationResult<T> result = entryValidator.validate(entry, value);
            if (!result.issues().isEmpty()) {
                this.validationIssues.issuesByPath().put(this.pathTracking.currentPath(), new ValidationIssues.EntryIssues(entry, result.issues()));
            }
        }

        @Override
        public <T> boolean enterStructuredEntry(ConfigEntry<T> entry, T value) {
            return true;
        }

        @Override
        public <T> void leaveStructuredEntry(ConfigEntry<T> entry, T value) {
            this.visitEntry(entry, value);
        }

        @Generated
        public PathTracking pathTracking() {
            return this.pathTracking;
        }

        @Generated
        public ValidationIssues validationIssues() {
            return this.validationIssues;
        }

        @Generated
        public ValidatingConfigEntryVisitor(PathTracking pathTracking) {
            this.pathTracking = pathTracking;
        }
    }

    private static final class ValidationIssuesImpl
    implements ValidationIssues {
        private final Map<String, ValidationIssues.EntryIssues> issuesByPath = new HashMap<String, ValidationIssues.EntryIssues>();

        @Generated
        public ValidationIssuesImpl() {
        }

        @Override
        @Generated
        public Map<String, ValidationIssues.EntryIssues> issuesByPath() {
            return this.issuesByPath;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValidationIssuesImpl)) {
                return false;
            }
            ValidationIssuesImpl other = (ValidationIssuesImpl)o;
            Map<String, ValidationIssues.EntryIssues> this$issuesByPath = this.issuesByPath();
            Map<String, ValidationIssues.EntryIssues> other$issuesByPath = other.issuesByPath();
            return !(this$issuesByPath == null ? other$issuesByPath != null : !((Object)this$issuesByPath).equals(other$issuesByPath));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, ValidationIssues.EntryIssues> $issuesByPath = this.issuesByPath();
            result = result * 59 + ($issuesByPath == null ? 43 : ((Object)$issuesByPath).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ValidationExtensionImpl.ValidationIssuesImpl(issuesByPath=" + this.issuesByPath() + ")";
        }
    }
}

