/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.namingformat.api;

import de.siphalor.tweed5.namingformat.api.NamingFormat;
import de.siphalor.tweed5.namingformat.api.NamingFormatProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class NamingFormatCollector {
    private final Map<String, NamingFormat> namingFormats = new HashMap<String, NamingFormat>();

    public void setupFormats() {
        ServiceLoader<NamingFormatProvider> serviceLoader = ServiceLoader.load(NamingFormatProvider.class);
        Context context = new Context();
        for (NamingFormatProvider provider : serviceLoader) {
            provider.provideNamingFormats(context);
        }
    }

    public Map<String, NamingFormat> namingFormats() {
        return Collections.unmodifiableMap(this.namingFormats);
    }

    private class Context
    implements NamingFormatProvider.ProvidingContext {
        private Context() {
        }

        @Override
        public void registerNamingFormat(String id, NamingFormat namingFormat) {
            NamingFormatCollector.this.namingFormats.put(id, namingFormat);
        }
    }
}

