/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojo.impl.weaving;

import de.siphalor.tweed5.annotationinheritance.api.AnnotationInheritanceAwareAnnotatedElement;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import de.siphalor.tweed5.patchwork.api.PatchworkFactory;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.Log;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.LogFactory;
import de.siphalor.tweed5.typeutils.api.type.ActualType;
import de.siphalor.tweed5.weaver.pojo.api.annotation.PojoWeaving;
import de.siphalor.tweed5.weaver.pojo.api.annotation.PojoWeavingExtension;
import de.siphalor.tweed5.weaver.pojo.api.weaving.ProtoWeavingContext;
import de.siphalor.tweed5.weaver.pojo.api.weaving.TweedPojoWeavingExtension;
import de.siphalor.tweed5.weaver.pojo.api.weaving.WeavingContext;
import de.siphalor.tweed5.weaver.pojo.impl.weaving.PojoWeavingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class TweedPojoWeaverBootstrapper<T> {
    @Generated
    private static final Log log = LogFactory.getLog(TweedPojoWeaverBootstrapper.class);
    private final Class<T> pojoClass;
    private final AnnotatedElement pojoAnnotations;
    private final ConfigContainer<T> configContainer;
    private final Collection<TweedPojoWeavingExtension> weavingExtensions;
    private @Nullable PatchworkFactory weavingExtensionsPatchworkFactory;

    public static <T> TweedPojoWeaverBootstrapper<T> create(Class<T> pojoClass) {
        AnnotationInheritanceAwareAnnotatedElement pojoAnnotations = new AnnotationInheritanceAwareAnnotatedElement(pojoClass);
        PojoWeaving rootWeavingConfig = TweedPojoWeaverBootstrapper.expectAnnotation(pojoAnnotations, PojoWeaving.class);
        PojoWeavingExtension[] extensionAnnotations = (PojoWeavingExtension[])pojoAnnotations.getAnnotationsByType(PojoWeavingExtension.class);
        ConfigContainer<?> configContainer = TweedPojoWeaverBootstrapper.createConfigContainer(rootWeavingConfig.container());
        configContainer.registerExtensions(rootWeavingConfig.extensions());
        configContainer.finishExtensionSetup();
        Collection<TweedPojoWeavingExtension> extensions = TweedPojoWeaverBootstrapper.loadWeavingExtensions(Arrays.stream(extensionAnnotations).map(PojoWeavingExtension::value).collect(Collectors.toList()), configContainer);
        return new TweedPojoWeaverBootstrapper<T>(pojoClass, pojoAnnotations, configContainer, extensions);
    }

    private static Collection<TweedPojoWeavingExtension> loadWeavingExtensions(Collection<Class<? extends TweedPojoWeavingExtension>> weaverClasses, ConfigContainer<?> configContainer) {
        return weaverClasses.stream().map(weaverClass -> (TweedPojoWeavingExtension)TweedPojoWeavingExtension.FACTORY.construct(weaverClass).typedArg(ConfigContainer.class, configContainer).finish()).collect(Collectors.toList());
    }

    private static ConfigContainer<?> createConfigContainer(Class<? extends ConfigContainer<?>> containerClass) {
        try {
            return ConfigContainer.FACTORY.construct(containerClass).finish();
        }
        catch (Exception e) {
            throw new PojoWeavingException("Failed to instantiate config container");
        }
    }

    private static <A extends Annotation> A expectAnnotation(AnnotatedElement element, Class<A> annotationClass) {
        A annotation = element.getAnnotation(annotationClass);
        if (annotation == null) {
            throw new PojoWeavingException("Annotation " + annotationClass.getName() + " must be defined on class " + element);
        }
        return annotation;
    }

    public ConfigContainer<T> weave() {
        this.setupWeavingExtensions();
        assert (this.weavingExtensionsPatchworkFactory != null);
        ConfigEntry<T> rootEntry = this.weaveEntry(ActualType.ofClass(this.pojoClass), this.weavingExtensionsPatchworkFactory.create(), ProtoWeavingContext.create(this.configContainer, this.pojoAnnotations));
        this.configContainer.attachTree(rootEntry);
        return this.configContainer;
    }

    private void setupWeavingExtensions() {
        PatchworkFactory.Builder weavingExtensionsPatchworkFactoryBuilder = PatchworkFactory.builder();
        TweedPojoWeavingExtension.SetupContext setupContext = weavingExtensionsPatchworkFactoryBuilder::registerPart;
        for (TweedPojoWeavingExtension weaver : this.weavingExtensions) {
            weaver.setup(setupContext);
        }
        this.weavingExtensionsPatchworkFactory = weavingExtensionsPatchworkFactoryBuilder.build();
    }

    private <U> ConfigEntry<U> weaveEntry(ActualType<U> dataClass, Patchwork extensionsData, ProtoWeavingContext protoContext) {
        extensionsData = extensionsData.copy();
        this.runBeforeWeaveHooks(dataClass, extensionsData, protoContext);
        WeavingContext context = WeavingContext.builder().parent(protoContext.parent()).weavingFunction(this::weaveEntry).configContainer(this.configContainer).path(protoContext.path()).extensionsData(extensionsData).annotations(new AnnotationInheritanceAwareAnnotatedElement(protoContext.annotations())).build();
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            try {
                ConfigEntry<U> configEntry = weavingExtension.weaveEntry(dataClass, context);
                if (configEntry == null) continue;
                this.runAfterWeaveHooks(dataClass, configEntry, context);
                return configEntry;
            }
            catch (Exception e) {
                log.error("Failed to run Tweed POJO weaver (" + weavingExtension.getClass().getName() + ")", e);
            }
        }
        throw new PojoWeavingException("Failed to weave " + dataClass + ": No matching weavers found");
    }

    private <U> void runBeforeWeaveHooks(ActualType<U> dataClass, Patchwork extensionsData, ProtoWeavingContext protoContext) {
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            try {
                weavingExtension.beforeWeaveEntry(dataClass, extensionsData, protoContext);
            }
            catch (Exception e) {
                log.error("Failed to apply Tweed POJO weaver before weave hook (" + weavingExtension.getClass().getName() + ")", e);
            }
        }
    }

    private <U> void runAfterWeaveHooks(ActualType<U> dataClass, ConfigEntry<U> configEntry, WeavingContext context) {
        for (TweedPojoWeavingExtension weavingExtension : this.weavingExtensions) {
            try {
                weavingExtension.afterWeaveEntry(dataClass, configEntry, context);
            }
            catch (Exception e) {
                log.error("Failed to apply Tweed POJO weaver after weave hook (" + weavingExtension.getClass().getName() + ")", e);
            }
        }
    }

    @Generated
    private TweedPojoWeaverBootstrapper(Class<T> pojoClass, AnnotatedElement pojoAnnotations, ConfigContainer<T> configContainer, Collection<TweedPojoWeavingExtension> weavingExtensions) {
        this.pojoClass = pojoClass;
        this.pojoAnnotations = pojoAnnotations;
        this.configContainer = configContainer;
        this.weavingExtensions = weavingExtensions;
    }
}

