/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojoext.serde.api.nullable;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.data.extension.api.ReadWriteExtension;
import de.siphalor.tweed5.data.extension.api.TweedEntryReader;
import de.siphalor.tweed5.data.extension.api.TweedEntryWriter;
import de.siphalor.tweed5.data.extension.impl.TweedEntryReaderWriterImpls;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import de.siphalor.tweed5.typeutils.api.type.ActualType;
import de.siphalor.tweed5.weaver.pojo.api.weaving.ProtoWeavingContext;
import de.siphalor.tweed5.weaver.pojo.api.weaving.TweedPojoWeavingExtension;
import de.siphalor.tweed5.weaver.pojo.api.weaving.WeavingContext;
import de.siphalor.tweed5.weaver.pojoext.serde.api.nullable.AutoNullableReadWriteBehavior;
import de.siphalor.tweed5.weaver.pojoext.serde.api.nullable.AutoReadWriteNullability;
import java.lang.annotation.Annotation;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public class AutoNullableReadWritePojoWeavingProcessor
implements TweedPojoWeavingExtension {
    private final ReadWriteExtension readWriteExtension;
    private @Nullable PatchworkPartAccess<CustomData> customDataAccess;

    @ApiStatus.Internal
    public AutoNullableReadWritePojoWeavingProcessor(ConfigContainer<?> configContainer) {
        this.readWriteExtension = configContainer.extension(ReadWriteExtension.class).orElseThrow(() -> new IllegalStateException("You must register a " + ReadWriteExtension.class.getSimpleName() + " to use the " + this.getClass().getSimpleName()));
    }

    @Override
    public void setup(TweedPojoWeavingExtension.SetupContext context) {
        this.customDataAccess = context.registerWeavingContextExtensionData(CustomData.class);
    }

    @Override
    public <T> void beforeWeaveEntry(ActualType<T> valueType, Patchwork extensionsData, ProtoWeavingContext context) {
        assert (this.customDataAccess != null);
        AutoReadWriteNullability innerNullability = null;
        AutoNullableReadWriteBehavior behavior = context.annotations().getAnnotation(AutoNullableReadWriteBehavior.class);
        if (behavior != null) {
            innerNullability = behavior.defaultNullability();
        }
        AutoReadWriteNullability currentNullability = null;
        CustomData customData = extensionsData.get(this.customDataAccess);
        if (customData != null) {
            if (customData.innerDefaultNullability() != null) {
                extensionsData.set(this.customDataAccess, new CustomData(customData.innerDefaultNullability(), innerNullability));
                return;
            }
            currentNullability = customData.defaultNullability();
        }
        if (innerNullability != null) {
            extensionsData.set(this.customDataAccess, new CustomData(currentNullability, innerNullability));
        }
    }

    @Override
    public <T> void afterWeaveEntry(ActualType<T> valueType, ConfigEntry<T> configEntry, WeavingContext context) {
        if (this.getNullability(valueType, context) == AutoReadWriteNullability.NULLABLE) {
            TweedEntryWriter definedEntryWriter;
            TweedEntryReader definedEntryReader = this.readWriteExtension.getDefinedEntryReader(configEntry);
            if (definedEntryReader != null) {
                this.readWriteExtension.setEntryReader(configEntry, new TweedEntryReaderWriterImpls.NullableReader(definedEntryReader));
            }
            if ((definedEntryWriter = this.readWriteExtension.getDefinedEntryWriter(configEntry)) != null) {
                this.readWriteExtension.setEntryWriter(configEntry, new TweedEntryReaderWriterImpls.NullableWriter(definedEntryWriter));
            }
        }
    }

    private <T> AutoReadWriteNullability getNullability(ActualType<T> valueType, WeavingContext context) {
        if (valueType.declaredType().isPrimitive()) {
            return AutoReadWriteNullability.NON_NULL;
        }
        Annotation[] annotations = context.annotations().getAnnotations();
        for (int i = annotations.length - 1; i >= 0; --i) {
            String typeName = annotations[i].annotationType().getSimpleName();
            if ("nullable".equalsIgnoreCase(typeName)) {
                return AutoReadWriteNullability.NULLABLE;
            }
            if (!"nonnull".equalsIgnoreCase(typeName) && !"notnull".equalsIgnoreCase(typeName)) continue;
            return AutoReadWriteNullability.NON_NULL;
        }
        return this.getDefaultNullability(context.extensionsData());
    }

    private AutoReadWriteNullability getDefaultNullability(Patchwork extensionsData) {
        assert (this.customDataAccess != null);
        CustomData customData = extensionsData.get(this.customDataAccess);
        if (customData != null && customData.defaultNullability() != null) {
            return customData.defaultNullability();
        }
        return AutoReadWriteNullability.NON_NULL;
    }

    private static final class CustomData {
        private final @Nullable AutoReadWriteNullability defaultNullability;
        private final @Nullable AutoReadWriteNullability innerDefaultNullability;

        @Generated
        public CustomData(@Nullable AutoReadWriteNullability defaultNullability, @Nullable AutoReadWriteNullability innerDefaultNullability) {
            this.defaultNullability = defaultNullability;
            this.innerDefaultNullability = innerDefaultNullability;
        }

        @Generated
        public @Nullable AutoReadWriteNullability defaultNullability() {
            return this.defaultNullability;
        }

        @Generated
        public @Nullable AutoReadWriteNullability innerDefaultNullability() {
            return this.innerDefaultNullability;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomData)) {
                return false;
            }
            CustomData other = (CustomData)o;
            AutoReadWriteNullability this$defaultNullability = this.defaultNullability();
            AutoReadWriteNullability other$defaultNullability = other.defaultNullability();
            if (this$defaultNullability == null ? other$defaultNullability != null : !((Object)((Object)this$defaultNullability)).equals((Object)other$defaultNullability)) {
                return false;
            }
            AutoReadWriteNullability this$innerDefaultNullability = this.innerDefaultNullability();
            AutoReadWriteNullability other$innerDefaultNullability = other.innerDefaultNullability();
            return !(this$innerDefaultNullability == null ? other$innerDefaultNullability != null : !((Object)((Object)this$innerDefaultNullability)).equals((Object)other$innerDefaultNullability));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AutoReadWriteNullability $defaultNullability = this.defaultNullability();
            result = result * 59 + ($defaultNullability == null ? 43 : ((Object)((Object)$defaultNullability)).hashCode());
            AutoReadWriteNullability $innerDefaultNullability = this.innerDefaultNullability();
            result = result * 59 + ($innerDefaultNullability == null ? 43 : ((Object)((Object)$innerDefaultNullability)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AutoNullableReadWritePojoWeavingProcessor.CustomData(defaultNullability=" + (Object)((Object)this.defaultNullability()) + ", innerDefaultNullability=" + (Object)((Object)this.innerDefaultNullability()) + ")";
        }
    }
}

