/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojoext.validation.api.validators;

import de.siphalor.tweed5.construct.api.ConstructParameter;
import de.siphalor.tweed5.construct.api.TweedConstruct;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationResult;
import de.siphalor.tweed5.defaultextensions.validation.api.validators.NumberRangeValidator;
import de.siphalor.tweed5.weaver.pojoext.validation.api.validators.WeavableConfigEntryValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

public final class WeavableNumberRangeValidator
implements WeavableConfigEntryValidator {
    private static final String NUMBER_PATTERN = "[+-]?\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?";
    private static final Pattern CONFIG_PATTERN = Pattern.compile("^([+-]?\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?=?)?\\.\\.(=?[+-]?\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)?$");
    private final NumberRangeValidator<Number> validator;

    @TweedConstruct(value=WeavableConfigEntryValidator.class)
    @ApiStatus.Internal
    public static WeavableNumberRangeValidator construct(ConfigEntry<?> configEntry, @ConstructParameter(name="config") String config) {
        String maxGroup;
        if (config.isEmpty()) {
            throw new IllegalArgumentException("Config is required for number range validator");
        }
        Matcher matcher = CONFIG_PATTERN.matcher(config);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid config: " + config + "; expected format: [<min>[=]]..[[=]<max>]");
        }
        Class<? extends Number> numberClass = WeavableNumberRangeValidator.boxClass(configEntry.valueClass());
        NumberRangeValidator.Builder<? extends Number> builder = NumberRangeValidator.builder(numberClass);
        String minGroup = matcher.group(1);
        if (minGroup != null) {
            if (minGroup.endsWith("=")) {
                minGroup = minGroup.substring(0, minGroup.length() - 1);
                builder.greaterThanOrEqualTo(WeavableNumberRangeValidator.parseNumber(minGroup, numberClass));
            } else {
                builder.greaterThan(WeavableNumberRangeValidator.parseNumber(minGroup, numberClass));
            }
        }
        if ((maxGroup = matcher.group(2)) != null) {
            if (maxGroup.startsWith("=")) {
                maxGroup = maxGroup.substring(1);
                builder.lessThanOrEqualTo(WeavableNumberRangeValidator.parseNumber(maxGroup, numberClass));
            } else {
                builder.lessThan(WeavableNumberRangeValidator.parseNumber(maxGroup, numberClass));
            }
        }
        return new WeavableNumberRangeValidator(builder.build());
    }

    private static Class<? extends Number> boxClass(Class<? extends Number> numberClass) {
        if (numberClass == Byte.TYPE) {
            return Byte.class;
        }
        if (numberClass == Short.TYPE) {
            return Short.class;
        }
        if (numberClass == Integer.TYPE) {
            return Integer.class;
        }
        if (numberClass == Long.TYPE) {
            return Long.class;
        }
        if (numberClass == Float.TYPE) {
            return Float.class;
        }
        if (numberClass == Double.TYPE) {
            return Double.class;
        }
        return numberClass;
    }

    private static Number parseNumber(String number, Class<? extends Number> numberClass) {
        if (numberClass == Byte.class) {
            return Byte.valueOf(number);
        }
        if (numberClass == Short.class) {
            return Short.valueOf(number);
        }
        if (numberClass == Integer.class) {
            return Integer.valueOf(number);
        }
        if (numberClass == Long.class) {
            return Long.valueOf(number);
        }
        if (numberClass == Float.class) {
            return Float.valueOf(number);
        }
        if (numberClass == Double.class) {
            return Double.valueOf(number);
        }
        throw new IllegalArgumentException("Unsupported number class: " + numberClass.getName());
    }

    @Override
    public <T> ValidationResult<T> validate(ConfigEntry<T> configEntry, T value) {
        return this.validator.validate(configEntry, value);
    }

    @Override
    public <T> String description(ConfigEntry<T> configEntry) {
        return this.validator.description(configEntry);
    }

    @Generated
    public NumberRangeValidator<Number> validator() {
        return this.validator;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeavableNumberRangeValidator)) {
            return false;
        }
        WeavableNumberRangeValidator other = (WeavableNumberRangeValidator)o;
        NumberRangeValidator<Number> this$validator = this.validator();
        NumberRangeValidator<Number> other$validator = other.validator();
        return !(this$validator == null ? other$validator != null : !((Object)this$validator).equals(other$validator));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NumberRangeValidator<Number> $validator = this.validator();
        result = result * 59 + ($validator == null ? 43 : ((Object)$validator).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WeavableNumberRangeValidator(validator=" + this.validator() + ")";
    }

    @Generated
    private WeavableNumberRangeValidator(NumberRangeValidator<Number> validator) {
        this.validator = validator;
    }
}

