/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.annotationinheritance.impl;

import de.siphalor.tweed5.annotationinheritance.api.AnnotationInheritance;
import de.siphalor.tweed5.annotationinheritance.impl.RepeatableAnnotationContainerHelper;
import de.siphalor.tweed5.typeutils.api.annotations.AnnotationRepeatType;
import de.siphalor.tweed5.utils.api.collection.ClassToInstanceMap;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import lombok.Generated;

public class AnnotationInheritanceResolver {
    private final AnnotatedElement main;
    private final Map<Class<? extends Annotation>, Aggregator> aggregators = new LinkedHashMap<Class<? extends Annotation>, Aggregator>();
    private static final Set<Class<? extends Annotation>> IGNORED_META_ANNOTATIONS = new CopyOnWriteArraySet<Class>(Arrays.asList(Target.class, Retention.class, AnnotationInheritance.class));

    public ClassToInstanceMap<Annotation> resolve() {
        this.resolve(this.main, Collections.emptySet());
        ClassToInstanceMap<Annotation> resolvedAnnotations = ClassToInstanceMap.backedBy(new LinkedHashMap());
        ArrayList<Aggregator> aggregatorList = new ArrayList<Aggregator>(this.aggregators.values());
        for (int i = aggregatorList.size() - 1; i >= 0; --i) {
            Aggregator aggregator = (Aggregator)aggregatorList.get(i);
            if (aggregator.annotations.size() == 1) {
                resolvedAnnotations.put(aggregator.repeatType.annotationClass(), (Annotation)aggregator.annotations.iterator().next());
                continue;
            }
            if (aggregator.annotations.isEmpty()) continue;
            Annotation[] annotations = (Annotation[])Array.newInstance(aggregator.repeatType.annotationClass(), aggregator.annotations.size());
            int j = aggregator.annotations.size() - 1;
            for (Annotation annotation : aggregator.annotations) {
                annotations[j--] = annotation;
            }
            Annotation containerAnnotation = RepeatableAnnotationContainerHelper.createContainer((Annotation[])annotations);
            resolvedAnnotations.put(containerAnnotation.annotationType(), containerAnnotation);
        }
        return resolvedAnnotations;
    }

    private void resolve(AnnotatedElement annotatedElement, Set<Class<? extends Annotation>> overriden) {
        AnnotationRepeatType repeatType;
        AnnotationInheritance inheritanceConfig = annotatedElement.getAnnotation(AnnotationInheritance.class);
        HashSet<Class<? extends Annotation>> passOnAnnotations = null;
        HashSet<Class<? extends Annotation>> overridenOnwards = new HashSet<Class<? extends Annotation>>(overriden);
        if (annotatedElement != this.main) {
            if (inheritanceConfig == null || inheritanceConfig.passOn().length == 0) {
                return;
            }
            passOnAnnotations = new HashSet<Class<? extends Annotation>>(inheritanceConfig.passOn().length + 5);
            for (Class<? extends Annotation> passOn : inheritanceConfig.passOn()) {
                passOnAnnotations.add(passOn);
                repeatType = AnnotationRepeatType.getType(passOn);
                if (!(repeatType instanceof AnnotationRepeatType.Repeatable)) continue;
                passOnAnnotations.add(((AnnotationRepeatType.Repeatable)repeatType).containerAnnotationClass());
            }
        }
        if (inheritanceConfig != null) {
            for (Class<? extends Annotation> override : inheritanceConfig.override()) {
                overridenOnwards.add(override);
                repeatType = AnnotationRepeatType.getType(override);
                if (!(repeatType instanceof AnnotationRepeatType.Repeatable)) continue;
                overridenOnwards.add(((AnnotationRepeatType.Repeatable)repeatType).containerAnnotationClass());
            }
        }
        Annotation[] annotations = annotatedElement.getAnnotations();
        for (int i = annotations.length - 1; i >= 0; --i) {
            Annotation annotation = annotations[i];
            if (passOnAnnotations != null && !passOnAnnotations.contains(annotation.annotationType()) || IGNORED_META_ANNOTATIONS.contains(annotation.annotationType()) || overriden.contains(annotation.annotationType())) continue;
            Aggregator aggregator = this.aggregators.get(annotation.annotationType());
            if (aggregator != null) {
                repeatType = aggregator.repeatType;
                if (repeatType instanceof AnnotationRepeatType.Repeatable) {
                    aggregator.annotations.add(annotation);
                }
            } else {
                repeatType = AnnotationRepeatType.getType(annotation.annotationType());
                if (repeatType instanceof AnnotationRepeatType.NonRepeatable) {
                    aggregator = new Aggregator(repeatType, Collections.singleton(annotation));
                    this.aggregators.put(annotation.annotationType(), aggregator);
                    overridenOnwards.add(annotation.annotationType());
                } else if (repeatType instanceof AnnotationRepeatType.Repeatable) {
                    ArrayList<Annotation> repeatableAnnotations = new ArrayList<Annotation>();
                    repeatableAnnotations.add(annotation);
                    aggregator = new Aggregator(repeatType, repeatableAnnotations);
                    this.aggregators.put(annotation.annotationType(), aggregator);
                } else if (repeatType instanceof AnnotationRepeatType.RepeatableContainer) {
                    AnnotationRepeatType.RepeatableContainer containerRepeatType = (AnnotationRepeatType.RepeatableContainer)repeatType;
                    Class<? extends Annotation> elementAnnotationType = containerRepeatType.elementAnnotationClass();
                    Annotation[] elements = containerRepeatType.elements(annotation);
                    aggregator = this.aggregators.get(elementAnnotationType);
                    if (aggregator != null) {
                        for (int j = elements.length - 1; j >= 0; --j) {
                            aggregator.annotations.add(elements[j]);
                        }
                    } else {
                        ArrayList<Annotation> repeatedAnnotations = new ArrayList<Annotation>(elements.length);
                        for (int e = elements.length - 1; e >= 0; --e) {
                            repeatedAnnotations.add(elements[e]);
                        }
                        this.aggregators.put(containerRepeatType.elementAnnotationClass(), new Aggregator(containerRepeatType.elementRepeatType(), repeatedAnnotations));
                    }
                }
            }
            if (!(repeatType instanceof AnnotationRepeatType.NonRepeatable) || !annotation.annotationType().isAnnotationPresent(AnnotationInheritance.class)) continue;
            this.resolve(annotation.annotationType(), overridenOnwards);
        }
    }

    @Generated
    public AnnotationInheritanceResolver(AnnotatedElement main) {
        this.main = main;
    }

    private static final class Aggregator {
        private final AnnotationRepeatType repeatType;
        private final Collection<Annotation> annotations;

        @Generated
        public Aggregator(AnnotationRepeatType repeatType, Collection<Annotation> annotations) {
            this.repeatType = repeatType;
            this.annotations = annotations;
        }

        @Generated
        public AnnotationRepeatType repeatType() {
            return this.repeatType;
        }

        @Generated
        public Collection<Annotation> annotations() {
            return this.annotations;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Aggregator)) {
                return false;
            }
            Aggregator other = (Aggregator)o;
            AnnotationRepeatType this$repeatType = this.repeatType();
            AnnotationRepeatType other$repeatType = other.repeatType();
            if (this$repeatType == null ? other$repeatType != null : !((Object)this$repeatType).equals(other$repeatType)) {
                return false;
            }
            Collection<Annotation> this$annotations = this.annotations();
            Collection<Annotation> other$annotations = other.annotations();
            return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AnnotationRepeatType $repeatType = this.repeatType();
            result = result * 59 + ($repeatType == null ? 43 : ((Object)$repeatType).hashCode());
            Collection<Annotation> $annotations = this.annotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AnnotationInheritanceResolver.Aggregator(repeatType=" + this.repeatType() + ", annotations=" + this.annotations() + ")";
        }
    }
}

