/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.core.impl;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.container.ConfigContainerSetupPhase;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.extension.TweedExtension;
import de.siphalor.tweed5.core.api.extension.TweedExtensionSetupContext;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import de.siphalor.tweed5.patchwork.api.PatchworkFactory;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import de.siphalor.tweed5.utils.api.collection.InheritanceMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class DefaultConfigContainer<T>
implements ConfigContainer<T> {
    private ConfigContainerSetupPhase setupPhase = ConfigContainerSetupPhase.EXTENSIONS_SETUP;
    private final Set<Class<? extends TweedExtension>> requestedExtensions = new HashSet<Class<? extends TweedExtension>>();
    private final InheritanceMap<TweedExtension> extensions = new InheritanceMap<TweedExtension>(TweedExtension.class);
    private @Nullable ConfigEntry<T> rootEntry;
    private @Nullable PatchworkFactory entryExtensionsDataPatchworkFactory;

    @Override
    public void registerExtension(Class<? extends TweedExtension> extensionClass) {
        this.requireSetupPhase(ConfigContainerSetupPhase.EXTENSIONS_SETUP);
        this.requestedExtensions.add(extensionClass);
    }

    @Override
    public void finishExtensionSetup() {
        this.requireSetupPhase(ConfigContainerSetupPhase.EXTENSIONS_SETUP);
        final PatchworkFactory.Builder entryExtensionDataPatchworkFactoryBuilder = PatchworkFactory.builder();
        TweedExtensionSetupContext extensionSetupContext = new TweedExtensionSetupContext(){
            final /* synthetic */ DefaultConfigContainer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public <E> PatchworkPartAccess<E> registerEntryExtensionData(Class<E> dataClass) {
                return entryExtensionDataPatchworkFactoryBuilder.registerPart(dataClass);
            }

            @Override
            public void registerExtension(Class<? extends TweedExtension> extensionClass) {
                if (!this.this$0.extensions.containsAnyInstanceForClass(extensionClass)) {
                    this.this$0.requestedExtensions.add(extensionClass);
                }
            }
        };
        HashSet<Class> abstractExtensionClasses = new HashSet<Class>();
        while (true) {
            Class extensionClass;
            if (!this.requestedExtensions.isEmpty()) {
                extensionClass = DefaultConfigContainer.popFromIterable(this.requestedExtensions);
                if (this.isAbstractClass(extensionClass)) {
                    abstractExtensionClasses.add(extensionClass);
                    continue;
                }
                this.extensions.put((TweedExtension)this.instantiateExtension(extensionClass, extensionSetupContext));
                continue;
            }
            if (abstractExtensionClasses.isEmpty()) break;
            extensionClass = (Class)DefaultConfigContainer.popFromIterable(abstractExtensionClasses);
            if (this.extensions.containsAnyInstanceForClass(extensionClass)) continue;
            this.extensions.put((TweedExtension)this.instantiateAbstractExtension(extensionClass, extensionSetupContext));
        }
        this.entryExtensionsDataPatchworkFactory = entryExtensionDataPatchworkFactoryBuilder.build();
        this.setupPhase = ConfigContainerSetupPhase.TREE_SETUP;
        this.extensions.values().forEach(TweedExtension::extensionsFinalized);
    }

    private static <T> T popFromIterable(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        T value = iterator.next();
        iterator.remove();
        return value;
    }

    protected <E extends TweedExtension> E instantiateAbstractExtension(Class<E> extensionClass, TweedExtensionSetupContext setupContext) {
        try {
            Field defaultField = extensionClass.getDeclaredField("DEFAULT");
            if (defaultField.getType() != Class.class) {
                throw new IllegalStateException(this.createAbstractExtensionInstantiationExceptionMessage(extensionClass, "DEFAULT field has incorrect class " + defaultField.getType().getName() + "."));
            }
            if ((defaultField.getModifiers() & 8) == 0) {
                throw new IllegalStateException(this.createAbstractExtensionInstantiationExceptionMessage(extensionClass, "DEFAULT field is not static."));
            }
            if ((defaultField.getModifiers() & 1) == 0) {
                throw new IllegalStateException(this.createAbstractExtensionInstantiationExceptionMessage(extensionClass, "DEFAULT field is not public."));
            }
            Class defaultClass = (Class)defaultField.get(null);
            if (!extensionClass.isAssignableFrom(defaultClass)) {
                throw new IllegalStateException(this.createAbstractExtensionInstantiationExceptionMessage(extensionClass, "DEFAULT field contains class " + defaultClass.getName() + ", but that class does not inherit from " + extensionClass.getName()));
            }
            return this.instantiateExtension(defaultClass, setupContext);
        }
        catch (NoSuchFieldException ignored) {
            throw new IllegalStateException(this.createAbstractExtensionInstantiationExceptionMessage(extensionClass, null));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(this.createAbstractExtensionInstantiationExceptionMessage(extensionClass, "Couldn't access DEFAULT field."), e);
        }
    }

    private String createAbstractExtensionInstantiationExceptionMessage(Class<?> extensionClass, @Nullable String detail) {
        StringBuilder sb = new StringBuilder();
        sb.append("Requested extension class ").append(extensionClass.getName()).append(" is ");
        if (extensionClass.isInterface()) {
            sb.append("an interface ");
        } else {
            sb.append("an abstract class ");
        }
        sb.append("and cannot be instantiated directly.\n");
        sb.append("As the extension developer you can declare a public static DEFAULT field containing the class of ");
        sb.append("a default implementation.\n");
        sb.append("As a user you can try registering an implementation of the extension class directly.");
        if (detail != null) {
            sb.append("\n");
            sb.append(detail);
        }
        return sb.toString();
    }

    protected <E extends TweedExtension> E instantiateExtension(Class<E> extensionClass, TweedExtensionSetupContext setupContext) {
        if (this.isAbstractClass(extensionClass)) {
            throw new IllegalStateException("Cannot instantiate extension class " + extensionClass.getName() + " as it is abstract");
        }
        return (E)((TweedExtension)TweedExtension.FACTORY.construct(extensionClass).typedArg(TweedExtensionSetupContext.class, setupContext).typedArg(ConfigContainer.class, this).finish());
    }

    private boolean isAbstractClass(Class<?> clazz) {
        return clazz.isInterface() || (clazz.getModifiers() & 0x400) != 0;
    }

    @Override
    public <E extends TweedExtension> Optional<E> extension(Class<E> extensionClass) {
        this.requireSetupPhase(ConfigContainerSetupPhase.TREE_SETUP, ConfigContainerSetupPhase.TREE_ATTACHED, ConfigContainerSetupPhase.INITIALIZED);
        try {
            return Optional.ofNullable((TweedExtension)this.extensions.getSingleInstance(extensionClass));
        }
        catch (InheritanceMap.NonUniqueResultException e) {
            throw new IllegalStateException("Multiple extensions registered for class " + extensionClass.getName(), e);
        }
    }

    @Override
    public Collection<TweedExtension> extensions() {
        this.requireSetupPhase(ConfigContainerSetupPhase.TREE_SETUP, ConfigContainerSetupPhase.TREE_ATTACHED, ConfigContainerSetupPhase.INITIALIZED);
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public void attachTree(ConfigEntry<T> rootEntry) {
        this.requireSetupPhase(ConfigContainerSetupPhase.TREE_SETUP);
        this.rootEntry = rootEntry;
        this.setupPhase = ConfigContainerSetupPhase.TREE_ATTACHED;
    }

    @Override
    public Patchwork createExtensionsData() {
        this.requireSetupPhase(ConfigContainerSetupPhase.TREE_SETUP);
        assert (this.entryExtensionsDataPatchworkFactory != null);
        return this.entryExtensionsDataPatchworkFactory.create();
    }

    @Override
    public void initialize() {
        this.requireSetupPhase(ConfigContainerSetupPhase.TREE_ATTACHED);
        for (TweedExtension extension : this.extensions()) {
            extension.initialize();
        }
        assert (this.rootEntry != null);
        this.rootEntry.visitInOrder(entry -> {
            for (TweedExtension extension : this.extensions()) {
                extension.initEntry(entry);
            }
        });
        this.setupPhase = ConfigContainerSetupPhase.INITIALIZED;
    }

    @Override
    public ConfigEntry<T> rootEntry() {
        this.requireSetupPhase(ConfigContainerSetupPhase.TREE_ATTACHED, ConfigContainerSetupPhase.INITIALIZED);
        assert (this.rootEntry != null);
        return this.rootEntry;
    }

    private void requireSetupPhase(ConfigContainerSetupPhase ... allowedPhases) {
        for (ConfigContainerSetupPhase allowedPhase : allowedPhases) {
            if (allowedPhase != this.setupPhase) continue;
            return;
        }
        if (allowedPhases.length == 1) {
            throw new IllegalStateException("Config container is not in correct phase, expected " + (Object)((Object)allowedPhases[0]) + ", but is in " + (Object)((Object)this.setupPhase));
        }
        throw new IllegalStateException("Config container is not in correct phase, expected any of " + Arrays.toString((Object[])allowedPhases) + ", but is in " + (Object)((Object)this.setupPhase));
    }

    @Override
    @Generated
    public ConfigContainerSetupPhase setupPhase() {
        return this.setupPhase;
    }
}

