/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.presets.impl;

import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntryValueVisitor;
import de.siphalor.tweed5.core.api.extension.TweedExtensionSetupContext;
import de.siphalor.tweed5.defaultextensions.presets.api.PresetsExtension;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class PresetsExtensionImpl
implements PresetsExtension {
    private final PatchworkPartAccess<Map<String, Object>> presetsDataAccess;

    public PresetsExtensionImpl(TweedExtensionSetupContext setupContext) {
        this.presetsDataAccess = setupContext.registerEntryExtensionData(Map.class);
    }

    @Override
    public <T> void presetValue(ConfigEntry<T> entry, final String name, T value) {
        if (value != null && !entry.valueClass().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("The preset value is not of the expected type " + entry.valueClass().getName());
        }
        entry.visitInOrder(new ConfigEntryValueVisitor(){
            final /* synthetic */ PresetsExtensionImpl this$0;
            {
                this.this$0 = this$0;
            }

            public <U> void visitEntry(ConfigEntry<U> entry, U value) {
                this.this$0.getOrCreatePresetsData(entry.extensionsData()).put(name, value);
            }
        }, value);
    }

    @Override
    public <T> @Nullable T presetValue(ConfigEntry<T> entry, String name) {
        return (T)this.getPresetsData(entry.extensionsData()).get(name);
    }

    private Map<String, Object> getOrCreatePresetsData(Patchwork extensionsData) {
        Map<String, Object> data = extensionsData.get(this.presetsDataAccess);
        if (data == null) {
            data = new HashMap<String, Object>();
            extensionsData.set(this.presetsDataAccess, data);
        }
        return data;
    }

    private Map<String, Object> getPresetsData(Patchwork extensionsData) {
        Map<String, Object> data = extensionsData.get(this.presetsDataAccess);
        return data != null ? data : Collections.emptyMap();
    }
}

