/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.weaver.pojo.impl.weaving;

import de.siphalor.tweed5.shadowed.org.apache.commons.logging.Log;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.LogFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class PojoClassIntrospector {
    @Generated
    private static final Log log = LogFactory.getLog(PojoClassIntrospector.class);
    private final Class<?> clazz;
    private final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private @Nullable Map<String, Property> properties;

    public static PojoClassIntrospector forClass(Class<?> clazz) {
        if ((clazz.getModifiers() & 1) == 0) {
            throw new IllegalStateException("Class " + clazz.getName() + " must be public");
        }
        return new PojoClassIntrospector(clazz);
    }

    public Class<?> type() {
        return this.clazz;
    }

    public @Nullable MethodHandle noArgsConstructor() {
        try {
            return this.lookup.findConstructor(this.clazz, MethodType.methodType(Void.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    public Map<String, Property> properties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Property>();
            for (Class<?> currentClass = this.clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
                this.appendClassProperties(currentClass);
            }
        }
        return Collections.unmodifiableMap(this.properties);
    }

    private void appendClassProperties(Class<?> targetClass) {
        try {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                if (this.shouldIgnoreField(field)) continue;
                if (!this.properties.containsKey(field.getName())) {
                    Property property = this.introspectProperty(field);
                    this.properties.put(property.field.getName(), property);
                    continue;
                }
                Property existingProperty = this.properties.get(field.getName());
                log.error("Duplicate property \"" + field.getName() + "\" detected in hierarchy of " + this.clazz.getName() + " in classes: " + existingProperty.field().getDeclaringClass().getName() + " and " + targetClass.getName());
            }
        }
        catch (Exception e) {
            log.error("Got unexpected error introspecting the properties of class " + targetClass.getName() + " (in hierarchy of " + this.clazz.getName() + ")", e);
        }
    }

    private boolean shouldIgnoreField(Field field) {
        return (field.getModifiers() & 0x88) != 0;
    }

    private Property introspectProperty(Field field) {
        int modifiers = field.getModifiers();
        return Property.builder().field(field).isFinal((modifiers & 0x10) != 0).getter(this.findGetter(field)).setter(this.findSetter(field)).type(field.getGenericType()).build();
    }

    private @Nullable MethodHandle findGetter(Field field) {
        String fieldName = field.getName();
        MethodHandle method = this.findMethod(this.clazz, new MethodDescriptor(fieldName, MethodType.methodType(field.getType())));
        if (method != null) {
            return method;
        }
        if ((field.getType() == Boolean.class || field.getType() == Boolean.TYPE) && (method = this.findMethod(this.clazz, new MethodDescriptor("is" + PojoClassIntrospector.firstToUpper(fieldName), MethodType.methodType(field.getType())))) != null) {
            return method;
        }
        method = this.findMethod(this.clazz, new MethodDescriptor("get" + PojoClassIntrospector.firstToUpper(fieldName), MethodType.methodType(field.getType())));
        if (method != null) {
            return method;
        }
        int modifiers = field.getModifiers();
        if ((modifiers & 1) != 0) {
            return this.findFieldGetter(field);
        }
        return null;
    }

    private @Nullable MethodHandle findSetter(Field field) {
        String fieldName = field.getName();
        String classicSetterName = "set" + PojoClassIntrospector.firstToUpper(fieldName);
        MethodHandle method = this.findFirstMethod(this.clazz, new MethodDescriptor(fieldName, MethodType.methodType(Void.TYPE, field.getType())), new MethodDescriptor(fieldName, MethodType.methodType(field.getDeclaringClass(), field.getType())), new MethodDescriptor(classicSetterName, MethodType.methodType(Void.TYPE, field.getType())), new MethodDescriptor(classicSetterName, MethodType.methodType(field.getDeclaringClass(), field.getType())));
        if (method != null) {
            return method;
        }
        int modifiers = field.getModifiers();
        if ((modifiers & 1) != 0) {
            return this.findFieldSetter(field);
        }
        return null;
    }

    private @Nullable MethodHandle findFirstMethod(Class<?> targetClass, MethodDescriptor ... methodDescriptors) {
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            MethodHandle method = this.findMethod(targetClass, methodDescriptor);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private @Nullable MethodHandle findMethod(Class<?> targetClass, MethodDescriptor methodDescriptor) {
        try {
            return this.lookup.findVirtual(targetClass, methodDescriptor.name(), methodDescriptor.methodType());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            log.warn("Failed to access method \"" + methodDescriptor + "\" of class " + targetClass.getName() + " in hierarchy of " + this.clazz.getName(), e);
            return null;
        }
    }

    private @Nullable MethodHandle findFieldGetter(Field field) {
        try {
            return this.lookup.findGetter(field.getDeclaringClass(), field.getName(), field.getType());
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            log.warn("Failed to access getter for field \"" + field.getName() + "\" of class " + field.getDeclaringClass().getName() + " in hierarchy of " + this.clazz.getName(), e);
            return null;
        }
    }

    private @Nullable MethodHandle findFieldSetter(Field field) {
        try {
            return this.lookup.findSetter(field.getDeclaringClass(), field.getName(), field.getType());
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            log.warn("Failed to access setter for field \"" + field.getName() + "\" of class " + field.getDeclaringClass().getName() + " in hierarchy of " + this.clazz.getName(), e);
            return null;
        }
    }

    private static String firstToUpper(String text) {
        return Character.toUpperCase(text.charAt(0)) + text.substring(1);
    }

    @Generated
    private PojoClassIntrospector(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static final class Property {
        private final Field field;
        private final boolean isFinal;
        private final Type type;
        private final @Nullable MethodHandle getter;
        private final @Nullable MethodHandle setter;

        @Generated
        Property(Field field, boolean isFinal, Type type, @Nullable MethodHandle getter, @Nullable MethodHandle setter) {
            this.field = field;
            this.isFinal = isFinal;
            this.type = type;
            this.getter = getter;
            this.setter = setter;
        }

        @Generated
        public static PropertyBuilder builder() {
            return new PropertyBuilder();
        }

        @Generated
        public Field field() {
            return this.field;
        }

        @Generated
        public boolean isFinal() {
            return this.isFinal;
        }

        @Generated
        public Type type() {
            return this.type;
        }

        @Generated
        public @Nullable MethodHandle getter() {
            return this.getter;
        }

        @Generated
        public @Nullable MethodHandle setter() {
            return this.setter;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            if (this.isFinal() != other.isFinal()) {
                return false;
            }
            Field this$field = this.field();
            Field other$field = other.field();
            if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
                return false;
            }
            Type this$type = this.type();
            Type other$type = other.type();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            MethodHandle this$getter = this.getter();
            MethodHandle other$getter = other.getter();
            if (this$getter == null ? other$getter != null : !this$getter.equals(other$getter)) {
                return false;
            }
            MethodHandle this$setter = this.setter();
            MethodHandle other$setter = other.setter();
            return !(this$setter == null ? other$setter != null : !this$setter.equals(other$setter));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFinal() ? 79 : 97);
            Field $field = this.field();
            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
            Type $type = this.type();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            MethodHandle $getter = this.getter();
            result = result * 59 + ($getter == null ? 43 : $getter.hashCode());
            MethodHandle $setter = this.setter();
            result = result * 59 + ($setter == null ? 43 : $setter.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PojoClassIntrospector.Property(field=" + this.field() + ", isFinal=" + this.isFinal() + ", type=" + this.type() + ", getter=" + this.getter() + ", setter=" + this.setter() + ")";
        }

        @Generated
        public static class PropertyBuilder {
            @Generated
            private Field field;
            @Generated
            private boolean isFinal;
            @Generated
            private Type type;
            @Generated
            private MethodHandle getter;
            @Generated
            private MethodHandle setter;

            @Generated
            PropertyBuilder() {
            }

            @Generated
            public PropertyBuilder field(Field field) {
                this.field = field;
                return this;
            }

            @Generated
            public PropertyBuilder isFinal(boolean isFinal) {
                this.isFinal = isFinal;
                return this;
            }

            @Generated
            public PropertyBuilder type(Type type) {
                this.type = type;
                return this;
            }

            @Generated
            public PropertyBuilder getter(@Nullable MethodHandle getter) {
                this.getter = getter;
                return this;
            }

            @Generated
            public PropertyBuilder setter(@Nullable MethodHandle setter) {
                this.setter = setter;
                return this;
            }

            @Generated
            public Property build() {
                return new Property(this.field, this.isFinal, this.type, this.getter, this.setter);
            }

            @Generated
            public String toString() {
                return "PojoClassIntrospector.Property.PropertyBuilder(field=" + this.field + ", isFinal=" + this.isFinal + ", type=" + this.type + ", getter=" + this.getter + ", setter=" + this.setter + ")";
            }
        }
    }

    private static final class MethodDescriptor {
        private final String name;
        private final MethodType methodType;

        @Generated
        public MethodDescriptor(String name, MethodType methodType) {
            this.name = name;
            this.methodType = methodType;
        }

        @Generated
        public String name() {
            return this.name;
        }

        @Generated
        public MethodType methodType() {
            return this.methodType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor other = (MethodDescriptor)o;
            String this$name = this.name();
            String other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            MethodType this$methodType = this.methodType();
            MethodType other$methodType = other.methodType();
            return !(this$methodType == null ? other$methodType != null : !((Object)this$methodType).equals(other$methodType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            MethodType $methodType = this.methodType();
            result = result * 59 + ($methodType == null ? 43 : ((Object)$methodType).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PojoClassIntrospector.MethodDescriptor(name=" + this.name() + ", methodType=" + this.methodType() + ")";
        }
    }
}

