package de.siphalor.tweed5.coat.bridge.api.mapping;

import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import org.jspecify.annotations.Nullable;
import java.util.function.Consumer;

public class TweedCoatEntryCreationContext<T> {
	private final ConfigEntry<T> entry;
	private final T currentValue;
	private final T defaultValue;
	@Nullable
	private final Consumer<T> parentSaveHandler;


	public static class TweedCoatEntryCreationContextBuilder<T> {
		private ConfigEntry<T> entry;
		private T currentValue;
		private T defaultValue;
		private Consumer<T> parentSaveHandler;

		TweedCoatEntryCreationContextBuilder() {
		}

		/**
		 * @return {@code this}.
		 */
		public TweedCoatEntryCreationContext.TweedCoatEntryCreationContextBuilder<T> entry(final ConfigEntry<T> entry) {
			this.entry = entry;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public TweedCoatEntryCreationContext.TweedCoatEntryCreationContextBuilder<T> currentValue(final T currentValue) {
			this.currentValue = currentValue;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public TweedCoatEntryCreationContext.TweedCoatEntryCreationContextBuilder<T> defaultValue(final T defaultValue) {
			this.defaultValue = defaultValue;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public TweedCoatEntryCreationContext.TweedCoatEntryCreationContextBuilder<T> parentSaveHandler(@Nullable final Consumer<T> parentSaveHandler) {
			this.parentSaveHandler = parentSaveHandler;
			return this;
		}

		public TweedCoatEntryCreationContext<T> build() {
			return new TweedCoatEntryCreationContext<T>(this.entry, this.currentValue, this.defaultValue, this.parentSaveHandler);
		}

		@Override
		public String toString() {
			return "TweedCoatEntryCreationContext.TweedCoatEntryCreationContextBuilder(entry=" + this.entry + ", currentValue=" + this.currentValue + ", defaultValue=" + this.defaultValue + ", parentSaveHandler=" + this.parentSaveHandler + ")";
		}
	}

	public static <T> TweedCoatEntryCreationContext.TweedCoatEntryCreationContextBuilder<T> builder() {
		return new TweedCoatEntryCreationContext.TweedCoatEntryCreationContextBuilder<T>();
	}

	private TweedCoatEntryCreationContext(final ConfigEntry<T> entry, final T currentValue, final T defaultValue, @Nullable final Consumer<T> parentSaveHandler) {
		this.entry = entry;
		this.currentValue = currentValue;
		this.defaultValue = defaultValue;
		this.parentSaveHandler = parentSaveHandler;
	}

	public ConfigEntry<T> entry() {
		return this.entry;
	}

	public T currentValue() {
		return this.currentValue;
	}

	public T defaultValue() {
		return this.defaultValue;
	}

	@Nullable
	public Consumer<T> parentSaveHandler() {
		return this.parentSaveHandler;
	}
}
