/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.coat.bridge.api.mapping.handler;

import de.siphalor.coat.handler.ConfigEntryHandler;
import de.siphalor.coat.handler.Message;
import de.siphalor.tweed5.coat.bridge.api.TweedCoatMappingUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.class_2561;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertingTweedCoatEntryHandler<T, C>
implements ConfigEntryHandler<C> {
    @Generated
    private static final Log log = LogFactory.getLog(ConvertingTweedCoatEntryHandler.class);
    private static final String CONVERSION_EXCEPTION_TEXT_KEY = "tweed5_coat_bridge.handler.conversion.exception";
    private final ConfigEntryHandler<T> inner;
    private final Function<T, C> toCoatMapper;
    private final Function<C, T> fromCoatMapper;

    public C getDefault() {
        return this.toCoatMapper.apply(this.inner.getDefault());
    }

    public Collection<Message> getMessages(C value) {
        try {
            T innerValue = this.fromCoatMapper.apply(value);
            return this.inner.getMessages(innerValue);
        }
        catch (Exception e) {
            return Collections.singletonList(new Message(Message.Level.ERROR, TweedCoatMappingUtils.translatableComponent(CONVERSION_EXCEPTION_TEXT_KEY, e.getMessage())));
        }
    }

    public void save(C value) {
        this.inner.save(this.convertSaveValue(value));
    }

    protected T convertSaveValue(C value) {
        try {
            return this.fromCoatMapper.apply(value);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to convert value " + value + " for saving, using default: " + this.inner.getDefault()), (Throwable)e);
            return (T)this.inner.getDefault();
        }
    }

    public class_2561 asText(C value) {
        return TweedCoatMappingUtils.literalComponent(Objects.toString(value));
    }

    @Generated
    public ConvertingTweedCoatEntryHandler(ConfigEntryHandler<T> inner, Function<T, C> toCoatMapper, Function<C, T> fromCoatMapper) {
        this.inner = inner;
        this.toCoatMapper = toCoatMapper;
        this.fromCoatMapper = fromCoatMapper;
    }
}

