/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.coat.bridge.api.mapping.handler;

import de.siphalor.coat.handler.ConfigEntryHandler;
import de.siphalor.coat.handler.Message;
import de.siphalor.tweed5.coat.bridge.api.TweedCoatMappingUtils;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.defaultextensions.validation.api.ValidationExtension;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssueLevel;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssues;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationResult;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.Log;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.LogFactory;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.network.chat.Component;

public class BasicTweedCoatEntryHandler<T>
implements ConfigEntryHandler<T> {
    @Generated
    private static final Log log = LogFactory.getLog(BasicTweedCoatEntryHandler.class);
    protected final ConfigEntry<T> configEntry;
    protected final T defaultValue;
    protected final Consumer<T> parentSaveHandler;
    protected final ValidationExtension validationExtension;

    public BasicTweedCoatEntryHandler(ConfigEntry<T> configEntry, T defaultValue, Consumer<T> parentSaveHandler) {
        this.configEntry = configEntry;
        this.defaultValue = defaultValue;
        this.parentSaveHandler = parentSaveHandler;
        this.validationExtension = (ValidationExtension)configEntry.container().extension(ValidationExtension.class).orElseThrow(() -> new IllegalStateException("No validation extension registered"));
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public Collection<Message> getMessages(T value) {
        ValidationIssues issues = this.validationExtension.validate(this.configEntry, value);
        return issues.issuesByPath().values().stream().flatMap(entryIssues -> entryIssues.issues().stream()).map(issue -> new Message(BasicTweedCoatEntryHandler.mapLevel(issue.level()), TweedCoatMappingUtils.literalComponent(issue.message()))).collect(Collectors.toList());
    }

    private static Message.Level mapLevel(ValidationIssueLevel level) {
        switch (level) {
            case INFO: {
                return Message.Level.INFO;
            }
            case WARN: {
                return Message.Level.WARNING;
            }
            case ERROR: {
                return Message.Level.ERROR;
            }
        }
        throw new IllegalStateException("Unknown validation issue level " + level);
    }

    public void save(T value) {
        this.parentSaveHandler.accept(this.processSaveValue(value));
    }

    public Component asText(T value) {
        return TweedCoatMappingUtils.literalComponent(Objects.toString(value));
    }

    protected T processSaveValue(T value) {
        ValidationResult validationResult = this.validationExtension.validateValueFlat(this.configEntry, value);
        if (validationResult.hasError()) {
            log.warn((Object)("Failed to save value " + value + " because of issues: " + validationResult.issues() + "; using default: " + this.defaultValue + " instead"));
            return this.defaultValue;
        }
        return (T)validationResult.value();
    }
}

