package de.siphalor.tweed5.coat.bridge.api;

import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import net.minecraft.network.chat.Component;
import org.jspecify.annotations.Nullable;
import java.util.function.Consumer;

public class ConfigScreenCreateParams<T extends @Nullable Object> {
	private final ConfigEntry<T> rootEntry;
	private final T currentValue;
	private final T defaultValue;
	/**
	 * The title of the screen, defaults to {@code translationKeyPrefix + ".title"}
	 */
	@Nullable
	private final Component title;
	/**
	 * The translation key prefix for all entries without a trailing dot.
	 */
	private final String translationKeyPrefix;
	@Nullable
	private final Consumer<T> saveHandler;

	/**
	 * Creates a new {@code ConfigScreenCreateParams} instance.
	 *
	 * @param rootEntry
	 * @param currentValue
	 * @param defaultValue
	 * @param title The title of the screen, defaults to {@code translationKeyPrefix + ".title"}
	 * @param translationKeyPrefix The translation key prefix for all entries without a trailing dot.
	 * @param saveHandler
	 */
	ConfigScreenCreateParams(final ConfigEntry<T> rootEntry, final T currentValue, final T defaultValue, @Nullable final Component title, final String translationKeyPrefix, @Nullable final Consumer<T> saveHandler) {
		this.rootEntry = rootEntry;
		this.currentValue = currentValue;
		this.defaultValue = defaultValue;
		this.title = title;
		this.translationKeyPrefix = translationKeyPrefix;
		this.saveHandler = saveHandler;
	}


	public static class ConfigScreenCreateParamsBuilder<T extends @Nullable Object> {
		private ConfigEntry<T> rootEntry;
		private T currentValue;
		private T defaultValue;
		private Component title;
		private String translationKeyPrefix;
		private Consumer<T> saveHandler;

		ConfigScreenCreateParamsBuilder() {
		}

		/**
		 * @return {@code this}.
		 */
		public ConfigScreenCreateParams.ConfigScreenCreateParamsBuilder<T> rootEntry(final ConfigEntry<T> rootEntry) {
			this.rootEntry = rootEntry;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public ConfigScreenCreateParams.ConfigScreenCreateParamsBuilder<T> currentValue(final T currentValue) {
			this.currentValue = currentValue;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public ConfigScreenCreateParams.ConfigScreenCreateParamsBuilder<T> defaultValue(final T defaultValue) {
			this.defaultValue = defaultValue;
			return this;
		}

		/**
		 * The title of the screen, defaults to {@code translationKeyPrefix + ".title"}
		 * @return {@code this}.
		 */
		public ConfigScreenCreateParams.ConfigScreenCreateParamsBuilder<T> title(@Nullable final Component title) {
			this.title = title;
			return this;
		}

		/**
		 * The translation key prefix for all entries without a trailing dot.
		 * @return {@code this}.
		 */
		public ConfigScreenCreateParams.ConfigScreenCreateParamsBuilder<T> translationKeyPrefix(final String translationKeyPrefix) {
			this.translationKeyPrefix = translationKeyPrefix;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public ConfigScreenCreateParams.ConfigScreenCreateParamsBuilder<T> saveHandler(@Nullable final Consumer<T> saveHandler) {
			this.saveHandler = saveHandler;
			return this;
		}

		public ConfigScreenCreateParams<T> build() {
			return new ConfigScreenCreateParams<T>(this.rootEntry, this.currentValue, this.defaultValue, this.title, this.translationKeyPrefix, this.saveHandler);
		}

		@Override
		public String toString() {
			return "ConfigScreenCreateParams.ConfigScreenCreateParamsBuilder(rootEntry=" + this.rootEntry + ", currentValue=" + this.currentValue + ", defaultValue=" + this.defaultValue + ", title=" + this.title + ", translationKeyPrefix=" + this.translationKeyPrefix + ", saveHandler=" + this.saveHandler + ")";
		}
	}

	public static <T extends @Nullable Object> ConfigScreenCreateParams.ConfigScreenCreateParamsBuilder<T> builder() {
		return new ConfigScreenCreateParams.ConfigScreenCreateParamsBuilder<T>();
	}

	public ConfigEntry<T> rootEntry() {
		return this.rootEntry;
	}

	public T currentValue() {
		return this.currentValue;
	}

	public T defaultValue() {
		return this.defaultValue;
	}

	/**
	 * The title of the screen, defaults to {@code translationKeyPrefix + ".title"}
	 */
	@Nullable
	public Component title() {
		return this.title;
	}

	/**
	 * The translation key prefix for all entries without a trailing dot.
	 */
	public String translationKeyPrefix() {
		return this.translationKeyPrefix;
	}

	@Nullable
	public Consumer<T> saveHandler() {
		return this.saveHandler;
	}
}
