/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.coat.bridge.impl;

import de.siphalor.coat.handler.ConfigEntryHandler;
import de.siphalor.coat.input.CheckBoxConfigInput;
import de.siphalor.coat.input.ConfigInput;
import de.siphalor.coat.input.CycleButtonConfigInput;
import de.siphalor.coat.input.TextConfigInput;
import de.siphalor.coat.list.DynamicEntryListWidget;
import de.siphalor.coat.list.complex.ConfigCategoryWidget;
import de.siphalor.coat.list.entry.ConfigCategoryConfigEntry;
import de.siphalor.coat.screen.ConfigContentWidget;
import de.siphalor.coat.util.EnumeratedMaterial;
import de.siphalor.tweed5.attributesextension.api.AttributesExtension;
import de.siphalor.tweed5.coat.bridge.api.TweedCoatMappingUtils;
import de.siphalor.tweed5.coat.bridge.api.mapping.TweedCoatEntryCreationContext;
import de.siphalor.tweed5.coat.bridge.api.mapping.TweedCoatEntryMappingContext;
import de.siphalor.tweed5.coat.bridge.api.mapping.TweedCoatEntryMappingResult;
import de.siphalor.tweed5.coat.bridge.api.mapping.TweedCoatMapper;
import de.siphalor.tweed5.coat.bridge.api.mapping.handler.BasicTweedCoatEntryHandler;
import de.siphalor.tweed5.coat.bridge.api.mapping.handler.ConvertingTweedCoatEntryHandler;
import de.siphalor.tweed5.coat.bridge.impl.CoatEnumMaterial;
import de.siphalor.tweed5.core.api.entry.CompoundConfigEntry;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;

public class TweedCoatMappersImpl {
    @Generated
    private static final Log log = LogFactory.getLog(TweedCoatMappersImpl.class);
    public static TweedCoatMapper<Byte> BYTE_TEXT_MAPPER = TweedCoatMappersImpl.convertingTextMapper(new Class[]{Byte.class, Byte.TYPE}, value -> Byte.toString(value), Byte::parseByte);
    public static TweedCoatMapper<Short> SHORT_TEXT_MAPPER = TweedCoatMappersImpl.convertingTextMapper(new Class[]{Short.class, Short.TYPE}, value -> Short.toString(value), Short::parseShort);
    public static TweedCoatMapper<Integer> INTEGER_TEXT_MAPPER = TweedCoatMappersImpl.convertingTextMapper(new Class[]{Integer.class, Integer.TYPE}, value -> Integer.toString(value), Integer::parseInt);
    public static TweedCoatMapper<Long> LONG_TEXT_MAPPER = TweedCoatMappersImpl.convertingTextMapper(new Class[]{Long.class, Long.TYPE}, value -> Long.toString(value), Long::parseLong);
    public static TweedCoatMapper<Float> FLOAT_TEXT_MAPPER = TweedCoatMappersImpl.convertingTextMapper(new Class[]{Float.class, Float.TYPE}, value -> Float.toString(value.floatValue()), Float::parseFloat);
    public static TweedCoatMapper<Double> DOUBLE_TEXT_MAPPER = TweedCoatMappersImpl.convertingTextMapper(new Class[]{Double.class, Double.TYPE}, value -> Double.toString(value), Double::parseDouble);
    public static TweedCoatMapper<Boolean> BOOLEAN_CHECKBOX_MAPPER = new SimpleMapper<Boolean>(new Class[]{Boolean.class, Boolean.TYPE}, CheckBoxConfigInput::new);
    public static TweedCoatMapper<String> STRING_TEXT_MAPPER = new SimpleMapper<String>(new Class[]{String.class}, TextConfigInput::new);
    public static TweedCoatMapper<Enum<?>> ENUM_CYCLE_BUTTON_MAPPER = new EnumCycleButtonMapper();
    public static TweedCoatMapper<Object> COMPOUND_CATEGORY_MAPPER = new CompoundCategoryMapper<Object>();

    public static <T> TweedCoatMapper<T> convertingTextMapper(Class<T>[] valueClasses, Function<T, String> textMapper, Function<String, T> textParser) {
        return new ConvertingTextMapper<T>(valueClasses, textMapper, textParser);
    }

    private static boolean anyClassMatches(Class<?> valueClass, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(valueClass)) continue;
            return true;
        }
        return false;
    }

    public static class ConvertingTextMapper<T>
    implements TweedCoatMapper<T> {
        private final Class<T>[] valueClasses;
        private final Function<T, String> textMapper;
        private final Function<String, T> textParser;

        @Override
        public TweedCoatEntryMappingResult<T, String> mapEntry(ConfigEntry<T> entry, TweedCoatEntryMappingContext context) {
            if (!TweedCoatMappersImpl.anyClassMatches(entry.valueClass(), this.valueClasses)) {
                return TweedCoatEntryMappingResult.notApplicable();
            }
            return new TweedCoatEntryMappingResult<T, String>(){

                @Override
                public boolean isApplicable() {
                    return true;
                }

                @Override
                public ConfigInput<String> createInput(TweedCoatEntryCreationContext<T> context) {
                    return new TextConfigInput((String)textMapper.apply(context.currentValue()));
                }

                @Override
                public ConfigEntryHandler<String> createHandler(TweedCoatEntryCreationContext<T> context) {
                    if (context.parentSaveHandler() == null) {
                        throw new IllegalArgumentException("No parent save handler provided");
                    }
                    return new ConvertingTweedCoatEntryHandler(new BasicTweedCoatEntryHandler(context.entry(), context.defaultValue(), context.parentSaveHandler()), textMapper, textParser);
                }

                @Override
                public @Nullable ConfigContentWidget createContentWidget(TweedCoatEntryCreationContext<T> context) {
                    return null;
                }
            };
        }

        @Generated
        public ConvertingTextMapper(Class<T>[] valueClasses, Function<T, String> textMapper, Function<String, T> textParser) {
            this.valueClasses = valueClasses;
            this.textMapper = textMapper;
            this.textParser = textParser;
        }
    }

    private static class SimpleMapper<T>
    implements TweedCoatMapper<T> {
        private final Class<T>[] valueClasses;
        private final Function<T, ConfigInput<T>> inputFactory;

        @Override
        public TweedCoatEntryMappingResult<T, T> mapEntry(ConfigEntry<T> entry, TweedCoatEntryMappingContext context) {
            if (!TweedCoatMappersImpl.anyClassMatches(entry.valueClass(), this.valueClasses)) {
                return TweedCoatEntryMappingResult.notApplicable();
            }
            return new TweedCoatEntryMappingResult<T, T>(){

                @Override
                public boolean isApplicable() {
                    return true;
                }

                @Override
                public ConfigInput<T> createInput(TweedCoatEntryCreationContext<T> context) {
                    return (ConfigInput)inputFactory.apply(context.currentValue());
                }

                @Override
                public ConfigEntryHandler<T> createHandler(TweedCoatEntryCreationContext<T> context) {
                    if (context.parentSaveHandler() == null) {
                        throw new IllegalArgumentException("No parent save handler provided");
                    }
                    return new BasicTweedCoatEntryHandler(context.entry(), context.defaultValue(), context.parentSaveHandler());
                }

                @Override
                public @Nullable ConfigContentWidget createContentWidget(TweedCoatEntryCreationContext<T> context) {
                    return null;
                }
            };
        }

        @Generated
        public SimpleMapper(Class<T>[] valueClasses, Function<T, ConfigInput<T>> inputFactory) {
            this.valueClasses = valueClasses;
            this.inputFactory = inputFactory;
        }
    }

    private static class EnumCycleButtonMapper<T extends Enum<?>>
    implements TweedCoatMapper<T> {
        private EnumCycleButtonMapper() {
        }

        @Override
        public TweedCoatEntryMappingResult<T, ?> mapEntry(ConfigEntry<T> entry, TweedCoatEntryMappingContext context) {
            if (!Enum.class.isAssignableFrom(entry.valueClass())) {
                return TweedCoatEntryMappingResult.notApplicable();
            }
            Class enumClass = entry.valueClass();
            String translationKeyPrefix = entry.container().extension(AttributesExtension.class).map(extension -> extension.getAttributeValue(entry, "enumTranslationKey")).orElse(enumClass.getPackage().getName());
            CoatEnumMaterial material = new CoatEnumMaterial(enumClass, translationKeyPrefix + ".");
            return new CycleButtonMappingResult(material);
        }
    }

    private static class CompoundCategoryMapper<T>
    implements TweedCoatMapper<T> {
        private CompoundCategoryMapper() {
        }

        @Override
        public TweedCoatEntryMappingResult<T, ?> mapEntry(ConfigEntry<T> entry, final TweedCoatEntryMappingContext mappingContext) {
            final class MappedEntry<U> {
                private final String name;
                private final String translationKeyPrefix;
                private final ConfigEntry<U> entry;
                private final TweedCoatEntryMappingContext mappingContext;
                private final TweedCoatEntryMappingResult<U, ?> mappingResult;

                @Generated
                public MappedEntry(String name, String translationKeyPrefix, ConfigEntry<U> entry, TweedCoatEntryMappingContext mappingContext, TweedCoatEntryMappingResult<U, ?> mappingResult) {
                    this.name = name;
                    this.translationKeyPrefix = translationKeyPrefix;
                    this.entry = entry;
                    this.mappingContext = mappingContext;
                    this.mappingResult = mappingResult;
                }

                @Generated
                public String name() {
                    return this.name;
                }

                @Generated
                public String translationKeyPrefix() {
                    return this.translationKeyPrefix;
                }

                @Generated
                public ConfigEntry<U> entry() {
                    return this.entry;
                }

                @Generated
                public TweedCoatEntryMappingContext mappingContext() {
                    return this.mappingContext;
                }

                @Generated
                public TweedCoatEntryMappingResult<U, ?> mappingResult() {
                    return this.mappingResult;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MappedEntry)) {
                        return false;
                    }
                    MappedEntry other = (MappedEntry)o;
                    String this$name = this.name();
                    String other$name = other.name();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    String this$translationKeyPrefix = this.translationKeyPrefix();
                    String other$translationKeyPrefix = other.translationKeyPrefix();
                    if (this$translationKeyPrefix == null ? other$translationKeyPrefix != null : !this$translationKeyPrefix.equals(other$translationKeyPrefix)) {
                        return false;
                    }
                    ConfigEntry<U> this$entry = this.entry();
                    ConfigEntry<U> other$entry = other.entry();
                    if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
                        return false;
                    }
                    TweedCoatEntryMappingContext this$mappingContext = this.mappingContext();
                    TweedCoatEntryMappingContext other$mappingContext = other.mappingContext();
                    if (this$mappingContext == null ? other$mappingContext != null : !this$mappingContext.equals(other$mappingContext)) {
                        return false;
                    }
                    TweedCoatEntryMappingResult<U, ?> this$mappingResult = this.mappingResult();
                    TweedCoatEntryMappingResult<U, ?> other$mappingResult = other.mappingResult();
                    return !(this$mappingResult == null ? other$mappingResult != null : !this$mappingResult.equals(other$mappingResult));
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $name = this.name();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    String $translationKeyPrefix = this.translationKeyPrefix();
                    result = result * 59 + ($translationKeyPrefix == null ? 43 : $translationKeyPrefix.hashCode());
                    ConfigEntry<U> $entry = this.entry();
                    result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
                    TweedCoatEntryMappingContext $mappingContext = this.mappingContext();
                    result = result * 59 + ($mappingContext == null ? 43 : $mappingContext.hashCode());
                    TweedCoatEntryMappingResult<U, ?> $mappingResult = this.mappingResult();
                    result = result * 59 + ($mappingResult == null ? 43 : $mappingResult.hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "MappedEntry(name=" + this.name() + ", translationKeyPrefix=" + this.translationKeyPrefix() + ", entry=" + this.entry() + ", mappingContext=" + this.mappingContext() + ", mappingResult=" + this.mappingResult() + ")";
                }
            }
            if (!(entry instanceof CompoundConfigEntry)) {
                return TweedCoatEntryMappingResult.notApplicable();
            }
            final CompoundConfigEntry compoundEntry = (CompoundConfigEntry)entry;
            Optional attributesExtension = entry.container().extension(AttributesExtension.class);
            final class_2960 backgroundTexture = attributesExtension.map(extension -> extension.getAttributeValue(entry, "backgroundTexture")).map(class_2960::method_12829).orElse(null);
            final String translationKey = attributesExtension.map(extension -> extension.getAttributeValue(entry, "translationKey")).orElse(mappingContext.translationKeyPrefix());
            final List mappedEntries = compoundEntry.subEntries().entrySet().stream().map(mapEntry -> {
                String subTranslationKeyPrefix = translationKey + "." + (String)mapEntry.getKey();
                TweedCoatEntryMappingContext subMappingContext = mappingContext.subContextBuilder((String)mapEntry.getKey()).translationKeyPrefix(subTranslationKeyPrefix).parentWidgetClass(ConfigCategoryWidget.class).build();
                return new MappedEntry((String)mapEntry.getKey(), subTranslationKeyPrefix, (ConfigEntry)mapEntry.getValue(), subMappingContext, subMappingContext.mapEntry((ConfigEntry)mapEntry.getValue(), subMappingContext));
            }).filter(mappedEntry -> ((MappedEntry)mappedEntry).mappingResult.isApplicable()).collect(Collectors.toList());
            return new TweedCoatEntryMappingResult<T, T>(){
                final /* synthetic */ CompoundCategoryMapper this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean isApplicable() {
                    return true;
                }

                @Override
                public @Nullable ConfigInput<T> createInput(TweedCoatEntryCreationContext<T> context) {
                    return null;
                }

                @Override
                public @Nullable ConfigEntryHandler<T> createHandler(TweedCoatEntryCreationContext<T> context) {
                    return null;
                }

                @Override
                public ConfigContentWidget createContentWidget(TweedCoatEntryCreationContext<T> context) {
                    ConfigCategoryWidget categoryWidget = new ConfigCategoryWidget(class_310.method_1551(), (class_2561)TweedCoatMappingUtils.translatableComponentWithFallback(translationKey, mappingContext.entryName()), Collections.emptyList(), backgroundTexture);
                    for (MappedEntry mappedEntry : mappedEntries) {
                        TweedCoatEntryMappingResult mappingResult = mappedEntry.mappingResult();
                        if (!mappingResult.isApplicable()) {
                            log.warn((Object)("Failed to resolve mapping for entry \"" + mappedEntry.name() + "\" at \"" + translationKey + "\". Entry will be ignored in UI."));
                            continue;
                        }
                        Object subEntryValue = compoundEntry.get(context.currentValue(), mappedEntry.name());
                        Object subEntryDefaultValue = compoundEntry.get(context.defaultValue(), mappedEntry.name());
                        TweedCoatEntryCreationContext<Object> creationContext = TweedCoatEntryCreationContext.builder().entry(mappedEntry.entry()).currentValue(subEntryValue).defaultValue(subEntryDefaultValue).parentSaveHandler(value -> compoundEntry.set(context.currentValue(), mappedEntry.name(), value)).build();
                        ConfigInput<?> input = mappingResult.createInput(creationContext);
                        if (input != null) {
                            ConfigCategoryConfigEntry entry = new ConfigCategoryConfigEntry(TweedCoatMappingUtils.translatableComponentWithFallback(mappedEntry.translationKeyPrefix(), mappedEntry.name()), TweedCoatMappingUtils.translatableComponentWithFallback(mappedEntry.translationKeyPrefix() + ".description", null), mappingResult.createHandler(creationContext), input);
                            categoryWidget.addEntry((DynamicEntryListWidget.Entry)entry);
                            continue;
                        }
                        ConfigContentWidget contentWidget = mappingResult.createContentWidget(creationContext);
                        if (contentWidget == null) continue;
                        categoryWidget.addSubTree(contentWidget);
                    }
                    return categoryWidget;
                }
            };
        }
    }

    private static class CycleButtonMappingResult<T>
    implements TweedCoatEntryMappingResult<T, T> {
        private final EnumeratedMaterial<T> material;

        @Override
        public boolean isApplicable() {
            return true;
        }

        @Override
        public ConfigInput<T> createInput(TweedCoatEntryCreationContext<T> context) {
            return new CycleButtonConfigInput(this.material, false, context.currentValue());
        }

        @Override
        public ConfigEntryHandler<T> createHandler(TweedCoatEntryCreationContext<T> context) {
            if (context.parentSaveHandler() == null) {
                throw new IllegalArgumentException("No parent save handler provided");
            }
            return new BasicTweedCoatEntryHandler<T>(context.entry(), context.defaultValue(), context.parentSaveHandler());
        }

        @Override
        public @Nullable ConfigContentWidget createContentWidget(TweedCoatEntryCreationContext<T> context) {
            return null;
        }

        @Generated
        public CycleButtonMappingResult(EnumeratedMaterial<T> material) {
            this.material = material;
        }
    }

    public static class EnumeratedMaterialCycleButtonMapper<T>
    implements TweedCoatMapper<T> {
        private final Class<T> valueClass;
        private final EnumeratedMaterial<T> material;

        @Override
        public TweedCoatEntryMappingResult<T, ?> mapEntry(ConfigEntry<T> entry, TweedCoatEntryMappingContext context) {
            if (!this.valueClass.isAssignableFrom(entry.valueClass())) {
                return TweedCoatEntryMappingResult.notApplicable();
            }
            return new CycleButtonMappingResult<T>(this.material);
        }

        @Generated
        public EnumeratedMaterialCycleButtonMapper(Class<T> valueClass, EnumeratedMaterial<T> material) {
            this.valueClass = valueClass;
            this.material = material;
        }
    }
}

