package de.siphalor.tweed5.coat.bridge.api.mapping;

import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import org.jspecify.annotations.Nullable;

public class TweedCoatEntryMappingContext {
	private final TweedCoatMapper<?> mappingDelegate;
	private final String entryName;
	private final String translationKeyPrefix;
	@Nullable
	private final Class<?> parentWidgetClass;

	public static Builder rootBuilder(TweedCoatMapper<?> mappingDelegate, String translationKeyPrefix) {
		return new Builder(mappingDelegate, "root", translationKeyPrefix);
	}

	public <T> TweedCoatEntryMappingResult<T, ?> mapEntry(ConfigEntry<T> entry, TweedCoatEntryMappingContext context) {
		//noinspection unchecked,rawtypes
		return (TweedCoatEntryMappingResult<T, ?>) mappingDelegate.mapEntry((ConfigEntry) entry, context);
	}

	public Builder subContextBuilder(String entryName) {
		return new Builder(mappingDelegate, entryName, translationKeyPrefix + "." + entryName);
	}


	public static class Builder {
		private final TweedCoatMapper<?> mappingDelegate;
		private final String entryName;
		private String translationKeyPrefix;
		@Nullable
		private Class<?> parentWidgetClass;

		private Builder(TweedCoatMapper<?> mappingDelegate, String entryName, String translationKeyPrefix) {
			this.mappingDelegate = mappingDelegate;
			this.entryName = entryName;
			this.translationKeyPrefix = translationKeyPrefix;
		}

		public TweedCoatEntryMappingContext build() {
			return new TweedCoatEntryMappingContext(mappingDelegate, entryName, translationKeyPrefix, parentWidgetClass);
		}

		/**
		 * @return {@code this}.
		 */
		public TweedCoatEntryMappingContext.Builder translationKeyPrefix(final String translationKeyPrefix) {
			this.translationKeyPrefix = translationKeyPrefix;
			return this;
		}

		/**
		 * @return {@code this}.
		 */
		public TweedCoatEntryMappingContext.Builder parentWidgetClass(@Nullable final Class<?> parentWidgetClass) {
			this.parentWidgetClass = parentWidgetClass;
			return this;
		}
	}

	public TweedCoatEntryMappingContext(final TweedCoatMapper<?> mappingDelegate, final String entryName, final String translationKeyPrefix, @Nullable final Class<?> parentWidgetClass) {
		this.mappingDelegate = mappingDelegate;
		this.entryName = entryName;
		this.translationKeyPrefix = translationKeyPrefix;
		this.parentWidgetClass = parentWidgetClass;
	}

	public String entryName() {
		return this.entryName;
	}

	public String translationKeyPrefix() {
		return this.translationKeyPrefix;
	}

	@Nullable
	public Class<?> parentWidgetClass() {
		return this.parentWidgetClass;
	}
}
