package de.siphalor.tweed5.core.api.entry;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.patchwork.api.Patchwork;

public abstract class BaseConfigEntry<T> implements ConfigEntry<T> {
	private final ConfigContainer<?> container;
	private final Class<T> valueClass;
	private final Patchwork extensionsData;

	public BaseConfigEntry(ConfigContainer<?> container, Class<T> valueClass) {
		this.container = container;
		this.valueClass = valueClass;
		this.extensionsData = container.createExtensionsData();
	}

	public ConfigContainer<?> container() {
		return this.container;
	}

	public Class<T> valueClass() {
		return this.valueClass;
	}

	public Patchwork extensionsData() {
		return this.extensionsData;
	}
}
