/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.core.api.middleware;

import de.siphalor.tweed5.core.api.middleware.Middleware;
import de.siphalor.tweed5.core.api.middleware.MiddlewareContainer;
import de.siphalor.tweed5.core.api.sort.AcyclicGraphSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class DefaultMiddlewareContainer<M>
implements MiddlewareContainer<M> {
    private static final String CONTAINER_ID = "";
    private List<Middleware<M>> middlewares = new ArrayList<Middleware<M>>();
    private final Set<String> middlewareIds = new HashSet<String>();
    private boolean sealed = false;

    @Override
    public String id() {
        return CONTAINER_ID;
    }

    @Override
    public void registerAll(Collection<Middleware<M>> middlewares) {
        this.requireUnsealed();
        for (Middleware<M> middleware : middlewares) {
            if (middleware.id().isEmpty()) {
                throw new IllegalArgumentException("Middleware id cannot be empty");
            }
            if (this.middlewareIds.add(middleware.id())) continue;
            throw new IllegalArgumentException("Middleware id already registered: " + middleware.id());
        }
        this.middlewares.addAll(middlewares);
    }

    @Override
    public void register(Middleware<M> middleware) {
        this.requireUnsealed();
        if (middleware.id().isEmpty()) {
            throw new IllegalArgumentException("Middleware id cannot be empty");
        }
        if (!this.middlewareIds.add(middleware.id())) {
            throw new IllegalArgumentException("Middleware id already registered: " + middleware.id());
        }
        this.middlewares.add(middleware);
    }

    private void requireUnsealed() {
        if (this.sealed) {
            throw new IllegalStateException("Middleware container has already been sealed");
        }
    }

    @Override
    public void seal() {
        if (this.sealed) {
            return;
        }
        this.sealed = true;
        String[] allMentionedMiddlewareIds = (String[])this.middlewares.stream().flatMap(middleware -> Stream.concat(Stream.of(middleware.id()), Stream.concat(middleware.mustComeAfter().stream(), middleware.mustComeBefore().stream()))).distinct().toArray(String[]::new);
        HashMap<String, Integer> indecesByMiddlewareId = new HashMap<String, Integer>();
        for (int i = 0; i < allMentionedMiddlewareIds.length; ++i) {
            indecesByMiddlewareId.put(allMentionedMiddlewareIds[i], i);
        }
        AcyclicGraphSorter sorter = new AcyclicGraphSorter(allMentionedMiddlewareIds.length);
        for (Middleware<M> middleware2 : this.middlewares) {
            Integer currentIndex = (Integer)indecesByMiddlewareId.get(middleware2.id());
            middleware2.mustComeAfter().stream().map(indecesByMiddlewareId::get).forEach(beforeIndex -> sorter.addEdge((int)beforeIndex, currentIndex));
            middleware2.mustComeBefore().stream().map(indecesByMiddlewareId::get).forEach(afterIndex -> sorter.addEdge(currentIndex, (int)afterIndex));
        }
        Map middlewaresById = this.middlewares.stream().collect(Collectors.toMap(Middleware::id, Function.identity()));
        try {
            int[] sortedIndeces = sorter.sort();
            this.middlewares = Arrays.stream(sortedIndeces).mapToObj(index -> allMentionedMiddlewareIds[index]).map(middlewaresById::get).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (AcyclicGraphSorter.GraphCycleException e) {
            StringBuilder messageBuilder = new StringBuilder("Found cycle in middleware dependencies: ");
            e.cycleIndeces().forEach(index -> messageBuilder.append(allMentionedMiddlewareIds[index]).append(" -> "));
            messageBuilder.append(allMentionedMiddlewareIds[e.cycleIndeces().iterator().next()]);
            throw new IllegalStateException(messageBuilder.toString(), e);
        }
    }

    @Override
    public M process(M inner) {
        if (!this.sealed) {
            throw new IllegalStateException("Middleware container has not been sealed");
        }
        M combined = inner;
        for (int i = this.middlewares.size() - 1; i >= 0; --i) {
            Middleware<M> middleware = this.middlewares.get(i);
            combined = middleware.process(combined);
        }
        return combined;
    }

    @Override
    @Generated
    public List<Middleware<M>> middlewares() {
        return this.middlewares;
    }
}

