/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.pather.api;

import de.siphalor.tweed5.dataapi.api.TweedDataReadException;
import de.siphalor.tweed5.dataapi.api.TweedDataReader;
import de.siphalor.tweed5.dataapi.api.TweedDataToken;
import de.siphalor.tweed5.defaultextensions.pather.api.PathTracking;
import java.util.ArrayDeque;
import lombok.Generated;

public class PathTrackingDataReader
implements TweedDataReader {
    private final TweedDataReader delegate;
    private final PathTracking pathTracking;
    private final ArrayDeque<Context> contextStack = new ArrayDeque(50);
    private final ArrayDeque<Integer> listIndexStack = new ArrayDeque(50);

    public TweedDataToken peekToken() throws TweedDataReadException {
        return this.delegate.peekToken();
    }

    public TweedDataToken readToken() throws TweedDataReadException {
        TweedDataToken token = this.delegate.readToken();
        if (token.isListValue() && this.contextStack.peek() == Context.LIST) {
            int index = this.listIndexStack.pop() + 1;
            if (index != 0) {
                this.pathTracking.popPathPart();
            }
            this.pathTracking.pushPathPart(Integer.toString(index));
            this.listIndexStack.push(index);
        }
        if (token.isListStart()) {
            this.contextStack.push(Context.LIST);
            this.listIndexStack.push(-1);
        } else if (token.isListEnd()) {
            this.contextStack.pop();
            int lastIndex = this.listIndexStack.pop();
            if (lastIndex >= 0) {
                this.pathTracking.popPathPart();
            }
        } else if (token.isMapStart()) {
            this.contextStack.push(Context.MAP);
            this.pathTracking.pushPathPart("$");
        } else if (token.isMapEntryKey()) {
            this.pathTracking.popPathPart();
            this.pathTracking.pushPathPart(token.readAsString());
        } else if (token.isMapEnd()) {
            this.pathTracking.popPathPart();
            this.contextStack.pop();
        }
        return token;
    }

    public void close() throws Exception {
        this.delegate.close();
    }

    @Generated
    public PathTrackingDataReader(TweedDataReader delegate, PathTracking pathTracking) {
        this.delegate = delegate;
        this.pathTracking = pathTracking;
    }

    private static enum Context {
        LIST,
        MAP;

    }
}

