/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.defaultextensions.validationfallback.impl;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.extension.TweedExtensionSetupContext;
import de.siphalor.tweed5.core.api.middleware.Middleware;
import de.siphalor.tweed5.defaultextensions.presets.api.PresetsExtension;
import de.siphalor.tweed5.defaultextensions.validation.api.ConfigEntryValidator;
import de.siphalor.tweed5.defaultextensions.validation.api.ValidationProvidingExtension;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssue;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationIssueLevel;
import de.siphalor.tweed5.defaultextensions.validation.api.result.ValidationResult;
import de.siphalor.tweed5.defaultextensions.validationfallback.api.ValidationFallbackExtension;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class ValidationFallbackExtensionImpl
implements ValidationFallbackExtension,
ValidationProvidingExtension {
    private final ConfigContainer<?> configContainer;
    private final PatchworkPartAccess<Boolean> hasToStringAccess;
    private @Nullable PresetsExtension presetsExtension;
    private String fallbackPresetName = "default";

    public ValidationFallbackExtensionImpl(TweedExtensionSetupContext context, ConfigContainer<?> configContainer) {
        this.configContainer = configContainer;
        this.hasToStringAccess = context.registerEntryExtensionData(Boolean.class);
        context.registerExtension(PresetsExtension.class);
    }

    private PresetsExtension getOrResolvePresetsExtension() {
        if (this.presetsExtension == null) {
            this.presetsExtension = (PresetsExtension)this.configContainer.extension(PresetsExtension.class).orElseThrow(() -> new IllegalStateException("No presets extension registered"));
        }
        return this.presetsExtension;
    }

    public void initEntry(ConfigEntry<?> configEntry) {
        configEntry.extensionsData().set(this.hasToStringAccess, (Object)this.hasCustomToString(configEntry.valueClass()));
    }

    private boolean hasCustomToString(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        try {
            return clazz.getMethod("toString", new Class[0]).getDeclaringClass() != Object.class;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public void fallbackToPreset(String presetName) {
        this.fallbackPresetName = presetName;
    }

    @Override
    public Middleware<ConfigEntryValidator> validationMiddleware() {
        return new ValidationFallbackMiddleware();
    }

    private class ValidationFallbackMiddleware
    implements Middleware<ConfigEntryValidator> {
        private ValidationFallbackMiddleware() {
        }

        public String id() {
            return "validation-fallback";
        }

        public Set<String> mustComeBefore() {
            return Collections.singleton("$default.start");
        }

        public Set<String> mustComeAfter() {
            return Collections.emptySet();
        }

        public ConfigEntryValidator process(final ConfigEntryValidator inner) {
            return new ConfigEntryValidator(){
                final /* synthetic */ ValidationFallbackMiddleware this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public <T> ValidationResult<T> validate(ConfigEntry<T> configEntry, T value) {
                    ValidationResult<T> result = inner.validate(configEntry, value);
                    if (!result.hasError()) {
                        return result;
                    }
                    PresetsExtension presetsExtension = this.this$1.ValidationFallbackExtensionImpl.this.getOrResolvePresetsExtension();
                    Object fallbackValue = presetsExtension.presetValue(configEntry, this.this$1.ValidationFallbackExtensionImpl.this.fallbackPresetName);
                    if (fallbackValue != null) {
                        if (configEntry.valueClass().isInstance(fallbackValue)) {
                            fallbackValue = configEntry.deepCopy(fallbackValue);
                        } else {
                            ArrayList<ValidationIssue> issues = new ArrayList<ValidationIssue>(result.issues());
                            issues.add(new ValidationIssue("Fallback value is not of correct class, expected " + configEntry.valueClass().getName() + ", but got " + fallbackValue.getClass().getName(), ValidationIssueLevel.ERROR));
                            return ValidationResult.withIssues(value, issues);
                        }
                    }
                    return ValidationResult.withIssues(fallbackValue, result.issues().stream().map(issue -> new ValidationIssue(issue.message(), issue.level() == ValidationIssueLevel.ERROR ? ValidationIssueLevel.WARN : issue.level())).collect(Collectors.toList()));
                }

                @Override
                public <T> String description(ConfigEntry<T> configEntry) {
                    if (Boolean.TRUE.equals(configEntry.extensionsData().get(this.this$1.ValidationFallbackExtensionImpl.this.hasToStringAccess))) {
                        T fallbackValue = this.this$1.ValidationFallbackExtensionImpl.this.getOrResolvePresetsExtension().presetValue(configEntry, this.this$1.ValidationFallbackExtensionImpl.this.fallbackPresetName);
                        return inner.description(configEntry) + "\n\nDefault/Fallback value: " + fallbackValue;
                    }
                    return inner.description(configEntry);
                }
            };
        }
    }
}

