/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.fabric.helper.api;

import com.google.gson.stream.JsonReader;
import de.siphalor.tweed5.commentloaderextension.api.CommentLoaderExtension;
import de.siphalor.tweed5.commentloaderextension.api.CommentPathProcessor;
import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.data.gson.GsonReader;
import de.siphalor.tweed5.dataapi.api.TweedDataReader;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.Log;
import de.siphalor.tweed5.shadowed.org.apache.commons.logging.LogFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class FabricConfigCommentLoader {
    @Generated
    private static final Log log = LogFactory.getLog(FabricConfigCommentLoader.class);
    private final ConfigContainer<?> configContainer;
    private final String modId;
    private final String prefix;
    private final @Nullable String suffix;

    public void loadCommentsFromLanguageFile(String languageCode) {
        CommentLoaderExtension commentLoaderExtension = (CommentLoaderExtension)this.configContainer.extension(CommentLoaderExtension.class).orElseThrow(() -> new IllegalStateException("CommentLoaderExtension not declared on config"));
        String langFilePath = "assets/" + this.modId + "/lang/" + languageCode + ".json";
        InputStream langInputStream = this.getClass().getClassLoader().getResourceAsStream(langFilePath);
        if (langInputStream == null) {
            log.warn((Object)("Failed to find language file " + langFilePath + " for loading config comments"));
            return;
        }
        try (GsonReader reader = new GsonReader(new JsonReader((Reader)new InputStreamReader(langInputStream)));){
            commentLoaderExtension.loadComments((TweedDataReader)reader, new CommentPathProcessor(){

                public CommentPathProcessor.MatchStatus matches(String path) {
                    if (!path.startsWith(FabricConfigCommentLoader.this.prefix)) {
                        return CommentPathProcessor.MatchStatus.NO;
                    }
                    if (path.length() == FabricConfigCommentLoader.this.prefix.length()) {
                        if (FabricConfigCommentLoader.this.suffix != null && !path.endsWith(FabricConfigCommentLoader.this.suffix)) {
                            return CommentPathProcessor.MatchStatus.NO;
                        }
                        return CommentPathProcessor.MatchStatus.YES;
                    }
                    if (path.charAt(FabricConfigCommentLoader.this.prefix.length()) != '.') {
                        return CommentPathProcessor.MatchStatus.NO;
                    }
                    if (FabricConfigCommentLoader.this.suffix != null && !path.endsWith(FabricConfigCommentLoader.this.suffix)) {
                        return CommentPathProcessor.MatchStatus.MAYBE_DEEPER;
                    }
                    return CommentPathProcessor.MatchStatus.YES;
                }

                public String process(String path) {
                    if (path.equals(FabricConfigCommentLoader.this.prefix)) {
                        return "";
                    }
                    path = path.substring(FabricConfigCommentLoader.this.prefix.length() + 1);
                    if (FabricConfigCommentLoader.this.suffix != null) {
                        path = path.substring(0, path.length() - FabricConfigCommentLoader.this.suffix.length());
                    }
                    return path;
                }
            });
        }
        catch (Exception e) {
            log.warn((Object)"Failed to load comments from language file", (Throwable)e);
        }
    }

    @Generated
    FabricConfigCommentLoader(ConfigContainer<?> configContainer, String modId, String prefix, @Nullable String suffix) {
        this.configContainer = configContainer;
        this.modId = modId;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Generated
    public static FabricConfigCommentLoaderBuilder builder() {
        return new FabricConfigCommentLoaderBuilder();
    }

    @Generated
    public static class FabricConfigCommentLoaderBuilder {
        @Generated
        private ConfigContainer<?> configContainer;
        @Generated
        private String modId;
        @Generated
        private String prefix;
        @Generated
        private String suffix;

        @Generated
        FabricConfigCommentLoaderBuilder() {
        }

        @Generated
        public FabricConfigCommentLoaderBuilder configContainer(ConfigContainer<?> configContainer) {
            this.configContainer = configContainer;
            return this;
        }

        @Generated
        public FabricConfigCommentLoaderBuilder modId(String modId) {
            this.modId = modId;
            return this;
        }

        @Generated
        public FabricConfigCommentLoaderBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Generated
        public FabricConfigCommentLoaderBuilder suffix(@Nullable String suffix) {
            this.suffix = suffix;
            return this;
        }

        @Generated
        public FabricConfigCommentLoader build() {
            return new FabricConfigCommentLoader(this.configContainer, this.modId, this.prefix, this.suffix);
        }

        @Generated
        public String toString() {
            return "FabricConfigCommentLoader.FabricConfigCommentLoaderBuilder(configContainer=" + this.configContainer + ", modId=" + this.modId + ", prefix=" + this.prefix + ", suffix=" + this.suffix + ")";
        }
    }
}

