/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.fabric.helper.api;

import de.siphalor.tweed5.core.api.container.ConfigContainer;
import de.siphalor.tweed5.core.api.container.ConfigContainerSetupPhase;
import de.siphalor.tweed5.data.extension.api.ReadWriteExtension;
import de.siphalor.tweed5.dataapi.api.TweedDataReader;
import de.siphalor.tweed5.dataapi.api.TweedDataVisitor;
import de.siphalor.tweed5.dataapi.api.TweedDataWriter;
import de.siphalor.tweed5.dataapi.api.TweedSerde;
import de.siphalor.tweed5.defaultextensions.patch.api.PatchExtension;
import de.siphalor.tweed5.defaultextensions.patch.api.PatchInfo;
import de.siphalor.tweed5.defaultextensions.presets.api.PresetsExtension;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;

public class FabricConfigContainerHelper<T> {
    @Generated
    private static final Log log = LogFactory.getLog(FabricConfigContainerHelper.class);
    private final ConfigContainer<T> configContainer;
    private final ReadWriteExtension readWriteExtension;
    private final @Nullable PatchExtension patchExtension;
    private final @Nullable PresetsExtension presetsExtension;
    private final TweedSerde serde;
    private final String modId;
    private @Nullable Path tempConfigDirectory;

    public static <T> FabricConfigContainerHelper<T> create(ConfigContainer<T> configContainer, TweedSerde serde, String modId) {
        if (configContainer.setupPhase() != ConfigContainerSetupPhase.INITIALIZED) {
            throw new IllegalStateException("Config container must be fully initialized before creating helper. Usually you're just missing a call to initialize()");
        }
        return new FabricConfigContainerHelper<T>(configContainer, serde, modId);
    }

    private FabricConfigContainerHelper(ConfigContainer<T> configContainer, TweedSerde serde, String modId) {
        this.configContainer = configContainer;
        this.readWriteExtension = (ReadWriteExtension)configContainer.extension(ReadWriteExtension.class).orElseThrow(() -> new IllegalStateException("ReadWriteExtension not declared in config container"));
        this.patchExtension = configContainer.extension(PatchExtension.class).orElse(null);
        this.presetsExtension = configContainer.extension(PresetsExtension.class).orElse(null);
        this.serde = serde;
        this.modId = modId;
    }

    public T loadAndUpdateInConfigDirectory() {
        T defaultPresetValue = this.getDefaultPresetValue();
        return (T)this.loadAndUpdateInConfigDirectory(() -> this.configContainer.rootEntry().deepCopy(defaultPresetValue));
    }

    public T loadAndUpdateInConfigDirectory(Supplier<T> defaultValueSupplier) {
        T configValue = this.readConfigInConfigDirectory(defaultValueSupplier);
        this.writeConfigInConfigDirectory(configValue);
        return configValue;
    }

    public void readPartialConfigInConfigDirectory(T value, Consumer<Patchwork> readContextCustomizer) {
        if (this.patchExtension == null) {
            throw new IllegalStateException("PatchExtension must be declared in config container for partially loading config");
        }
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            return;
        }
        try (TweedDataReader reader = this.serde.createReader((InputStream)new FileInputStream(configFile));){
            Patchwork contextExtensionsData = this.readWriteExtension.createReadWriteContextExtensionsData();
            readContextCustomizer.accept(contextExtensionsData);
            PatchInfo patchInfo = this.patchExtension.collectPatchInfo(contextExtensionsData);
            Object readValue = this.readWriteExtension.read(reader, this.configContainer().rootEntry(), contextExtensionsData);
            this.patchExtension.patch(this.configContainer.rootEntry(), value, readValue, patchInfo);
        }
        catch (Exception e) {
            log.error((Object)("Failed loading config file " + configFile.getAbsolutePath()), (Throwable)e);
        }
    }

    public T readConfigInConfigDirectory() {
        T defaultPresetValue = this.getDefaultPresetValue();
        return (T)this.readConfigInConfigDirectory(() -> this.configContainer.rootEntry().deepCopy(defaultPresetValue));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T readConfigInConfigDirectory(Supplier<T> defaultValueSupplier) {
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            return defaultValueSupplier.get();
        }
        try (TweedDataReader reader = this.serde.createReader((InputStream)new FileInputStream(configFile));){
            Patchwork contextExtensionsData = this.readWriteExtension.createReadWriteContextExtensionsData();
            Object object = this.readWriteExtension.read(reader, this.configContainer.rootEntry(), contextExtensionsData);
            return (T)object;
        }
        catch (Exception e) {
            log.error((Object)("Failed loading config file " + configFile.getAbsolutePath()), (Throwable)e);
            return defaultValueSupplier.get();
        }
    }

    public void writeConfigInConfigDirectory(T configValue) {
        File configFile = this.getConfigFile();
        Path tempConfigDirectory = this.getOrCreateTempConfigDirectory();
        File tempConfigFile = tempConfigDirectory.resolve(this.getConfigFileName()).toFile();
        try (TweedDataWriter writer = this.serde.createWriter((OutputStream)new FileOutputStream(tempConfigFile));){
            Patchwork contextExtensionsData = this.readWriteExtension.createReadWriteContextExtensionsData();
            this.readWriteExtension.write((TweedDataVisitor)writer, configValue, this.configContainer.rootEntry(), contextExtensionsData);
        }
        catch (Exception e) {
            log.error((Object)("Failed to write config file " + tempConfigFile.getAbsolutePath()), (Throwable)e);
            return;
        }
        try {
            if (configFile.exists() && !configFile.delete()) {
                throw new IOException("Failed to overwrite old config file " + configFile.getAbsolutePath());
            }
            Files.move(tempConfigFile.toPath(), configFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            log.error((Object)("Failed to move temporary config file " + tempConfigFile.getAbsolutePath() + " to " + configFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private File getConfigFile() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        configDir.toFile().mkdirs();
        return configDir.resolve(this.getConfigFileName()).toFile();
    }

    private String getConfigFileName() {
        return this.modId + this.serde.getPreferredFileExtension();
    }

    private Path getOrCreateTempConfigDirectory() {
        if (this.tempConfigDirectory == null) {
            try {
                this.tempConfigDirectory = Files.createTempDirectory("tweed5-config", new FileAttribute[0]);
                this.tempConfigDirectory.toFile().deleteOnExit();
                return this.tempConfigDirectory;
            }
            catch (IOException e) {
                log.warn((Object)"Failed to create temporary config directory, using game directory instead");
                this.tempConfigDirectory = FabricLoader.getInstance().getGameDir().resolve(".tweed5-tmp/").resolve(this.modId);
                this.tempConfigDirectory.toFile().mkdirs();
            }
        }
        return this.tempConfigDirectory;
    }

    private T getDefaultPresetValue() {
        if (this.presetsExtension == null) {
            throw new IllegalStateException("No presets extension registered, either register such extension or provide a default value manually");
        }
        return (T)this.presetsExtension.presetValue(this.configContainer.rootEntry(), "default");
    }

    @Generated
    public ConfigContainer<T> configContainer() {
        return this.configContainer;
    }

    @Generated
    public String modId() {
        return this.modId;
    }
}

