/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.data.extension.api;

import de.siphalor.tweed5.core.api.entry.ConfigEntry;
import de.siphalor.tweed5.core.api.extension.TweedExtension;
import de.siphalor.tweed5.data.extension.api.TweedEntryReadException;
import de.siphalor.tweed5.data.extension.api.TweedEntryReader;
import de.siphalor.tweed5.data.extension.api.TweedEntryWriteException;
import de.siphalor.tweed5.data.extension.api.TweedEntryWriter;
import de.siphalor.tweed5.data.extension.api.readwrite.TweedEntryReaderWriter;
import de.siphalor.tweed5.data.extension.impl.ReadWriteExtensionImpl;
import de.siphalor.tweed5.dataapi.api.TweedDataReader;
import de.siphalor.tweed5.dataapi.api.TweedDataVisitor;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public interface ReadWriteExtension
extends TweedExtension {
    public static final Class<? extends ReadWriteExtension> DEFAULT = ReadWriteExtensionImpl.class;
    public static final String EXTENSION_ID = "read-write";

    default public String getId() {
        return EXTENSION_ID;
    }

    public static <T> Consumer<ConfigEntry<T>> entryReaderWriter(TweedEntryReaderWriter<T, ? extends ConfigEntry<T>> entryReaderWriter) {
        return ReadWriteExtension.entryReaderWriter(entryReaderWriter, entryReaderWriter);
    }

    public static <T> Consumer<ConfigEntry<T>> entryReaderWriter(TweedEntryReader<T, ? extends ConfigEntry<T>> entryReader, TweedEntryWriter<T, ? extends ConfigEntry<T>> entryWriter) {
        return entry -> {
            ReadWriteExtension extension = (ReadWriteExtension)entry.container().extension(ReadWriteExtension.class).orElseThrow(() -> new IllegalStateException("No ReadWriteExtension present"));
            extension.setEntryReader((ConfigEntry)entry, entryReader);
            extension.setEntryWriter((ConfigEntry)entry, entryWriter);
        };
    }

    public static <T> Consumer<ConfigEntry<T>> entryReader(TweedEntryReader<T, ? extends ConfigEntry<T>> entryReader) {
        return entry -> {
            ReadWriteExtension extension = (ReadWriteExtension)entry.container().extension(ReadWriteExtension.class).orElseThrow(() -> new IllegalStateException("No ReadWriteExtension present"));
            extension.setEntryReader((ConfigEntry)entry, entryReader);
        };
    }

    public static <T> Consumer<ConfigEntry<T>> entryWriter(TweedEntryWriter<T, ? extends ConfigEntry<T>> entryWriter) {
        return entry -> {
            ReadWriteExtension extension = (ReadWriteExtension)entry.container().extension(ReadWriteExtension.class).orElseThrow(() -> new IllegalStateException("No ReadWriteExtension present"));
            extension.setEntryWriter((ConfigEntry)entry, entryWriter);
        };
    }

    public static <T> Function<ConfigEntry<T>, T> read(TweedDataReader reader) {
        return ReadWriteExtension.read(reader, null);
    }

    public static <T> Function<ConfigEntry<T>, T> read(TweedDataReader reader, @Nullable Consumer<Patchwork> contextExtensionsDataCustomizer) {
        return entry -> {
            try {
                ReadWriteExtension extension = (ReadWriteExtension)entry.container().extension(ReadWriteExtension.class).orElseThrow(() -> new IllegalStateException("No ReadWriteExtension present"));
                Patchwork contextExtensionsData = extension.createReadWriteContextExtensionsData();
                if (contextExtensionsDataCustomizer != null) {
                    contextExtensionsDataCustomizer.accept(contextExtensionsData);
                }
                return extension.read(reader, (ConfigEntry)entry, contextExtensionsData);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> Consumer<ConfigEntry<T>> write(TweedDataVisitor writer, T value) {
        return ReadWriteExtension.write(writer, value, null);
    }

    public static <T> Consumer<ConfigEntry<T>> write(TweedDataVisitor writer, T value, @Nullable Consumer<Patchwork> contextExtensionsDataCustomizer) {
        return entry -> {
            try {
                ReadWriteExtension extension = (ReadWriteExtension)entry.container().extension(ReadWriteExtension.class).orElseThrow(() -> new IllegalStateException("No ReadWriteExtension present"));
                Patchwork contextExtensionsData = extension.createReadWriteContextExtensionsData();
                if (contextExtensionsDataCustomizer != null) {
                    contextExtensionsDataCustomizer.accept(contextExtensionsData);
                }
                extension.write(writer, value, (ConfigEntry)entry, contextExtensionsData);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public <T, C extends ConfigEntry<T>> @Nullable TweedEntryReader<T, C> getDefinedEntryReader(ConfigEntry<T> var1);

    public <T, C extends ConfigEntry<T>> @Nullable TweedEntryWriter<T, C> getDefinedEntryWriter(ConfigEntry<T> var1);

    public <T, C extends ConfigEntry<T>> void setEntryReaderWriter(ConfigEntry<T> var1, TweedEntryReader<T, C> var2, TweedEntryWriter<T, C> var3);

    public <T, C extends ConfigEntry<T>> void setEntryReader(ConfigEntry<T> var1, TweedEntryReader<T, C> var2);

    public <T, C extends ConfigEntry<T>> void setEntryWriter(ConfigEntry<T> var1, TweedEntryWriter<T, C> var2);

    public Patchwork createReadWriteContextExtensionsData();

    public <T> T read(TweedDataReader var1, ConfigEntry<T> var2, Patchwork var3) throws TweedEntryReadException;

    public <T> void write(TweedDataVisitor var1, T var2, ConfigEntry<T> var3, Patchwork var4) throws TweedEntryWriteException;

    public <T, C extends ConfigEntry<T>> TweedEntryReader<T, C> getReaderChain(C var1);

    public <T, C extends ConfigEntry<T>> TweedEntryWriter<T, C> getWriterChain(C var1);
}

