/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.data.gson;

import com.google.gson.stream.JsonReader;
import de.siphalor.tweed5.dataapi.api.TweedDataReadException;
import de.siphalor.tweed5.dataapi.api.TweedDataReader;
import de.siphalor.tweed5.dataapi.api.TweedDataToken;
import de.siphalor.tweed5.dataapi.api.TweedDataTokens;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jspecify.annotations.Nullable;

public class GsonReader
implements TweedDataReader {
    private final JsonReader reader;
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private @Nullable TweedDataToken peekedToken;

    public GsonReader(JsonReader reader) {
        this.reader = reader;
        this.contextStack.push(Context.VALUE);
    }

    public TweedDataToken peekToken() throws TweedDataReadException {
        if (this.peekedToken == null) {
            this.peekedToken = this.nextToken();
        }
        return this.peekedToken;
    }

    public TweedDataToken readToken() throws TweedDataReadException {
        if (this.peekedToken != null) {
            TweedDataToken token = this.peekedToken;
            this.peekedToken = null;
            return token;
        }
        return this.nextToken();
    }

    private TweedDataToken nextToken() throws TweedDataReadException {
        try {
            switch (this.reader.peek()) {
                case BEGIN_ARRAY: {
                    this.reader.beginArray();
                    TweedDataToken token = this.wrapToken(TweedDataTokens.getListStart());
                    this.contextStack.push(Context.LIST);
                    return token;
                }
                case END_ARRAY: {
                    this.reader.endArray();
                    this.popContext(Context.LIST);
                    TweedDataToken token = this.wrapToken(TweedDataTokens.getListEnd());
                    this.afterValueRead();
                    return token;
                }
                case BEGIN_OBJECT: {
                    this.reader.beginObject();
                    TweedDataToken token = this.wrapToken(TweedDataTokens.getMapStart());
                    this.contextStack.push(Context.MAP);
                    return token;
                }
                case END_OBJECT: {
                    this.reader.endObject();
                    this.popContext(Context.MAP);
                    TweedDataToken token = this.wrapToken(TweedDataTokens.getMapEnd());
                    this.afterValueRead();
                    return token;
                }
                case NAME: {
                    this.contextStack.push(Context.MAP_ENTRY_VALUE);
                    return TweedDataTokens.asMapEntryKey((TweedDataToken)this.createStringToken(this.reader.nextName()));
                }
                case NULL: {
                    this.reader.nextNull();
                    TweedDataToken token = this.wrapToken(TweedDataTokens.getNull());
                    this.afterValueRead();
                    return token;
                }
                case BOOLEAN: {
                    final boolean value = this.reader.nextBoolean();
                    TweedDataToken token = this.wrapToken(new TweedDataToken(){
                        final /* synthetic */ GsonReader this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public boolean canReadAsBoolean() {
                            return true;
                        }

                        public boolean readAsBoolean() throws TweedDataReadException {
                            return value;
                        }
                    });
                    this.afterValueRead();
                    return token;
                }
                case NUMBER: {
                    TweedDataToken token;
                    final Long longValue = this.tryReadLong();
                    if (longValue != null) {
                        token = this.wrapToken(new TweedDataToken(){
                            final /* synthetic */ GsonReader this$0;
                            {
                                this.this$0 = this$0;
                            }

                            public boolean canReadAsByte() {
                                return longValue >= -128L && longValue <= 127L;
                            }

                            public byte readAsByte() {
                                return longValue.byteValue();
                            }

                            public boolean canReadAsShort() {
                                return longValue >= -32768L && longValue <= 32767L;
                            }

                            public short readAsShort() {
                                return longValue.shortValue();
                            }

                            public boolean canReadAsInt() {
                                return longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE;
                            }

                            public int readAsInt() {
                                return longValue.intValue();
                            }

                            public boolean canReadAsLong() {
                                return true;
                            }

                            public long readAsLong() {
                                return longValue;
                            }

                            public boolean canReadAsFloat() {
                                return true;
                            }

                            public float readAsFloat() {
                                return longValue.floatValue();
                            }

                            public boolean canReadAsDouble() {
                                return true;
                            }

                            public double readAsDouble() {
                                return longValue.doubleValue();
                            }
                        });
                    } else {
                        final double doubleValue = this.reader.nextDouble();
                        token = this.wrapToken(new TweedDataToken(){
                            final /* synthetic */ GsonReader this$0;
                            {
                                this.this$0 = this$0;
                            }

                            public boolean canReadAsFloat() {
                                return true;
                            }

                            public float readAsFloat() {
                                return (float)doubleValue;
                            }

                            public boolean canReadAsDouble() {
                                return true;
                            }

                            public double readAsDouble() {
                                return doubleValue;
                            }
                        });
                    }
                    this.afterValueRead();
                    return token;
                }
                case STRING: {
                    TweedDataToken token = this.wrapToken(this.createStringToken(this.reader.nextString()));
                    this.afterValueRead();
                    return token;
                }
            }
            throw TweedDataReadException.builder().message("Encountered unexpected " + this.peekedToken + " token at " + this.reader.getPath()).build();
        }
        catch (IOException e) {
            throw TweedDataReadException.builder().message("Error reading data using gson at " + this.reader.getPath()).cause((Throwable)e).build();
        }
    }

    private @Nullable Long tryReadLong() throws IOException {
        try {
            return this.reader.nextLong();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private TweedDataToken wrapToken(TweedDataToken token) throws TweedDataReadException {
        switch (this.peekContext().ordinal()) {
            case 3: {
                return TweedDataTokens.asMapEntryValue((TweedDataToken)token);
            }
            case 1: {
                return TweedDataTokens.asListValue((TweedDataToken)token);
            }
        }
        return token;
    }

    private void afterValueRead() throws TweedDataReadException {
        Context context = this.peekContext();
        switch (context.ordinal()) {
            case 0: 
            case 3: {
                this.popContext(context);
            }
        }
    }

    private Context peekContext() throws TweedDataReadException {
        Context context = this.contextStack.peek();
        if (context == null) {
            throw TweedDataReadException.builder().message("Tried to read context but currently not in any context").build();
        }
        return context;
    }

    private void popContext(Context expectedContext) throws TweedDataReadException {
        Context context = this.contextStack.pop();
        if (context != expectedContext) {
            throw TweedDataReadException.builder().message("Unexpected context " + (Object)((Object)context) + " when popping " + (Object)((Object)expectedContext)).build();
        }
    }

    private TweedDataToken createStringToken(final String value) {
        return new TweedDataToken(){
            final /* synthetic */ GsonReader this$0;
            {
                this.this$0 = this$0;
            }

            public boolean canReadAsString() {
                return true;
            }

            public String readAsString() {
                return value;
            }
        };
    }

    public void close() throws Exception {
        this.reader.close();
    }

    private static enum Context {
        VALUE,
        LIST,
        MAP,
        MAP_ENTRY_VALUE;

    }
}

