package de.siphalor.tweed5.data.hjson;

import lombok.*;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class HjsonReadPosition {
	private int line = 1;
	private int index;

	public void nextCodepoint() {
		index++;
	}

	public void nextLine() {
		line++;
		index = 0;
	}

	public HjsonReadPosition copy() {
		return new HjsonReadPosition(line, index);
	}

	@Override
	public String toString() {
		return line + ":" + index;
	}

	public HjsonReadPosition() {
	}

	public HjsonReadPosition(final int line, final int index) {
		this.line = line;
		this.index = index;
	}

	@Override
	public boolean equals(final Object o) {
		if (o == this) return true;
		if (!(o instanceof HjsonReadPosition)) return false;
		final HjsonReadPosition other = (HjsonReadPosition) o;
		if (!other.canEqual((Object) this)) return false;
		if (this.line() != other.line()) return false;
		if (this.index() != other.index()) return false;
		return true;
	}

	protected boolean canEqual(final Object other) {
		return other instanceof HjsonReadPosition;
	}

	@Override
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + this.line();
		result = result * PRIME + this.index();
		return result;
	}

	public int line() {
		return this.line;
	}

	public int index() {
		return this.index;
	}
}
