/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.data.hjson;

import de.siphalor.tweed5.data.hjson.HjsonLexerToken;
import de.siphalor.tweed5.data.hjson.HjsonReadPosition;
import de.siphalor.tweed5.dataapi.api.TweedDataReadException;
import java.io.IOException;
import java.io.Reader;
import java.util.PrimitiveIterator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class HjsonLexer
implements AutoCloseable {
    private static final int EMPTY_CODEPOINT = -2;
    private final Reader reader;
    private final HjsonReadPosition currentPos = new HjsonReadPosition();
    private int peekedCodePoint = -2;
    private int peeked2CodePoint = -2;

    public HjsonLexerToken nextGeneralToken() throws TweedDataReadException {
        this.chompInlineWhitespaceAndComments();
        int codePoint = this.eatCodePoint();
        HjsonLexerToken.Type terminalTokenType = this.getTerminalTokenType(codePoint);
        if (terminalTokenType != null) {
            return this.createTerminalToken(terminalTokenType);
        }
        HjsonLexerToken token = this.tryReadQuotedString(codePoint);
        if (token != null) {
            return token;
        }
        return this.readQuotelessLiteral(codePoint);
    }

    public HjsonLexerToken nextInnerObjectToken() throws TweedDataReadException {
        this.chompInlineWhitespaceAndComments();
        int codePoint = this.eatCodePoint();
        HjsonLexerToken.Type terminalTokenType = this.getTerminalTokenType(codePoint);
        if (terminalTokenType != null) {
            return this.createTerminalToken(terminalTokenType);
        }
        if (codePoint == 34) {
            return this.readJsonQuotedString(codePoint);
        }
        if (codePoint == 39) {
            return this.readJsonQuotedString(codePoint);
        }
        if (codePoint < 33) {
            throw TweedDataReadException.builder().message("Illegal character \"" + String.copyValueOf(Character.toChars(codePoint)) + "\"").build();
        }
        return this.readQuotelessMemberName(codePoint);
    }

    private @Nullable HjsonLexerToken.Type getTerminalTokenType(int codePoint) {
        switch (codePoint) {
            case -1: {
                return HjsonLexerToken.Type.EOF;
            }
            case 91: {
                return HjsonLexerToken.Type.BRACKET_OPEN;
            }
            case 93: {
                return HjsonLexerToken.Type.BRACKET_CLOSE;
            }
            case 123: {
                return HjsonLexerToken.Type.BRACE_OPEN;
            }
            case 125: {
                return HjsonLexerToken.Type.BRACE_CLOSE;
            }
            case 58: {
                return HjsonLexerToken.Type.COLON;
            }
            case 44: {
                return HjsonLexerToken.Type.COMMA;
            }
            case 10: {
                return HjsonLexerToken.Type.LINE_FEED;
            }
        }
        return null;
    }

    private HjsonLexerToken createTerminalToken(HjsonLexerToken.Type tokenType) {
        HjsonReadPosition position = this.currentPos.copy();
        return new HjsonLexerToken(tokenType, position, position, null);
    }

    private @Nullable HjsonLexerToken tryReadQuotedString(int codePoint) throws TweedDataReadException {
        if (codePoint == 34) {
            return this.readJsonQuotedString(34);
        }
        if (codePoint == 39) {
            int peek = this.peekCodePoint();
            if (peek == 39) {
                int peek2 = this.peek2CodePoint();
                if (peek2 == 39) {
                    return this.readMultilineString();
                }
                HjsonReadPosition beginPos = this.currentPos.copy();
                this.eatCodePoint();
                return new HjsonLexerToken(HjsonLexerToken.Type.JSON_STRING, beginPos, this.currentPos.copy(), "''");
            }
            return this.readJsonQuotedString(39);
        }
        return null;
    }

    private HjsonLexerToken readJsonQuotedString(int quoteCodePoint) throws TweedDataReadException {
        HjsonReadPosition beginPos = this.currentPos.copy();
        StringBuilder tokenBuffer = new StringBuilder();
        tokenBuffer.appendCodePoint(quoteCodePoint);
        while (true) {
            int codePoint;
            if ((codePoint = this.eatCodePoint()) == -1) {
                throw TweedDataReadException.builder().message("Unterminated quoted string at " + this.currentPos + ", started at " + beginPos).build();
            }
            if (codePoint == quoteCodePoint) {
                tokenBuffer.appendCodePoint(codePoint);
                return new HjsonLexerToken(HjsonLexerToken.Type.JSON_STRING, beginPos, this.currentPos.copy(), tokenBuffer);
            }
            if (codePoint == 92) {
                tokenBuffer.appendCodePoint(codePoint);
                tokenBuffer.appendCodePoint(this.eatCodePoint());
                continue;
            }
            tokenBuffer.appendCodePoint(codePoint);
        }
    }

    private HjsonLexerToken readMultilineString() throws TweedDataReadException {
        int codePoint;
        HjsonReadPosition beginPos = this.currentPos.copy();
        int indentToChomp = beginPos.index() - 1;
        this.eatCodePoint();
        this.eatCodePoint();
        StringBuilder tokenBuffer = new StringBuilder();
        tokenBuffer.append("'''");
        boolean chompIndent = false;
        while (true) {
            if ((codePoint = this.eatCodePoint()) == -1) {
                throw TweedDataReadException.builder().message("Unexpected end of multiline string at " + this.currentPos + ", started at " + beginPos).build();
            }
            if (!this.isInlineWhitespace(codePoint)) break;
            tokenBuffer.appendCodePoint(codePoint);
        }
        if (codePoint == 10) {
            chompIndent = true;
            tokenBuffer.setLength(3);
        }
        while (true) {
            int codePoint2;
            if (chompIndent) {
                this.chompMultilineStringIndent(indentToChomp);
            } else {
                chompIndent = true;
            }
            int singleQuoteCount = 0;
            do {
                if ((codePoint2 = this.eatCodePoint()) == -1) {
                    throw TweedDataReadException.builder().message("Unexpected end of multiline string at " + this.currentPos + ", started at " + beginPos).build();
                }
                if (codePoint2 == 39) {
                    if (++singleQuoteCount == 3) {
                        char lastActualChar = tokenBuffer.charAt(tokenBuffer.length() - 3);
                        if (lastActualChar == '\n') {
                            tokenBuffer.delete(tokenBuffer.length() - 3, tokenBuffer.length() - 2);
                        }
                        tokenBuffer.append('\'');
                        return new HjsonLexerToken(HjsonLexerToken.Type.MULTILINE_STRING, beginPos, this.currentPos.copy(), tokenBuffer);
                    }
                } else {
                    singleQuoteCount = 0;
                }
                tokenBuffer.appendCodePoint(codePoint2);
            } while (codePoint2 != 10);
        }
    }

    private HjsonLexerToken readQuotelessMemberName(int codepoint) throws TweedDataReadException {
        int peek;
        HjsonReadPosition beginPos = this.currentPos.copy();
        StringBuilder tokenBuffer = new StringBuilder();
        tokenBuffer.appendCodePoint(codepoint);
        while ((peek = this.peekCodePoint()) != -1 && peek != 10 && !this.isPunctuator(peek)) {
            tokenBuffer.appendCodePoint(this.eatCodePoint());
        }
        return new HjsonLexerToken(HjsonLexerToken.Type.QUOTELESS_STRING, beginPos, this.currentPos.copy(), tokenBuffer);
    }

    private HjsonLexerToken readQuotelessLiteral(int codePoint) throws TweedDataReadException {
        if (codePoint == 110) {
            return this.readConstantOrQuotelessString(codePoint, "null", HjsonLexerToken.Type.NULL);
        }
        if (codePoint == 116) {
            return this.readConstantOrQuotelessString(codePoint, "true", HjsonLexerToken.Type.TRUE);
        }
        if (codePoint == 102) {
            return this.readConstantOrQuotelessString(codePoint, "false", HjsonLexerToken.Type.FALSE);
        }
        if (codePoint == 45 || this.isDigit(codePoint)) {
            return this.readNumberLiteralOrQuotelessString(codePoint);
        }
        StringBuilder tokenBuffer = new StringBuilder();
        tokenBuffer.appendCodePoint(codePoint);
        return this.readQuotelessStringToEndOfLine(this.currentPos.copy(), tokenBuffer);
    }

    private HjsonLexerToken readConstantOrQuotelessString(int firstCodePoint, String rest, HjsonLexerToken.Type tokenType) throws TweedDataReadException {
        HjsonReadPosition beginPos = this.currentPos.copy();
        StringBuilder tokenBuffer = new StringBuilder();
        tokenBuffer.appendCodePoint(firstCodePoint);
        PrimitiveIterator.OfInt restIterator = rest.codePoints().iterator();
        restIterator.nextInt();
        while (restIterator.hasNext()) {
            int codePoint = this.eatCodePoint();
            tokenBuffer.appendCodePoint(codePoint);
            if (codePoint == restIterator.nextInt()) continue;
            return this.readQuotelessStringToEndOfLine(beginPos, tokenBuffer);
        }
        return this.chompAfterLiteralOrReadToQuotelessString(tokenType, beginPos, tokenBuffer);
    }

    private HjsonLexerToken readNumberLiteralOrQuotelessString(int firstCodePoint) throws TweedDataReadException {
        HjsonReadPosition beginPos = this.currentPos.copy();
        StringBuilder tokenBuffer = new StringBuilder();
        tokenBuffer.appendCodePoint(firstCodePoint);
        int codePoint = firstCodePoint;
        if (codePoint == 45) {
            codePoint = this.eatCodePoint();
            if (codePoint == -1) {
                throw TweedDataReadException.builder().message("Unexpected end of number at " + this.currentPos).build();
            }
            tokenBuffer.appendCodePoint(codePoint);
        }
        if (!this.isDigit(codePoint)) {
            return this.readQuotelessStringToEndOfLine(beginPos, tokenBuffer);
        }
        boolean startsWithZero = codePoint == 48;
        codePoint = this.peekCodePoint();
        if (startsWithZero && this.isDigit(codePoint)) {
            return this.readQuotelessStringToEndOfLine(beginPos, tokenBuffer);
        }
        this.eatManyDigitsToBuffer(tokenBuffer);
        if (this.peekCodePoint() == 46) {
            tokenBuffer.appendCodePoint(this.eatCodePoint());
            codePoint = this.eatCodePoint();
            tokenBuffer.appendCodePoint(codePoint);
            if (!this.isDigit(codePoint)) {
                return this.readQuotelessStringToEndOfLine(beginPos, tokenBuffer);
            }
            this.eatManyDigitsToBuffer(tokenBuffer);
        }
        if (this.peekCodePoint() == 101 || this.peekCodePoint() == 69) {
            tokenBuffer.appendCodePoint(this.eatCodePoint());
            codePoint = this.eatCodePoint();
            tokenBuffer.appendCodePoint(codePoint);
            if (codePoint == 43 || codePoint == 45) {
                codePoint = this.eatCodePoint();
                tokenBuffer.appendCodePoint(codePoint);
            }
            if (!this.isDigit(codePoint)) {
                return this.readQuotelessStringToEndOfLine(beginPos, tokenBuffer);
            }
            this.eatManyDigitsToBuffer(tokenBuffer);
        }
        return this.chompAfterLiteralOrReadToQuotelessString(HjsonLexerToken.Type.NUMBER, beginPos, tokenBuffer);
    }

    private void eatManyDigitsToBuffer(StringBuilder buffer) throws TweedDataReadException {
        int codePoint;
        while (this.isDigit(codePoint = this.peekCodePoint())) {
            buffer.appendCodePoint(this.eatCodePoint());
        }
    }

    private HjsonLexerToken chompAfterLiteralOrReadToQuotelessString(HjsonLexerToken.Type tokenType, HjsonReadPosition beginPos, StringBuilder tokenBuffer) throws TweedDataReadException {
        int literalEndLength = tokenBuffer.length();
        HjsonReadPosition literalEndPos = this.currentPos.copy();
        while (true) {
            int peek;
            if ((peek = this.peekCodePoint()) == -1 || peek == 44 || peek == 10 || peek == 35 || peek == 93 || peek == 125) {
                tokenBuffer.setLength(literalEndLength);
                return new HjsonLexerToken(tokenType, beginPos, literalEndPos, tokenBuffer);
            }
            if (peek == 47) {
                int peek2 = this.peek2CodePoint();
                if (peek2 == 47 || peek2 == 42) {
                    tokenBuffer.setLength(literalEndLength);
                    return new HjsonLexerToken(tokenType, beginPos, literalEndPos, tokenBuffer);
                }
                return this.readQuotelessStringToEndOfLine(beginPos, tokenBuffer);
            }
            if (!this.isInlineWhitespace(peek)) {
                return this.readQuotelessStringToEndOfLine(beginPos, tokenBuffer);
            }
            tokenBuffer.appendCodePoint(this.eatCodePoint());
        }
    }

    private HjsonLexerToken readQuotelessStringToEndOfLine(HjsonReadPosition beginPos, StringBuilder tokenBuffer) throws TweedDataReadException {
        int lastNonWhitespaceLength = tokenBuffer.length();
        while (true) {
            int codePoint;
            if ((codePoint = this.peekCodePoint()) == -1 || codePoint == 10) {
                tokenBuffer.setLength(lastNonWhitespaceLength);
                return new HjsonLexerToken(HjsonLexerToken.Type.QUOTELESS_STRING, beginPos, this.currentPos.copy(), tokenBuffer);
            }
            tokenBuffer.appendCodePoint(this.eatCodePoint());
            if (this.isInlineWhitespace(codePoint)) continue;
            lastNonWhitespaceLength = tokenBuffer.length();
        }
    }

    private void chompMultilineStringIndent(int count) throws TweedDataReadException {
        for (int i = 0; i < count; ++i) {
            int codePoint = this.eatCodePoint();
            if (codePoint == -1) {
                return;
            }
            if (this.isInlineWhitespace(codePoint)) continue;
            throw TweedDataReadException.builder().message("Illegal indent at " + this.currentPos + ", expected " + count + " whitespace characters").build();
        }
    }

    private void chompInlineWhitespaceAndComments() throws TweedDataReadException {
        while (true) {
            int peek;
            if (this.isInlineWhitespace(peek = this.peekCodePoint())) {
                this.eatCodePoint();
                continue;
            }
            if (peek == 35) {
                this.eatCodePoint();
                this.chompToEndOfLine();
                continue;
            }
            if (peek != 47) break;
            int peek2 = this.peek2CodePoint();
            if (peek2 == 47) {
                this.eatCodePoint();
                this.eatCodePoint();
                this.chompToEndOfLine();
                continue;
            }
            if (peek2 != 42) continue;
            this.eatCodePoint();
            this.eatCodePoint();
            this.chompToEndOfBlockComment();
        }
    }

    private void chompToEndOfLine() throws TweedDataReadException {
        int codePoint;
        while ((codePoint = this.eatCodePoint()) != -1 && codePoint != 10) {
        }
    }

    private void chompToEndOfBlockComment() throws TweedDataReadException {
        boolean lastWasAsterisk = false;
        while (true) {
            int codePoint;
            if ((codePoint = this.eatCodePoint()) == -1) {
                throw TweedDataReadException.builder().message("Unterminated block comment at end of file " + this.currentPos).build();
            }
            if (codePoint == 42) {
                lastWasAsterisk = true;
                continue;
            }
            if (lastWasAsterisk && codePoint == 47) break;
            lastWasAsterisk = false;
        }
    }

    private boolean isPunctuator(int codePoint) {
        return codePoint == 44 || codePoint == 58 || codePoint == 91 || codePoint == 93 || codePoint == 123 || codePoint == 125;
    }

    private boolean isDigit(int codePoint) {
        return codePoint >= 48 && codePoint <= 57;
    }

    private boolean isInlineWhitespace(int codePoint) {
        return codePoint == 32 || codePoint == 9 || codePoint == 13;
    }

    private int peek2CodePoint() throws TweedDataReadException {
        if (this.peeked2CodePoint == -2) {
            if (this.peekedCodePoint == -2) {
                this.peekedCodePoint = this.readCodePoint();
            }
            this.peeked2CodePoint = this.readCodePoint();
        }
        return this.peeked2CodePoint;
    }

    private int peekCodePoint() throws TweedDataReadException {
        if (this.peekedCodePoint == -2) {
            this.peekedCodePoint = this.readCodePoint();
        }
        return this.peekedCodePoint;
    }

    private int eatCodePoint() throws TweedDataReadException {
        int codePoint;
        if (this.peekedCodePoint != -2) {
            codePoint = this.peekedCodePoint;
            this.peekedCodePoint = this.peeked2CodePoint;
            this.peeked2CodePoint = -2;
        } else {
            codePoint = this.readCodePoint();
        }
        if (codePoint == 10) {
            this.currentPos.nextLine();
        } else {
            this.currentPos.nextCodepoint();
        }
        return codePoint;
    }

    private int readCodePoint() throws TweedDataReadException {
        try {
            return this.reader.read();
        }
        catch (IOException e) {
            throw TweedDataReadException.builder().message("Failed to read character from input at " + this.currentPos).cause((Throwable)e).build();
        }
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }

    @Generated
    public HjsonLexer(Reader reader) {
        this.reader = reader;
    }
}

