/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.typeutils.api.annotations;

import de.siphalor.tweed5.typeutils.api.annotations.AnnotationRepeatType;
import de.siphalor.tweed5.typeutils.api.type.TypeAnnotationLayer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public class LayeredTypeAnnotations
implements AnnotatedElement {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final List<Layer> layers = new ArrayList<Layer>();

    public static LayeredTypeAnnotations of(TypeAnnotationLayer layer, AnnotatedElement annotatedElement) {
        LayeredTypeAnnotations annotations = new LayeredTypeAnnotations();
        annotations.layers.add(new Layer(layer, annotatedElement));
        return annotations;
    }

    public void appendLayerFrom(TypeAnnotationLayer layer, AnnotatedElement annotatedElement) {
        int i;
        for (i = 0; i < this.layers.size() && layer.compareTo(this.layers.get(i).layer()) <= 0; ++i) {
        }
        this.layers.add(i, new Layer(layer, annotatedElement));
    }

    public void prependLayerFrom(TypeAnnotationLayer layer, AnnotatedElement annotatedElement) {
        int i;
        for (i = 0; i < this.layers.size() && layer.compareTo(this.layers.get(i).layer()) < 0; ++i) {
        }
        this.layers.add(i, new Layer(layer, annotatedElement));
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (this.layers.isEmpty()) {
            return null;
        }
        if (this.layers.size() == 1) {
            return this.layers.get(0).annotatedElement.getAnnotation(annotationClass);
        }
        Class<? extends Annotation> altAnnotationClass = AnnotationRepeatType.getType(annotationClass).alternativeAnnotationClass();
        for (Layer layer : this.layers) {
            T annotation = layer.annotatedElement.getAnnotation(annotationClass);
            if (annotation != null) {
                return annotation;
            }
            if (altAnnotationClass == null || !layer.annotatedElement.isAnnotationPresent(altAnnotationClass)) continue;
            return null;
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.layers.isEmpty()) {
            return EMPTY_ANNOTATIONS;
        }
        if (this.layers.size() == 1) {
            return this.layers.get(0).annotatedElement.getAnnotations();
        }
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Layer layer : this.layers) {
            for (Annotation layerAnnotation : layer.annotatedElement.getAnnotations()) {
                Class<? extends Annotation> layerAltClass;
                Class<? extends Annotation> layerAnnotationClass = layerAnnotation.annotationType();
                if (annotations.containsKey(layerAnnotationClass) || annotations.containsKey(layerAltClass = AnnotationRepeatType.getType(layerAnnotationClass).alternativeAnnotationClass())) continue;
                annotations.put(layerAnnotationClass, layerAnnotation);
            }
        }
        return annotations.values().toArray(new Annotation[0]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        if (this.layers.isEmpty()) {
            return EMPTY_ANNOTATIONS;
        }
        if (this.layers.size() == 1) {
            return this.layers.get(0).annotatedElement.getDeclaredAnnotations();
        }
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Layer layer : this.layers) {
            for (Annotation layerAnnotation : layer.annotatedElement.getDeclaredAnnotations()) {
                Class<? extends Annotation> layerAltClass;
                Class<? extends Annotation> layerAnnotationClass = layerAnnotation.annotationType();
                if (annotations.containsKey(layerAnnotationClass) || annotations.containsKey(layerAltClass = AnnotationRepeatType.getType(layerAnnotationClass).alternativeAnnotationClass())) continue;
                annotations.put(layerAnnotationClass, layerAnnotation);
            }
        }
        return annotations.values().toArray(new Annotation[0]);
    }

    private static final class Layer {
        private final TypeAnnotationLayer layer;
        private final AnnotatedElement annotatedElement;

        @Generated
        public Layer(TypeAnnotationLayer layer, AnnotatedElement annotatedElement) {
            this.layer = layer;
            this.annotatedElement = annotatedElement;
        }

        @Generated
        public TypeAnnotationLayer layer() {
            return this.layer;
        }

        @Generated
        public AnnotatedElement annotatedElement() {
            return this.annotatedElement;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Layer)) {
                return false;
            }
            Layer other = (Layer)o;
            TypeAnnotationLayer this$layer = this.layer();
            TypeAnnotationLayer other$layer = other.layer();
            if (this$layer == null ? other$layer != null : !this$layer.equals(other$layer)) {
                return false;
            }
            AnnotatedElement this$annotatedElement = this.annotatedElement();
            AnnotatedElement other$annotatedElement = other.annotatedElement();
            return !(this$annotatedElement == null ? other$annotatedElement != null : !this$annotatedElement.equals(other$annotatedElement));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeAnnotationLayer $layer = this.layer();
            result = result * 59 + ($layer == null ? 43 : $layer.hashCode());
            AnnotatedElement $annotatedElement = this.annotatedElement();
            result = result * 59 + ($annotatedElement == null ? 43 : $annotatedElement.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LayeredTypeAnnotations.Layer(layer=" + this.layer() + ", annotatedElement=" + this.annotatedElement() + ")";
        }
    }
}

